package com.ejianc.business.procost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.bean.CostDetailEntity;
import com.ejianc.business.procost.bean.ShareDetailEntity;
import com.ejianc.business.procost.bean.ShareEntity;
import com.ejianc.business.procost.service.ICostDetailService;
import com.ejianc.business.procost.service.IShareDetailService;
import com.ejianc.business.procost.service.IShareService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;

@Service("share") 
public class ShareBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IShareService shareService;

	@Autowired
	private IShareDetailService shareDetailService;

	@Autowired
	private ICostDetailService costDetailService;

	@Autowired
	private ICommenQueryFieldsService commenQueryFieldsService;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		LambdaQueryWrapper<ShareDetailEntity> lambda = Wrappers.<ShareDetailEntity>lambdaQuery();
		lambda.eq(ShareDetailEntity::getShareId,billId);
		lambda.ne(ShareDetailEntity::getSubjectFlag,1);
		List<ShareDetailEntity> list = shareDetailService.list(lambda);
		if(CollectionUtils.isNotEmpty(list)){
			return CommonResponse.error("该单据存在未关联科目明细，不允许提交!");
		}else{
			return CommonResponse.success();
		}
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if(BillStateEnum.UNCOMMITED_STATE.getBillStateCode() == state){
			LambdaQueryWrapper<ShareDetailEntity> lambda = Wrappers.<ShareDetailEntity>lambdaQuery();
			lambda.eq(ShareDetailEntity::getShareId,billId);
			lambda.ne(ShareDetailEntity::getSubjectFlag,1);
			List<ShareDetailEntity> list = shareDetailService.list(lambda);
			if(CollectionUtils.isNotEmpty(list)){
				return CommonResponse.error("该单据存在未关联科目明细，不允许提交!");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//回写各个单据分摊状态 为已分摊
		ShareEntity shareEntity = shareService.selectById(billId);
		List<ShareDetailEntity> list = shareEntity.getShareDetail();
		List<Long> sourceIds = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(list)){
			list.forEach(e->{
				sourceIds.add(e.getSourceId());
				commenQueryFieldsService.updateProportionFlag(e.getBillType(),String.valueOf(e.getSourceId()),"1");
			});
		}
		LambdaUpdateWrapper<CostDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(CostDetailEntity::getSourceId,sourceIds);
		updateWrapper.set(CostDetailEntity::getPeriod,shareEntity.getPeriod());
		updateWrapper.set(CostDetailEntity::getProportionFlag,"1");
		costDetailService.update(updateWrapper);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ShareEntity shareEntity = shareService.selectById(billId);
		LambdaQueryWrapper<ShareEntity> lambda = Wrappers.<ShareEntity>lambdaQuery();
		lambda.eq(ShareEntity::getProjectId,shareEntity.getProjectId());
		lambda.gt(ShareEntity::getPeriod,shareEntity.getPeriod());
		List<ShareEntity> list = shareService.list(lambda);
		if(CollectionUtils.isNotEmpty(list)){
			return CommonResponse.error("该单据存在比当前撤回期间更晚的数据，不允许回退!");
		}

		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//回写各个单据分摊状态 为未分摊
		ShareEntity shareEntity = shareService.selectById(billId);
		List<ShareDetailEntity> list = shareEntity.getShareDetail();
		List<Long> sourceIds = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(list)){
			list.forEach(e->{
				sourceIds.add(e.getSourceId());
				commenQueryFieldsService.updateProportionFlag(e.getBillType(),String.valueOf(e.getSourceId()),"0");
			});
		}
		LambdaUpdateWrapper<CostDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(CostDetailEntity::getSourceId,sourceIds);
		updateWrapper.set(CostDetailEntity::getPeriod,"");
		updateWrapper.set(CostDetailEntity::getProportionFlag,"0");
		costDetailService.update(updateWrapper);
		return CommonResponse.success();
	}

}
