/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.service.impl;

import com.ejianc.business.procost.bean.UnitDetailEntity;
import com.ejianc.business.procost.bean.UnitEntity;
import com.ejianc.business.procost.mapper.UnitMapper;
import com.ejianc.business.procost.service.IUnitDetailService;
import com.ejianc.business.procost.service.IUnitService;
import com.ejianc.business.procost.utils.TreeNodeBUtil;
import com.ejianc.business.procost.vo.UnitDetailVO;
import com.ejianc.business.procost.vo.UnitVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="unitService")
public class UnitServiceImpl
extends BaseServiceImpl<UnitMapper, UnitEntity>
implements IUnitService {
    @Autowired
    private IUnitDetailService unitDetailService;

    @Override
    public List<UnitVO> saveUnitBatch(List<UnitVO> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return voList;
        }
        ((UnitMapper)this.baseMapper).deleteUnitAll();
        List entityList = BeanMapper.mapList(voList, UnitEntity.class);
        super.saveOrUpdateBatch((Collection)entityList);
        return this.buildUnitTree(entityList);
    }

    @Override
    public List<UnitDetailVO> saveUnitDetailBatch(List<UnitDetailVO> detailList) {
        if (CollectionUtils.isEmpty(detailList)) {
            return detailList;
        }
        Long pid = detailList.get(0).getPid();
        ((UnitMapper)this.baseMapper).deleteUnitDetailByPid(pid);
        List detailEntityList = BeanMapper.mapList(detailList, UnitDetailEntity.class);
        this.unitDetailService.saveOrUpdateBatch(detailEntityList);
        return BeanMapper.mapList((Iterable)detailEntityList, UnitDetailVO.class);
    }

    @Override
    public List<UnitVO> queryUnitList(QueryParam param) {
        List unitEntityList = super.queryList(param, false);
        List<UnitVO> voList = this.buildUnitTree(unitEntityList);
        return voList;
    }

    private List<UnitVO> buildUnitTree(List<UnitEntity> unitEntityList) {
        if (CollectionUtils.isNotEmpty(unitEntityList)) {
            return TreeNodeBUtil.buildTree((List)BeanMapper.mapList(unitEntityList, UnitVO.class));
        }
        return new ArrayList<UnitVO>();
    }

    @Override
    public List<UnitDetailVO> queryUnitDetailByPid(Long pid) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("eq", (Object)pid));
        List list = this.unitDetailService.queryList(queryParam, false);
        return BeanMapper.mapList((Iterable)list, UnitDetailVO.class);
    }

    @Override
    public Map<Long, List<UnitDetailVO>> queryUnitDetailMap() {
        Map<Long, List<UnitDetailVO>> rtnMap = new HashMap<Long, List<UnitDetailVO>>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("parentId", new Parameter("ne", null));
        List unitList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)unitList)) {
            return rtnMap;
        }
        List parentIdList = unitList.stream().map(UnitEntity::getParentId).collect(Collectors.toList());
        QueryParam cParam = new QueryParam();
        cParam.getParams().put("id", new Parameter("not_in", parentIdList));
        List cList = super.queryList(cParam, false);
        if (CollectionUtils.isEmpty((Collection)cList)) {
            return rtnMap;
        }
        List idList = cList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("pid", new Parameter("in", idList));
        List detailList = this.unitDetailService.queryList(detailParam, false);
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return rtnMap;
        }
        List detailVoList = BeanMapper.mapList((Iterable)detailList, UnitDetailVO.class);
        rtnMap = detailVoList.stream().collect(Collectors.groupingBy(UnitDetailVO::getPid));
        return rtnMap;
    }
}

