package com.ejianc.business.procost.service;

import com.ejianc.business.procost.vo.UnitDetailVO;
import com.ejianc.business.procost.vo.UnitVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.procost.bean.UnitEntity;

import java.util.List;
import java.util.Map;

/**
 * 主材量价对比主表
 *
 * @author generator
 */
public interface IUnitService extends IBaseService<UnitEntity> {

    /**
     * 批量进行保存
     *
     * @param voList 数据
     * @return 保存结果
     */
    List<UnitVO> saveUnitBatch(List<UnitVO> voList);

    /**
     * 批量保存子表数据
     *
     * @param detailList 子表数据
     * @return 保存结果
     */
    List<UnitDetailVO> saveUnitDetailBatch(List<UnitDetailVO> detailList);

    /**
     * 查询列表
     *
     * @param param 查询条件
     * @return 查询结果
     */
    List<UnitVO> queryUnitList(QueryParam param);

    /**
     * 根据父id查询字表列表
     *
     * @param pid 父ID
     * @return 查询结果
     */
    List<UnitDetailVO> queryUnitDetailByPid(Long pid);

    /**
     * 查询末级及末级对应的子集列表
     *
     * @return 查询结果
     */
    Map<Long, List<UnitDetailVO>> queryUnitDetailMap();

    /**
     * 将传过来的列表组装成树
     *
     * @param voList 页面数据
     * @return 树形
     */
    List<UnitVO> packUnitTree(List<UnitVO> voList);
}
