package com.ejianc.business.procost.controller.desktop;

import com.ejianc.business.procost.service.IShareService;
import com.ejianc.business.procost.utils.TreeNodeBUtil;
import com.ejianc.business.procost.vo.ThreeReportVO;
import com.ejianc.business.procost.vo.desktop.DesktopThreeReportVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author songlx
 * @version 1.0
 * @description: 工程门户接口
 * @date 2022/6/13
 */

@RestController
@RequestMapping("procostDesktop")
public class ProcostDesktopController implements Serializable {


    @Autowired
    private IShareService shareService;


    @Autowired
    IProjectPoolApi projectPoolApi;


    /**
     * @param orgId
     * @description: 三算对比图
     * @return: com.ejianc.framework.core.response.CommonResponse<java.util.List < com.ejianc.business.procost.vo.ThreeReportVO>>
     * @author songlx
     * @date: 2022/6/13
     */
    @RequestMapping(value = "/queryThreeReport", method = RequestMethod.GET)
    public CommonResponse<DesktopThreeReportVO> queryThreeReport(@RequestParam(value = "orgId") Long orgId) {
        CommonResponse<List<ProjectPoolSetVO>> listCommonResponse = projectPoolApi.queryProjectListByProjectDepartmentId(orgId);
        if (!listCommonResponse.isSuccess() || CollectionUtils.isEmpty(listCommonResponse.getData())) {
            return CommonResponse.error("未查询到该组织下面的项目信息！");
        }
        List<ProjectPoolSetVO> data = listCommonResponse.getData();
        ProjectPoolSetVO projectPoolSetVO = data.get(0);
        String endPeriod = DateFormatUtil.formatDate("yyyy-MM", new Date());
        List<ThreeReportVO> list = shareService.getThreeReports(projectPoolSetVO.getId(), endPeriod);
        DesktopThreeReportVO resObj = new DesktopThreeReportVO();
        List<BigDecimal> incomeBudget = resObj.getIncomeBudget();
        List<BigDecimal> targetCost = resObj.getTargetCost();
        List<BigDecimal> realCost = resObj.getRealCost();
        List<BigDecimal> incomeTargetRate = resObj.getIncomeTargetRate();
        List<BigDecimal> targetRealRate = resObj.getTargetRealRate();
        List<BigDecimal> incomeRealRate = resObj.getIncomeRealRate();

        //01人工费、03机械费、02材料费、04专业分包、other其他费
        if (CollectionUtils.isNotEmpty(list)) {
            List<ThreeReportVO> threeReportVOS = TreeNodeBUtil.buildTree(list);
            //其他费的三个比例不能直接相加，需要重新计算
            Map<String, BigDecimal> otherDataMap = new HashMap<>();
            for (ThreeReportVO threeReportVO : threeReportVOS) {
                int index = 0;
                if ("01".equals(threeReportVO.getSubjectCode())) {
                    index = 0;
                } else if ("03".equals(threeReportVO.getSubjectCode())) {
                    index = 1;
                } else if ("02".equals(threeReportVO.getSubjectCode())) {
                    index = 2;
                } else if ("04".equals(threeReportVO.getSubjectCode())) {
                    index = 3;
                } else {
                    index = 4;
                    //放如三个差额
                    otherDataMap.put("otherSrmbdifMny", ComputeUtil.safeAdd(otherDataMap.get("otherSrmbdifMny"), threeReportVO.getSrmbdifMny()));
                    otherDataMap.put("otherMbsjdifMny", ComputeUtil.safeAdd(otherDataMap.get("otherMbsjdifMny"), threeReportVO.getMbsjdifMny()));
                    otherDataMap.put("otherSrsjdifMny", ComputeUtil.safeAdd(otherDataMap.get("otherSrsjdifMny"), threeReportVO.getSrsjdifMny()));
                }

                incomeBudget.set(index, ComputeUtil.safeAdd(incomeBudget.get(index), threeReportVO.getYsHappenMny()));
                targetCost.set(index, ComputeUtil.safeAdd(targetCost.get(index), threeReportVO.getCbHappenMny()));
                realCost.set(index, ComputeUtil.safeAdd(realCost.get(index), threeReportVO.getHappenMny()));
                //其他费用
                if (index == 4) {
                    BigDecimal otherSrmbdifMny = ComputeUtil.isGreaterThan(otherDataMap.get("otherSrmbdifMny"), BigDecimal.ZERO) ? otherDataMap.get("otherSrmbdifMny") : BigDecimal.ZERO;
                    BigDecimal otherMbsjdifMny = ComputeUtil.isGreaterThan(otherDataMap.get("otherMbsjdifMny"), BigDecimal.ZERO) ? otherDataMap.get("otherMbsjdifMny") : BigDecimal.ZERO;
                    BigDecimal otherSrsjdifMny = ComputeUtil.isGreaterThan(otherDataMap.get("otherSrsjdifMny"), BigDecimal.ZERO) ? otherDataMap.get("otherSrsjdifMny") : BigDecimal.ZERO;
                    // 收入与目标比率
                    incomeTargetRate.set(index, ComputeUtil.safeDiv(otherSrmbdifMny, incomeBudget.get(index)));
                    // 目标与实际比率
                    targetRealRate.set(index, ComputeUtil.safeDiv(otherMbsjdifMny, targetCost.get(index)));
                    // 收入与实际比率
                    incomeRealRate.set(index, ComputeUtil.safeDiv(otherSrsjdifMny, incomeBudget.get(index)));
                } else {
                    incomeTargetRate.set(index, ComputeUtil.safeAdd(incomeTargetRate.get(index), threeReportVO.getSrmbRate()));
                    targetRealRate.set(index, ComputeUtil.safeAdd(targetRealRate.get(index), threeReportVO.getMbsjRate()));
                    incomeRealRate.set(index, ComputeUtil.safeAdd(incomeRealRate.get(index), threeReportVO.getSrsjRate()));
                }

            }


        }
        return CommonResponse.success("查询详情数据成功！", resObj);
    }

    public static void main(String[] args) {
        String endPeriod = DateFormatUtil.formatDate("yyyy-MM", new Date());
        System.out.println(endPeriod);
    }
}
