package com.ejianc.business.procost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.procost.bean.UnitDetailEntity;
/**
 * 主材量价对比主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_procost_unit")
public class UnitEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="subject_name")
    private String subjectName; // 成本科目名称
    @TableField(value="subject_code")
    private String subjectCode; // 成本科目编码
    @TableField(value="memo")
    private String memo; // 描述
    @TableField(value="org_subject_id")
    private Long orgSubjectId; // 集团成本科目主键
    @TableField(value="parent_id")
    private Long parentId; // 父id
    @TableField(value="inner_code")
    private String innerCode; // 内置编码
    @TableField(value="enabled")
    private Integer enabled; // 是否启用 1启用 0禁用
    @TableField(value="unit_id")
    private Long unitId; // 计量单位主键
    @TableField(value="unit_name")
    private String unitName; // 计量单位
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="unitDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<UnitDetailEntity> unitDetailList = new ArrayList<>(); // 主材量价对比子表
    

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOrgSubjectId() {
        return orgSubjectId;
    }

    public void setOrgSubjectId(Long orgSubjectId) {
        this.orgSubjectId = orgSubjectId;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    
    public List<UnitDetailEntity> getUnitDetailList() {
        return unitDetailList;
    }

    public void setUnitDetailList(List<UnitDetailEntity> unitDetailList) {
        this.unitDetailList = unitDetailList;
    }
}
