package com.ejianc.business.procost.service.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.api.IProincomeBudgetApi;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.BudgetReportVO;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.business.procost.bean.*;
import com.ejianc.business.procost.mapper.ShareMapper;
import com.ejianc.business.procost.service.*;
import com.ejianc.business.procost.util.DateUtil;
import com.ejianc.business.procost.vo.*;
import com.ejianc.business.targetcost.api.ITargetCostFinishApi;
import com.ejianc.business.targetcost.vo.CostReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * 成本分摊
 * 
 * @author generator
 * 
 */
@Service("shareService")
public class ShareServiceImpl extends BaseServiceImpl<ShareMapper, ShareEntity> implements IShareService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillSettingService billSettingService;

    @Autowired
    private ISettingService settingService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IShareDetailService shareDetailService;

    @Autowired
    private IProincomeBudgetApi budgetApi;
    @Autowired
    private IProincomeContractApi proincomeContractApi;

    @Autowired
    private IUnitService unitService;

    @Autowired
    private ITargetCostFinishApi targetCostFinishApi;

    @Autowired
    private IShareProjectWbsApi shareProjectWbsApi;

    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;

    @Autowired
    private ICommenQueryFieldsService commenQueryFieldsService;

    @Value("${procost.costSubjectId}")
    private String costSubjectId;

    @Override
    public CommonResponse<ShareVO> saveOrUpdateShare(ShareVO saveorUpdateVO) {
        if(CollectionUtils.isEmpty(saveorUpdateVO.getShareDetail())){
            return CommonResponse.error("费用项明细不允许为空!");
        }
        LambdaQueryWrapper<ShareEntity> lambda2 = Wrappers.<ShareEntity>lambdaQuery();
        lambda2.eq(ShareEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda2.eq(ShareEntity::getProjectId,saveorUpdateVO.getProjectId());
        if(null!=saveorUpdateVO.getId()){
            lambda2.ne(ShareEntity::getId,saveorUpdateVO.getId());
        }
        lambda2.notIn(ShareEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<ShareEntity> list = super.list(lambda2);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("该项目已存在未生效单据,请先处理未生效单据！");
        }

        LambdaQueryWrapper<ShareEntity> lambda = Wrappers.<ShareEntity>lambdaQuery();
        lambda.eq(ShareEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(ShareEntity::getProjectId,saveorUpdateVO.getProjectId());
        lambda.eq(ShareEntity::getPeriod,saveorUpdateVO.getPeriod());
        if(null!=saveorUpdateVO.getId()){
            lambda.ne(ShareEntity::getId,saveorUpdateVO.getId());
        }
        List<ShareEntity> list2 = super.list(lambda);
        if(CollectionUtils.isNotEmpty(list2)){
            return CommonResponse.error("该项目的成本期间已存在,不允许重复新增");
        }


        LambdaQueryWrapper<ShareEntity> lambda3 = Wrappers.<ShareEntity>lambdaQuery();
        lambda3.eq(ShareEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda3.eq(ShareEntity::getProjectId,saveorUpdateVO.getProjectId());
        if(null!=saveorUpdateVO.getId()){
            lambda3.ne(ShareEntity::getId,saveorUpdateVO.getId());
        }
        lambda3.gt(ShareEntity::getPeriod,saveorUpdateVO.getPeriod());
        lambda3.orderByDesc(ShareEntity::getPeriod);
        List<ShareEntity> list3 = super.list(lambda3);
        if(CollectionUtils.isNotEmpty(list3)){
            return CommonResponse.error("不允许早于最大成本期间,该项目的最大成本期间为【"+list3.get(0).getPeriod()+"】");
        }
        ShareEntity entity = BeanMapper.map(saveorUpdateVO, ShareEntity.class);
        if(null!=entity.getId()){
            LambdaQueryWrapper<ShareDetailEntity> lambdaDetail = Wrappers.<ShareDetailEntity>lambdaQuery();
            lambdaDetail.eq(ShareDetailEntity::getTenantId,InvocationInfoProxy.getTenantid());
            lambdaDetail.eq(ShareDetailEntity::getShareId,entity.getId());
            //修改需要先情况所有子表
            shareDetailService.remove(lambdaDetail);
            List<ShareDetailEntity> shareDetailEntities = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(entity.getShareDetail())){
                entity.getShareDetail().forEach(e->{
                    if(!"del".equals(e.getRowState())){
                        e.setId(null);
                        shareDetailEntities.add(e);
                    }
                });
                entity.setShareDetail(shareDetailEntities);
            }
        }
        super.saveOrUpdate(entity, false);
        BigDecimal sumCostMny = entity.getSumCostMny()==null?BigDecimal.ZERO:entity.getSumCostMny();
        BigDecimal costMny = entity.getCostMny()==null?BigDecimal.ZERO:entity.getCostMny();
        ShareVO vo = BeanMapper.map(entity, ShareVO.class);
        vo.setSumCostMnys(sumCostMny.add(costMny));
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public List<MonthVO> getMonths(Long projectId, String year) {
        return baseMapper.geMonths(projectId,year);
    }

    @Override
    public List<SubjectReportVO> getSubjectReport(Long projectId, String period, int type,Long wbsId) {
        CommonResponse<List<SubjectOrgVO>> resDate= shareSubjectOrgApi.shareSubjectOrgApi();
        if(!resDate.isSuccess()) {
            throw new BusinessException("查询科目信息失败!");
        }
        List<Long> wbsIdList = new ArrayList<>();
        if(wbsId!=null){
            CommonResponse<List<ProjectWbsVO>> commonResponse = shareProjectWbsApi.queryProjectWbsList(wbsId);
            if(!commonResponse.isSuccess()) {
                throw new BusinessException("查询核算对象信息失败!");
            }
            List<ProjectWbsVO> projectWbsVOList = commonResponse.getData();
            wbsIdList = projectWbsVOList.stream().map(ProjectWbsVO::getId).collect(Collectors.toList());
        }
        List<SubjectReportsVO> list = baseMapper.getSubjectReport(projectId,period,0,wbsIdList);
        List<SubjectReportsVO> listsum = baseMapper.getSubjectReport(projectId,period,1,wbsIdList);
        Map<Long,BigDecimal> map = new HashMap<>();
        Map<Long,SubjectReportsVO> mapList = new HashMap<>();
        if(CollectionUtils.isNotEmpty(listsum)){
            listsum.forEach(e->{
                map.put(e.getSubjectId(),e.getHappenMny()==null?BigDecimal.ZERO:e.getHappenMny());
            });
        }
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(e->{
//                if(map.containsKey(e.getSubjectId())){
//                    e.setHappenMnySum(map.get(e.getSubjectId()));
//                }
                mapList.put(e.getSubjectId(),e);
            });
        }

        List<SubjectOrgVO> subjectOrgVOList = resDate.getData();
        List<SubjectReportsVO> allList = new ArrayList<>();
        for(int i=0;i<subjectOrgVOList.size();i++){
            SubjectOrgVO subjectOrgVO = subjectOrgVOList.get(i);
            SubjectReportsVO vo = new SubjectReportsVO();
            vo.setId(subjectOrgVO.getId());
            vo.setNumber(i+1);
            vo.setSubjectId(subjectOrgVO.getId());
            vo.setSubjectCode(subjectOrgVO.getSubjectCode());
            vo.setSubjectName(subjectOrgVO.getSubjectName());
            vo.setParentId(subjectOrgVO.getParentId());
            SubjectReportsVO subjectReportsVO = mapList.get(subjectOrgVO.getId());
            if(null!=subjectReportsVO){
                vo.setHappenDate(subjectReportsVO.getHappenDate());
                vo.setHappenMny(subjectReportsVO.getHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMny());
            }else{
                vo.setHappenDate(null);
                vo.setHappenMny(BigDecimal.ZERO);
            }
            vo.setHappenMnySum(map.get(subjectOrgVO.getId())==null?BigDecimal.ZERO:map.get(subjectOrgVO.getId()));
            allList.add(vo);
        }


        SubjectReportsVO tempVo = new SubjectReportsVO();
        tempVo.setId(999L);
        tempVo.setNumber(0);
        tempVo.setParentId(000L);
        allList.add(tempVo);
        List<SubjectReportsVO> listres = new ArrayList<>();
        SubjectReportsVO vo =   calculateValue(allList);
        printGoal(vo,listres);
        listres = listres.stream().sorted(Comparator.comparing(SubjectReportsVO::getNumber)).collect(Collectors.toList());
        if(0==type){
            listres.remove(0);
            return BeanMapper.mapList(listres,SubjectReportVO.class);
        }else{
            List<SubjectReportVO> lists = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(listres)){
                listres.forEach(e->{
                    if(000L!=e.getParentId()&&BigDecimal.ZERO.compareTo(e.getHappenMny()==null?BigDecimal.ZERO:e.getHappenMny())!=0){
                        lists.add(BeanMapper.map(e,SubjectReportVO.class));
                    }
                });
            }
            return lists;
        }
    }


    /*
        二维表树形思路
        1，取成本发生的有效数据，分组出期间(列信息)
        2，取科目树(行信息)
        3，循环科目树，期间，有效数据，合成map<科目主键+期间 组合主键，List<本期成本金额,含本期累计>>
        4，根据科目树增加列信息，根据行+列找map 对应的数据
     */
    @Override
    public List<TemplateDatas> getSubjectReportAlls(Long projectId, List<String> periods, int type) {
        //查询审批通过的成本分摊对应发生的金额
        List<SubjectReportsVO> costDetailList = baseMapper.getCostDetails(projectId);

        //科目树
        List<SubjectReportVO> costSetting = baseMapper.getCostSetting(projectId);

        Set<String> period = new HashSet<>();
        List<String> fields = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(costDetailList)){
            costDetailList.forEach(e->{
                if(StringUtils.isNotEmpty(e.getPeriod())){
                    period.add(e.getPeriod());
                }
            });
            List<String> periodList = new ArrayList<>(period);
            if(CollectionUtils.isNotEmpty(period)){
                for(int i=0;i<periodList.size();i++){
                    fields.add(periodList.get(i));
                }
                Collections.sort(fields);
            }
        }
        //map<科目主键+期间 组合主键，List<本期成本金额,含本期累计>>
        Map<String,List<BigDecimal>> maps = new HashMap<>();
        if(CollectionUtils.isNotEmpty(costSetting)) {
            for(int i=0;i<costSetting.size();i++){
                Long subjectId = costSetting.get(i).getId();
                for(int k=0;k<fields.size();k++){
                    String nowPeriod = fields.get(k)==null?"":fields.get(k);
                    BigDecimal happenMnySum = BigDecimal.ZERO;//当前期间合计
                    BigDecimal happenMnySums = BigDecimal.ZERO;//不含当期间累计
                    for(int n=0;n<costDetailList.size();n++){
                        String dateString = costDetailList.get(n).getPeriod();
                        if(subjectId.equals(costDetailList.get(n).getSubjectId())&&nowPeriod.compareTo(dateString)>0){
                            BigDecimal happenMny= costDetailList.get(n).getHappenMny()==null?BigDecimal.ZERO:costDetailList.get(n).getHappenMny();
                            happenMnySums = happenMnySums.add(happenMny);
                        }else if(subjectId.equals(costDetailList.get(n).getSubjectId())&&nowPeriod.compareTo(dateString)==0){
                            BigDecimal happenMny= costDetailList.get(n).getHappenMny()==null?BigDecimal.ZERO:costDetailList.get(n).getHappenMny();
                            happenMnySum = happenMnySum.add(happenMny);
                        }
                    }
                    List<BigDecimal> listnew = new ArrayList<>();
                    listnew.add(happenMnySum);
                    listnew.add(happenMnySum.add(happenMnySums));
                    maps.put(subjectId+nowPeriod,listnew);
                }
            }
        }

        //循环科目树
        List<TemplateDatas> listRes = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(costSetting)) {
            for(int i=0;i<costSetting.size();i++){
                SubjectReportVO e = costSetting.get(i);
                TemplateDatas td = TemplateDatas.New();
                td = BeanMapper.map(e,TemplateDatas.class);
                BigDecimal periodMnys = BigDecimal.ZERO;
                if(CollectionUtils.isNotEmpty(periods)){
                    //说明前端传回个别期间，需按照前端传的显示
                    for(String key:periods){
                        td.addField(key,key);
                        td.addField(key+"-Sum","含本期累计");
                        if(maps.containsKey(e.getId()+key)){
                            td.add(key,maps.get(e.getId()+key).get(0));
                            periodMnys = periodMnys.add(maps.get(e.getId()+key).get(0));
                            td.add(key+"-Sum",maps.get(e.getId()+key).get(1));
                        }else{
                            td.add(key,BigDecimal.ZERO);
                            td.add(key+"-Sum",BigDecimal.ZERO);
                        }
                    }
                }else{
                    //说明前端没传期间，需按照所有的显示
                    for(String key:fields){
                        td.addField(key,key);
                        td.addField(key+"-Sum","含本期累计");
                        if(maps.containsKey(e.getId()+key)){
                            td.add(key,maps.get(e.getId()+key).get(0));
                            periodMnys = periodMnys.add(maps.get(e.getId()+key).get(0));
                            td.add(key+"-Sum",maps.get(e.getId()+key).get(1));
                        }else{
                            td.add(key,BigDecimal.ZERO);
                            td.add(key+"-Sum",BigDecimal.ZERO);
                        }
                    }
                }

                td.setNumber(i+1);
                td.setPeriodMnys(periodMnys);
                listRes.add(td);
            }
        }
        return listRes;
    }

    @Override
    public SubjectReportVO queryProReports(HttpServletRequest request,Long projectId) {
        LambdaQueryWrapper<SettingEntity> lambda = Wrappers.<SettingEntity>lambdaQuery();
        lambda.eq(SettingEntity::getTenantId,InvocationInfoProxy.getTenantid());
//        lambda.eq(SettingEntity::getProjectId,projectId);
//        lambda.in(SettingEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<SettingEntity> shareEntityList = settingService.list(lambda);

        SubjectReportVO resVo = new SubjectReportVO();
        LambdaQueryWrapper<ShareEntity> lambda2 = Wrappers.<ShareEntity>lambdaQuery();
        lambda2.eq(ShareEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda2.eq(ShareEntity::getProjectId,projectId);
        lambda2.in(ShareEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<ShareEntity> list = super.list(lambda2);
        BigDecimal happenMny = list.stream().map(ShareEntity::getCostMny).reduce(BigDecimal.ZERO,BigDecimal::add);
        resVo.setHappenMny(happenMny);//项目已分摊成本
        if(CollectionUtils.isNotEmpty(shareEntityList)){
            List<ShareDetailVO> listDetail = getDetail(projectId,"",shareEntityList.get(0).getTaxFlag(),null,shareEntityList.get(0).getMaterialCost(),1,request);
            BigDecimal sum = listDetail.stream().map(ShareDetailVO::getHappenMny).reduce(BigDecimal.ZERO,BigDecimal::add);
            resVo.setHappenMnySum(sum);
        }
        return resVo;
    }


    @Override
    public List<ShareDetailVO> getDetail(Long projectId, String endDay, String taxFlag,String billType,String materialCost,int type, HttpServletRequest request) {
        //type 0 -成本节点使用     type= 1  报表使用
        List<BillSettingEntity> list = new ArrayList<>();
        List<ShareDetailVO> listRes = new ArrayList<>();
        if(null!=billType&&!"".equals(billType)){
            QueryWrapper<BillSettingEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("bill_type_code",billType);
            queryWrapper.ne("type",9);
            list = billSettingService.list(queryWrapper);
        }else{
            QueryWrapper<BillSettingEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.in("type",2);
            list = billSettingService.list(queryWrapper);
        }
        String authority = request.getHeader("authority");
        //创建一个固定数量的线程池
        ExecutorService threadPool = null;
        try {
            threadPool = Executors.newFixedThreadPool(list.size());
            List<Future<JSONObject>> callables = new ArrayList<>();
            for(BillSettingEntity entity:list ){
                logger.info("condition拼接前---："+entity.getBillType());
                String condition = "";
                if(null!=endDay&&!"".equals(endDay)){
                    condition = entity.getConditions().replace("projectId","'"+projectId+"'").replace("endDate","'"+endDay+"'");
                }else if(type==1){
                    condition = entity.getConditions().replace("projectId","'"+projectId+"'");
                    String endDate = condition.substring(condition.lastIndexOf("and proportion_flag != 1"),condition.lastIndexOf("order")-1);
                    condition = condition.replace(endDate,"");
                }else {
                    condition = entity.getConditions().replace("projectId","'"+projectId+"'");
                    String endDate = condition.substring(condition.lastIndexOf("and "),condition.lastIndexOf("order")-1);
                    condition = condition.replace(endDate,"");
                }
                logger.info("condition拼接后---："+condition);
                Callable<JSONObject> shareDetailCallable = new ShareServiceImpl.BillDetailCallable(RequestContextHolder.getRequestAttributes(),entity.getBillTypeCode(),entity.getParameter(),condition,authority,taxFlag,entity.getPath());
                Future<JSONObject> shareDetailFuture = threadPool.submit(shareDetailCallable);
                callables.add(shareDetailFuture);
            }

            for(Future<JSONObject> callable:callables){
                JSONObject json = callable.get();
//                System.out.println(json);
                if(null!=json && null!=json.get("jsonRes")){
//                    System.out.println(json.get("jsonRes"));
                    listRes.addAll((List<ShareDetailVO>)json.get("jsonRes"));
                }
            }
        } catch (Exception e) {
            logger.error("获取单据信息异常：", e);
        } finally {
            if(null!=threadPool){
                threadPool.shutdown();
            }
        }
        return listRes;
    }

    @Override
    public SubjectFlagVO getSubkectFlag(Long sourceId, String billType) {
        BillSettingEntity billSettingEntity = new BillSettingEntity();
        LambdaQueryWrapper<BillSettingEntity> lambda = Wrappers.<BillSettingEntity>lambdaQuery();
        lambda.eq(BillSettingEntity::getType,9);
        billSettingEntity = billSettingService.getOne(lambda);
        List<Map<String, Object>> list = commenQueryFieldsService.queryBillList(billType,billSettingEntity.getParameter(),billSettingEntity.getConditions().replace("billId","'"+sourceId+"'"));
        SubjectFlagVO newsVos = null;
        if(CollectionUtils.isNotEmpty(list)){
            newsVos = BeanMapper.map(list.get(0), SubjectFlagVO.class);
        }
        return newsVos;
    }

    @Override
    public List<SubjectReportVO> getCostAllDetails(Long projectId, String beginPeriod, String endPeriod) {
        int type = 0;//是否显示为0的数据    0-显示  1-不显示
        CommonResponse<List<SubjectOrgVO>> resDate= shareSubjectOrgApi.shareSubjectOrgApi();
        if(!resDate.isSuccess()) {
            throw new BusinessException("查询科目信息失败!");
        }
        List<SubjectReportsVO> listsum = baseMapper.getCostAllDetails(projectId,beginPeriod,endPeriod);
        Map<Long,BigDecimal> map = new HashMap<>();
        Map<Long,SubjectReportsVO> mapList = new HashMap<>();
        if(CollectionUtils.isNotEmpty(listsum)){
            listsum.forEach(e->{
                mapList.put(e.getSubjectId(),e);
            });
        }

        List<SubjectOrgVO> subjectOrgVOList = resDate.getData();
        List<SubjectReportsVO> allList = new ArrayList<>();
        for(int i=0;i<subjectOrgVOList.size();i++){
            SubjectOrgVO subjectOrgVO = subjectOrgVOList.get(i);
            SubjectReportsVO vo = new SubjectReportsVO();
            vo.setId(subjectOrgVO.getId());
            vo.setNumber(i+1);
            vo.setSubjectId(subjectOrgVO.getId());
            vo.setSubjectCode(subjectOrgVO.getSubjectCode());
            vo.setSubjectName(subjectOrgVO.getSubjectName());
            vo.setParentId(subjectOrgVO.getParentId());
            SubjectReportsVO subjectReportsVO = mapList.get(subjectOrgVO.getId());
            if(null!=subjectReportsVO){
                vo.setHappenDate(subjectReportsVO.getHappenDate());
                vo.setHappenMny(subjectReportsVO.getHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMny());
                vo.setHappenMnySum(subjectReportsVO.getHappenMnySum()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMnySum());
            }else{
                vo.setHappenDate(null);
                vo.setHappenMny(BigDecimal.ZERO);
                vo.setHappenMnySum(BigDecimal.ZERO);
            }
            allList.add(vo);
        }


        SubjectReportsVO tempVo = new SubjectReportsVO();
        tempVo.setId(999L);
        tempVo.setNumber(0);
        tempVo.setParentId(000L);
        allList.add(tempVo);
        List<SubjectReportsVO> listres = new ArrayList<>();
        SubjectReportsVO vo =   calculateValue(allList);
        printGoal(vo,listres);
        listres = listres.stream().sorted(Comparator.comparing(SubjectReportsVO::getNumber)).collect(Collectors.toList());
        if(0==type){
            listres.remove(0);
            return BeanMapper.mapList(listres,SubjectReportVO.class);
        }else{
            List<SubjectReportVO> lists = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(listres)){
                listres.forEach(e->{
                    if(000L!=e.getParentId()&&BigDecimal.ZERO.compareTo(e.getHappenMny()==null?BigDecimal.ZERO:e.getHappenMny())!=0){
                        lists.add(BeanMapper.map(e,SubjectReportVO.class));
                    }
                });
            }
            return lists;
        }
    }

    @Override
    public List<SubjectReportVO> getDetailsBySubjectId(Long projectId, String beginPeriod, String endPeriod, Long subjectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, subjectId));
        CommonResponse<List<SubjectOrgVO>> resDate= shareSubjectOrgApi.querySubjectOrg(param);
        if(!resDate.isSuccess()) {
            throw new BusinessException("查询科目信息失败!");
        }
        List<Long> subjectIdList = resDate.getData().stream().map(SubjectOrgVO::getId).collect(Collectors.toList());
        logger.info("科目主键--"+subjectIdList);
        List<SubjectReportsVO> list = baseMapper.getDetailsBySubjectId(projectId,beginPeriod,endPeriod,subjectIdList);
        Map<Long,SubjectReportsVO> mapList = new HashMap<>();
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(e->{

                mapList.put(e.getWbsId(),e);
            });
        }
        CommonResponse<List<ProjectWbsVO>> commonResponse = shareProjectWbsApi.queryByProjectId(projectId);
        if(!commonResponse.isSuccess()) {
            throw new BusinessException("查询核算对象信息失败!");
        }
        List<ProjectWbsVO> projectWbsVOList = commonResponse.getData();

        List<SubjectReportsVO> listres = new ArrayList<>();
        for(int i=0;i<projectWbsVOList.size();i++){
            SubjectReportsVO reportsVO = new SubjectReportsVO();
            ProjectWbsVO projectWbsVO = projectWbsVOList.get(i);
            reportsVO.setId(projectWbsVO.getId());
            reportsVO.setWbsId(projectWbsVO.getId());
            reportsVO.setWbsId(projectWbsVO.getId());
            reportsVO.setWbsName(projectWbsVO.getName());
            reportsVO.setWbsCode(projectWbsVO.getCode());
            reportsVO.setParentId(projectWbsVO.getParentId());
            SubjectReportsVO subjectReportsVO = mapList.get(projectWbsVO.getId());
            if(null!=subjectReportsVO){
                reportsVO.setHappenMny(subjectReportsVO.getHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMny());
                reportsVO.setHappenTaxMny(subjectReportsVO.getHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenTaxMny());
                reportsVO.setSubjectId(subjectReportsVO.getSubjectId());
            }
            listres.add(reportsVO);
        }
        return BeanMapper.mapList(listres,SubjectReportVO.class);
    }

    @Override
    public List<SubjectReportsVO> getDetailsByWbsId(Long projectId, String beginPeriod, String endPeriod, Long subjectId, Long wbsId) {
        QueryParam param = new QueryParam();
        param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, subjectId));
        CommonResponse<List<SubjectOrgVO>> resDate= shareSubjectOrgApi.querySubjectOrg(param);
        if(!resDate.isSuccess()) {
            throw new BusinessException("查询科目信息失败!");
        }
        List<Long> subjectIdList = resDate.getData().stream().map(SubjectOrgVO::getId).collect(Collectors.toList());
        logger.info("科目主键--"+subjectIdList);
        CommonResponse<List<ProjectWbsVO>> commonResponse = shareProjectWbsApi.queryByProjectId(projectId);
        if(!commonResponse.isSuccess()) {
            throw new BusinessException("查询核算对象信息失败!");
        }
        List<ProjectWbsVO> projectWbsVOList = commonResponse.getData();
        Map<Long,String> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(projectWbsVOList)){
            projectWbsVOList.forEach(e->{
                map.put(e.getId(),e.getName());
            });
        }
        List<SubjectReportsVO> res =  baseMapper.getDetailsByWbsId(projectId,beginPeriod,endPeriod,subjectIdList,wbsId);
        if(CollectionUtils.isNotEmpty(res)){
            res.forEach(e->{
                e.setWbsName(map.get(e.getWbsId()));
            });
        }
        return res;
    }

    @Override
    public List<ThreeReportVO> getThreeReports(Long projectId, String beginPeriod,String endPeriod) {
        int type = 0;//是否显示为0的数据    0-显示  1-不显示
//        CommonResponse<List<SubjectOrgVO>> resDate= shareSubjectOrgApi.shareSubjectOrgApi();
//        if(!resDate.isSuccess()) {
//            throw new BusinessException("查询科目信息失败!");
//        }

        //不取税金值
        QueryParam param = new QueryParam();
        param.getParams().put("subject_name", new Parameter(QueryParam.NE, "税金"));
        CommonResponse<List<SubjectOrgVO>> resDate= shareSubjectOrgApi.querySubjectOrg(param);
        if(!resDate.isSuccess()) {
            throw new BusinessException("查询科目信息失败!");
        }
        logger.info("科目信息-----"+JSONObject.toJSONString(resDate.getData()));

        //去收入预算  的  科目  金额
        CommonResponse<List<BudgetReportVO>> ysRes = budgetApi.querySumBudgetMny(projectId,beginPeriod,endPeriod);
        if(!ysRes.isSuccess()) {
            throw new BusinessException("查询预算信息失败!");
        }
        List<BudgetReportVO> budgetReportVOList = ysRes.getData();
        logger.info("预算返回信息---------"+JSONObject.toJSONString(budgetReportVOList));
        Map<Long,SubjectReportsVO> ysMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(budgetReportVOList)){
            List<SubjectReportsVO> ysList = BeanMapper.mapList(budgetReportVOList,SubjectReportsVO.class);
            ysList.forEach(e->{
                ysMap.put(e.getSubjectId(),e);
            });
        }
        //取实际成本的  科目  金额   截止本期
        List<SubjectReportsVO> listPeriod = baseMapper.getCostDetail(projectId,beginPeriod,endPeriod);
        Map<Long,SubjectReportsVO> mapPeriod = new HashMap<>();
        if(CollectionUtils.isNotEmpty(listPeriod)){
            listPeriod.forEach(e->{
                mapPeriod.put(e.getSubjectId(),e);
            });
        }

        //取实际成本的  科目  金额  全部
        List<SubjectReportsVO> listAll = baseMapper.getCostDetail(projectId,"","");
        Map<Long,SubjectReportsVO> cbMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(listAll)){
            listAll.forEach(e->{
                e.setHappenMnyAll(e.getHappenMny());
                e.setHappenTaxMnyAll(e.getHappenTaxMny());
                if(mapPeriod.containsKey(e.getSubjectId())){
                    e.setHappenMny(mapPeriod.get(e.getSubjectId()).getHappenMny()==null?BigDecimal.ZERO:mapPeriod.get(e.getSubjectId()).getHappenMny());
                    e.setHappenTaxMny(mapPeriod.get(e.getSubjectId()).getHappenTaxMny()==null?BigDecimal.ZERO:mapPeriod.get(e.getSubjectId()).getHappenTaxMny());
                }else{
                    e.setHappenMny(null);
                    e.setHappenTaxMny(null);
                }
                cbMap.put(e.getSubjectId(),e);
            });
        }
        //todo 取目标成本
        CommonResponse<List<CostReportVO>> mbRes = targetCostFinishApi.costReportQuery(projectId,endPeriod,beginPeriod);
        if(!mbRes.isSuccess()) {
            throw new BusinessException("查询，目标信息失败!");
        }
        List<CostReportVO> mbReportVOList = mbRes.getData();
        logger.info("目标返回信息---------"+JSONObject.toJSONString(mbReportVOList));
        Map<Long,SubjectReportsVO> sjMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(mbReportVOList)){
            List<SubjectReportsVO> sjList = BeanMapper.mapList(mbReportVOList,SubjectReportsVO.class);
            sjList.forEach(e->{
                sjMap.put(e.getSubjectId(),e);
            });
        }

        //根据科目树  将三算数据汇总到一起
        List<SubjectOrgVO> subjectOrgVOList = resDate.getData();
        Map<Long,SubjectReportsVO> mapList = new HashMap<>();
        if(CollectionUtils.isNotEmpty(subjectOrgVOList)){
            subjectOrgVOList.forEach(e->{
                SubjectReportsVO vo = new SubjectReportsVO();
                SubjectReportsVO ysvo = ysMap.get(e.getId());
                SubjectReportsVO cbvo = cbMap.get(e.getId());
                SubjectReportsVO sjvo = sjMap.get(e.getId());
                vo.setSubjectId(e.getId());
                vo.setSubjectName(e.getSubjectName());
                vo.setSubjectCode(e.getSubjectCode());
                if(null!=ysvo){
                   vo.setYsHappenMny(ysvo.getYsHappenMny());
                   vo.setYsHappenTaxMny(ysvo.getYsHappenTaxMny());
                   vo.setYsHappenMnyAll(ysvo.getYsHappenMnyAll());
                   vo.setYsHappenTaxMnyAll(ysvo.getYsHappenTaxMnyAll());
                }
                if(null!=cbvo){
                   vo.setHappenMny(cbvo.getHappenMny());
                   vo.setHappenMnyAll(cbvo.getHappenMnyAll());
                   vo.setHappenTaxMny(cbvo.getHappenTaxMny());
                   vo.setHappenTaxMnyAll(cbvo.getHappenTaxMnyAll());
                }
                if(null!=sjvo){
                    vo.setCbHappenMny(sjvo.getCbHappenMny());
                    vo.setCbHappenTaxMny(sjvo.getCbHappenTaxMny());
                    vo.setCbHappenMnyAll(sjvo.getCbHappenMnyAll());
                    vo.setCbHappenTaxMnyAll(sjvo.getCbHappenTaxMnyAll());
                }

                mapList.put(e.getId(),vo);
            });
        }
        List<SubjectReportsVO> allList = new ArrayList<>();
        for(int i=0;i<subjectOrgVOList.size();i++){
            SubjectOrgVO subjectOrgVO = subjectOrgVOList.get(i);
            SubjectReportsVO vo = mapList.get(subjectOrgVO.getId());
            if(null!=vo){
                vo.setId(subjectOrgVO.getId());
                vo.setNumber(i+1);
                vo.setSubjectId(subjectOrgVO.getId());
                vo.setSubjectCode(subjectOrgVO.getSubjectCode());
                vo.setSubjectName(subjectOrgVO.getSubjectName());
                vo.setParentId(subjectOrgVO.getParentId());
            }else{
                vo = new SubjectReportsVO();
                vo.setId(subjectOrgVO.getId());
                vo.setNumber(i+1);
                vo.setSubjectId(subjectOrgVO.getId());
                vo.setSubjectCode(subjectOrgVO.getSubjectCode());
                vo.setSubjectName(subjectOrgVO.getSubjectName());
                vo.setParentId(subjectOrgVO.getParentId());
                vo.setHappenDate(null);
                vo.setHappenMny(BigDecimal.ZERO);
                vo.setHappenMnySum(BigDecimal.ZERO);
            }
            allList.add(vo);
        }


        SubjectReportsVO tempVo = new SubjectReportsVO();
        tempVo.setId(999L);
        tempVo.setNumber(0);
        tempVo.setParentId(000L);
        allList.add(tempVo);
        List<SubjectReportsVO> listres = new ArrayList<>();
        SubjectReportsVO vo =   calculateValue2(allList);
        printGoal(vo,listres);
        listres = listres.stream().sorted(Comparator.comparing(SubjectReportsVO::getNumber)).collect(Collectors.toList());
        listres.remove(0);
        //计算差额，比率
        listres.forEach(e->{
            BigDecimal happenMny = e.getHappenMny()==null?BigDecimal.ZERO:e.getHappenMny();//本期实际成本金额
            BigDecimal ysHappenMny = e.getYsHappenMny()==null?BigDecimal.ZERO:e.getYsHappenMny();//本期预算金额
            BigDecimal cbHappenMny = e.getCbHappenMny()==null?BigDecimal.ZERO:e.getCbHappenMny();//本期目标成本金额
            BigDecimal srmbdifMny = ysHappenMny.subtract(cbHappenMny);//收入与目标差额
            BigDecimal srmbRate =  BigDecimal.ZERO;//收入与目标比率
            if(srmbdifMny.compareTo(BigDecimal.ZERO)!=0 && ysHappenMny.compareTo(BigDecimal.ZERO)!=0){
                srmbRate = srmbdifMny.multiply(new BigDecimal(100)).divide(ysHappenMny,2,BigDecimal.ROUND_HALF_DOWN);
            }
            e.setSrmbdifMny(srmbdifMny);
            e.setSrmbRate(srmbRate);

            BigDecimal mbsjdifMny = cbHappenMny.subtract(happenMny);//目标实际差额
            BigDecimal mbsjRate = BigDecimal.ZERO;//目标实际比率
            if(mbsjdifMny.compareTo(BigDecimal.ZERO)!=0 && cbHappenMny.compareTo(BigDecimal.ZERO)!=0){
                mbsjRate = mbsjdifMny.multiply(new BigDecimal(100)).divide(cbHappenMny,2,BigDecimal.ROUND_HALF_DOWN);
            }
            e.setMbsjdifMny(mbsjdifMny);
            e.setMbsjRate(mbsjRate);


            BigDecimal srsjdifMny = ysHappenMny.subtract(happenMny);;//收入与实际差额
            BigDecimal srsjRate = BigDecimal.ZERO;//收入与实际比率
            if(srsjdifMny.compareTo(BigDecimal.ZERO)!=0 && ysHappenMny.compareTo(BigDecimal.ZERO)!=0){
                srsjRate = srsjdifMny.multiply(new BigDecimal(100)).divide(ysHappenMny,2,BigDecimal.ROUND_HALF_DOWN);
            }
            e.setSrsjdifMny(srsjdifMny);
            e.setSrsjRate(srsjRate);
        });

        return BeanMapper.mapList(listres,ThreeReportVO.class);
    }

    @Override
    public List<ThreeReportVO> getNumpReports(Long projectId, String beginPeriod,String endPeriod) {
        int type = 0;//是否显示为0的数据    0-显示  1-不显示
        //只取材料费下的科目
//        QueryParam param = new QueryParam();
//        param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, costSubjectId));
//        CommonResponse<List<SubjectOrgVO>> resDate= shareSubjectOrgApi.querySubjectOrg(param);
//        if(!resDate.isSuccess()) {
//            throw new BusinessException("查询科目信息失败!");
//        }
        QueryWrapper<UnitEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr",0);
        logger.info("科目信息开始查询-----");
        List<UnitEntity> list = unitService.list(queryWrapper);
        logger.info("科目信息-----"+list);
        Map<Long,String> subjectMap = new HashMap<>();
        list.forEach(e->{
            subjectMap.put(e.getId(),e.getUnitName()==null?"":e.getUnitName());
        });
        logger.info("科目子表信息开始查询-----");
        Map<Long, List<UnitDetailVO>> unitMap = unitService.queryUnitDetailMap();

        logger.info("科目信息-----"+JSONObject.toJSONString(list));

        //取实际成本的  科目  金额   截止本期
        List<SubjectReportsVO> listPeriod = baseMapper.getCostDetailUnit(projectId,beginPeriod,endPeriod);
        Map<String,SubjectReportsVO> mapPeriod = new HashMap<>();
        if(CollectionUtils.isNotEmpty(listPeriod)){
            listPeriod.forEach(e->{
                String unitName = e.getUnit()==null?"":e.getUnit();
                mapPeriod.put(e.getSubjectId()+unitName,e);
            });
        }

        //取实际成本的  科目  金额  全部
        List<SubjectReportsVO> listAll = baseMapper.getCostDetailUnit(projectId,"","");
        if(CollectionUtils.isNotEmpty(listAll)){
            listAll.forEach(e->{
                e.setHappenMnyAll(e.getHappenMny());
                e.setHappenTaxMnyAll(e.getHappenTaxMny());
                String unitName = e.getUnit()==null?"":e.getUnit();
                if(mapPeriod.containsKey(e.getSubjectId()+unitName)){
                    e.setHappenMny(mapPeriod.get(e.getSubjectId()+unitName).getHappenMny()==null?BigDecimal.ZERO:mapPeriod.get(e.getSubjectId()+unitName).getHappenMny());
                    e.setHappenTaxMny(mapPeriod.get(e.getSubjectId()+unitName).getHappenTaxMny()==null?BigDecimal.ZERO:mapPeriod.get(e.getSubjectId()+unitName).getHappenTaxMny());
                }else{
                    e.setHappenMny(null);
                    e.setHappenTaxMny(null);
                }
//                cbMap.put(e.getSubjectId(),e);
            });
        }

        Map<Long,SubjectReportsVO> cbMap = changeSjData(listAll,subjectMap,unitMap);


        //去收入预算  的  科目  金额
        CommonResponse<List<BudgetReportVO>> ysRes = budgetApi.querySumBudgetMnyNew(projectId,beginPeriod,endPeriod);
        if(!ysRes.isSuccess()) {
            throw new BusinessException("查询预算信息失败!");
        }
        logger.info("预算信息-----"+JSONObject.toJSONString(ysRes.getData()));
        List<BudgetReportVO> budgetReportVOList = ysRes.getData();
        Map<Long,SubjectReportsVO> ysMap = changeYsData(budgetReportVOList,subjectMap,unitMap);
//        Map<Long,SubjectReportsVO> ysMap = new HashMap<>();
//        if(CollectionUtils.isNotEmpty(budgetReportVOList)){
//            List<SubjectReportsVO> ysList = BeanMapper.mapList(budgetReportVOList,SubjectReportsVO.class);
//            ysList.forEach(e->{
//                ysMap.put(e.getSubjectId(),e);
//            });
//        }
        //todo 取目标成本
        CommonResponse<List<CostReportVO>> mbRes = targetCostFinishApi.costReportQueryNew(projectId,endPeriod,beginPeriod);
        if(!mbRes.isSuccess()) {
            throw new BusinessException("查询，目标信息失败!");
        }
        List<CostReportVO> mbReportVOList = mbRes.getData();
        logger.info("目标返回信息---------"+JSONObject.toJSONString(mbReportVOList));
        Map<Long,SubjectReportsVO> mbMap = changeCbData(mbReportVOList,subjectMap,unitMap);
//        Map<Long,SubjectReportsVO> mbMap = new HashMap<>();
//        if(CollectionUtils.isNotEmpty(mbReportVOList)){
//            List<SubjectReportsVO> mbList = BeanMapper.mapList(mbReportVOList,SubjectReportsVO.class);
//            mbList.forEach(e->{
//                mbMap.put(e.getSubjectId(),e);
//            });
//        }

        //根据科目树  将三算数据汇总到一起
//        List<SubjectOrgVO> subjectOrgVOList = resDate.getData();
        Map<Long,SubjectReportsVO> mapList = new HashMap<>();
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(e->{
                SubjectReportsVO vo = new SubjectReportsVO();
                SubjectReportsVO ysvo = ysMap.get(e.getId());
                SubjectReportsVO cbvo = cbMap.get(e.getId());
                SubjectReportsVO mbvo = mbMap.get(e.getId());
                vo.setUnit(e.getUnitName());
                vo.setSubjectId(e.getId());
                vo.setSubjectName(e.getSubjectName());
                vo.setSubjectCode(e.getSubjectCode());
                if(null!=ysvo){
                    vo.setYsHappenMny(ysvo.getYsHappenMny());
                    vo.setYsHappenTaxMny(ysvo.getYsHappenTaxMny());
                    vo.setYsHappenMnyAll(ysvo.getYsHappenMnyAll());
                    vo.setYsHappenTaxMnyAll(ysvo.getYsHappenTaxMnyAll());
                    BigDecimal ysNum = ysvo.getYsNum();
                    BigDecimal ysHappenMny = ysvo.getYsHappenMny();//收入预算-本期发生成本(无税)
                    vo.setYsNum(ysNum);//收入预算-产值总数量
                    vo.setYsNumAll(ysvo.getYsNumAll());
                    if(null!=ysNum&&null!=ysHappenMny&&ysNum.compareTo(BigDecimal.ZERO)>0 && ysHappenMny.compareTo(BigDecimal.ZERO)>0){
                        vo.setYsPrice(ysHappenMny.divide(ysNum,2,BigDecimal.ROUND_HALF_DOWN));
                    }
                }
                if(null!=cbvo){  //实际成本
                    vo.setHappenMny(cbvo.getHappenMny());
                    vo.setHappenMnyAll(cbvo.getHappenMnyAll());
                    vo.setHappenTaxMny(cbvo.getHappenTaxMny());
                    vo.setHappenTaxMnyAll(cbvo.getHappenTaxMnyAll());
                    BigDecimal num = cbvo.getNum();
                    BigDecimal happenMny = cbvo.getHappenMny();//实际成本-本期发生成本(无税)
                    if(null!=num&&null!=happenMny&&num.compareTo(BigDecimal.ZERO)>0 && happenMny.compareTo(BigDecimal.ZERO)>0){
                        vo.setNum(num);//数量
                        vo.setPrice(happenMny.divide(num,2,BigDecimal.ROUND_HALF_DOWN));
                    }
                }
                if(null!=mbvo){ //目标成本
                    vo.setCbHappenMny(mbvo.getCbHappenMny());
                    vo.setCbHappenTaxMny(mbvo.getCbHappenTaxMny());
                    vo.setCbHappenMnyAll(mbvo.getCbHappenMnyAll());
                    vo.setCbHappenTaxMnyAll(mbvo.getCbHappenTaxMnyAll());
                    BigDecimal mbnum = mbvo.getCbNum();
                    BigDecimal mbhappenMny = mbvo.getCbHappenMny();//目标成本-本期发生成本(无税)
                    vo.setCbNum(mbnum);//数量
                    vo.setCbNumAll(mbvo.getCbNumAll());
                    if(null!=mbnum&&null!=mbhappenMny&&mbnum.compareTo(BigDecimal.ZERO)>0 && mbhappenMny.compareTo(BigDecimal.ZERO)>0){
                        vo.setCbPrice(mbhappenMny.divide(mbnum,2,BigDecimal.ROUND_HALF_DOWN));
                    }
                }
                mapList.put(e.getId(),vo);
            });
        }
        List<SubjectReportsVO> allList = new ArrayList<>();
        for(int i=0;i<list.size();i++){
            UnitEntity subjectOrgVO = list.get(i);
            SubjectReportsVO vo = mapList.get(subjectOrgVO.getId());
            if(null!=vo){
                vo.setId(subjectOrgVO.getId());
                vo.setNumber(i+1);
                vo.setUnit(subjectOrgVO.getUnitName());
                vo.setSubjectId(subjectOrgVO.getId());
                vo.setSubjectCode(subjectOrgVO.getSubjectCode());
                vo.setSubjectName(subjectOrgVO.getSubjectName());
                vo.setParentId(subjectOrgVO.getParentId());
            }else{
                vo = new SubjectReportsVO();
                vo.setId(subjectOrgVO.getId());
                vo.setNumber(i+1);
                vo.setSubjectId(subjectOrgVO.getId());
                vo.setSubjectCode(subjectOrgVO.getSubjectCode());
                vo.setSubjectName(subjectOrgVO.getSubjectName());
                vo.setParentId(subjectOrgVO.getParentId());
                vo.setHappenDate(null);
                vo.setHappenMny(BigDecimal.ZERO);
                vo.setHappenMnySum(BigDecimal.ZERO);
            }
            allList.add(vo);
        }


        SubjectReportsVO tempVo = new SubjectReportsVO();
        tempVo.setId(999L);
        tempVo.setNumber(0);
        tempVo.setParentId(000L);
        allList.add(tempVo);
        List<SubjectReportsVO> listres = new ArrayList<>();
        SubjectReportsVO vo =   calculateValue2(allList);
        printGoal(vo,listres);
        listres = listres.stream().sorted(Comparator.comparing(SubjectReportsVO::getNumber)).collect(Collectors.toList());
        listres.remove(0);
        //计算差额，比率
        listres.forEach(e->{
            BigDecimal happenMny = e.getHappenMny()==null?BigDecimal.ZERO:e.getHappenMny();//本期实际成本金额
            BigDecimal num = e.getNum()==null?BigDecimal.ZERO:e.getNum();
            BigDecimal ysHappenMny = e.getYsHappenMny()==null?BigDecimal.ZERO:e.getYsHappenMny();//本期预算金额
            BigDecimal ysNum = e.getYsNum()==null?BigDecimal.ZERO:e.getYsNum();
//            BigDecimal ysNumAll = e.getYsNumAll()==null?BigDecimal.ZERO:e.getYsNumAll();
            BigDecimal cbHappenMny = e.getCbHappenMny()==null?BigDecimal.ZERO:e.getCbHappenMny();//本期目标成本金额
            BigDecimal cbNum = e.getCbNum()==null?BigDecimal.ZERO:e.getCbNum();
//            BigDecimal cbNumAll = e.getYsNumAll()==null?BigDecimal.ZERO:e.getYsNumAll();


            // 收入与目标-数量  差额 比率
            BigDecimal srmbNum = ysNum.subtract(cbNum);
            BigDecimal srmbNumRate =  BigDecimal.ZERO;//收入与目标 数量比率
            if(srmbNum.compareTo(BigDecimal.ZERO)!=0 && ysNum.compareTo(BigDecimal.ZERO)!=0){
                srmbNumRate = srmbNum.multiply(new BigDecimal(100)).divide(ysNum,2,BigDecimal.ROUND_HALF_DOWN);
            }
            e.setSrmbNum(srmbNum);
            e.setSrmbNumRate(srmbNumRate);

            // 收入与目标-总额  差额 比率

            BigDecimal srmbdifMny = ysHappenMny.subtract(cbHappenMny);//收入与目标差额
            BigDecimal srmbRate =  BigDecimal.ZERO;//收入与目标比率
            if(srmbdifMny.compareTo(BigDecimal.ZERO)!=0 && ysHappenMny.compareTo(BigDecimal.ZERO)!=0){
                srmbRate = srmbdifMny.multiply(new BigDecimal(100)).divide(ysHappenMny,2,BigDecimal.ROUND_HALF_DOWN);
            }
            e.setSrmbdifMny(srmbdifMny);
            e.setSrmbRate(srmbRate);

            //目标与实际-数量  差额 比率
            BigDecimal mbsjNum = cbNum.subtract(num);
            BigDecimal mbsjNumRate =  BigDecimal.ZERO;//目标实际 数量比率
            if(mbsjNum.compareTo(BigDecimal.ZERO)!=0 && cbNum.compareTo(BigDecimal.ZERO)!=0){
                mbsjNumRate = mbsjNum.multiply(new BigDecimal(100)).divide(cbNum,2,BigDecimal.ROUND_HALF_DOWN);
            }
            e.setMbsjNum(mbsjNum);
            e.setMbsjNumRate(mbsjNumRate);

            //目标与实际-总额  差额 比率
            BigDecimal mbsjdifMny = cbHappenMny.subtract(happenMny);//目标实际差额
            BigDecimal mbsjRate = BigDecimal.ZERO;//目标实际比率
            if(mbsjdifMny.compareTo(BigDecimal.ZERO)!=0 && cbHappenMny.compareTo(BigDecimal.ZERO)!=0){
                mbsjRate = mbsjdifMny.multiply(new BigDecimal(100)).divide(cbHappenMny,2,BigDecimal.ROUND_HALF_DOWN);
            }
            e.setMbsjdifMny(mbsjdifMny);
            e.setMbsjRate(mbsjRate);

            //收入与实际--数量  差额 比率
            BigDecimal srsjNum = ysNum.subtract(num);
            BigDecimal srsjNumRate =  BigDecimal.ZERO;//收入实际 数量比率
            if(srsjNum.compareTo(BigDecimal.ZERO)!=0 && ysNum.compareTo(BigDecimal.ZERO)!=0){
                srsjNumRate = srsjNum.multiply(new BigDecimal(100)).divide(ysNum,2,BigDecimal.ROUND_HALF_DOWN);
            }
            e.setSrsjNum(srsjNum);
            e.setSrsjNumRate(srsjNumRate);

            //收入与实际-总额  差额 比率
            BigDecimal srsjdifMny = ysHappenMny.subtract(happenMny);;//收入与实际差额
            BigDecimal srsjRate = BigDecimal.ZERO;//收入与实际比率
            if(srsjdifMny.compareTo(BigDecimal.ZERO)!=0 && ysHappenMny.compareTo(BigDecimal.ZERO)!=0){
                srsjRate = srsjdifMny.multiply(new BigDecimal(100)).divide(ysHappenMny,2,BigDecimal.ROUND_HALF_DOWN);
            }
            e.setSrsjdifMny(srsjdifMny);
            e.setSrsjRate(srsjRate);
        });

        return BeanMapper.mapList(listres,ThreeReportVO.class);
    }


    public Map<Long,SubjectReportsVO> changeSjData(List<SubjectReportsVO> sjList,Map<Long,String> subjectMap,Map<Long, List<UnitDetailVO>> unitMap){
        logger.info("开始转换实际信息-----");
        Map<Long,SubjectReportsVO> sjMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(sjList)){
            sjList.forEach(e->{
                //进行单位转换
                String sjUnitName = e.getUnit();
                logger.info("实际信息单位-----"+sjUnitName);
                Long subjectId = e.getSubjectId();
                logger.info("实际成本信息科目主键-----"+subjectId);
                if(StringUtils.isEmpty(sjUnitName)){
                    logger.info("实际成本数据单位为空，则直接将数量为0  按照subjectId金额相加-----");
                    //实际成本数据单位为空，则直接将数量为0  按照subjectId金额相加
                    e.setNum(BigDecimal.ZERO);
                    if(sjMap.containsKey(subjectId)){
                        SubjectReportsVO subjectReportsVO = sjMap.get(subjectId);
                        BigDecimal sjHappenMny = subjectReportsVO.getHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMny(); // 收入实际成本-本期发生成本(无税)
                        BigDecimal sjHappenTaxMny = subjectReportsVO.getHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenTaxMny(); // 收入实际成本-本期发生成本(含税)
                        BigDecimal sjHappenMnyAll = subjectReportsVO.getHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMnyAll(); // 收入实际成本-整体成本(无税)
                        BigDecimal sjHappenTaxMnyAll = subjectReportsVO.getHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getHappenTaxMnyAll(); // 收入实际成本-整体成本(含税)
                        sjHappenMny = sjHappenMny.add(e.getHappenMny()==null?BigDecimal.ZERO:e.getHappenMny());
                        sjHappenTaxMny = sjHappenTaxMny.add(e.getHappenTaxMny()==null?BigDecimal.ZERO:e.getHappenTaxMny());
                        sjHappenMnyAll = sjHappenMnyAll.add(e.getHappenMnyAll()==null?BigDecimal.ZERO:e.getHappenMnyAll());
                        sjHappenTaxMnyAll = sjHappenTaxMnyAll.add(e.getHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getHappenTaxMnyAll());
                        subjectReportsVO.setHappenMny(sjHappenMny);
                        subjectReportsVO.setHappenTaxMny(sjHappenTaxMny);
                        subjectReportsVO.setHappenMnyAll(sjHappenMnyAll);
                        subjectReportsVO.setHappenTaxMnyAll(sjHappenTaxMnyAll);
                        sjMap.put(subjectId,subjectReportsVO);
                    }else{
                        sjMap.put(subjectId,e);
                    }
                }else if(subjectMap.containsKey(subjectId)){
                    logger.info("实际成本数据科目在对应关系表里。。");
                    //科目在转换表里有
                    String unitName = subjectMap.get(subjectId);
                    if(StringUtils.isEmpty(unitName)){
                        logger.info("实际成本数据科目 对应主表单位为空!!!!!!!!!!!");
                        //该科目成本单位为空  则不进行数量统计
                        e.setNum(BigDecimal.ZERO);
                        if(sjMap.containsKey(subjectId)){
                            SubjectReportsVO subjectReportsVO = sjMap.get(subjectId);
                            BigDecimal sjHappenMny = subjectReportsVO.getHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMny(); // 收入实际成本-本期发生成本(无税)
                            BigDecimal sjHappenTaxMny = subjectReportsVO.getHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenTaxMny(); // 收入实际成本-本期发生成本(含税)
                            BigDecimal sjHappenMnyAll = subjectReportsVO.getHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMnyAll(); // 收入实际成本-整体成本(无税)
                            BigDecimal sjHappenTaxMnyAll = subjectReportsVO.getHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getHappenTaxMnyAll(); // 收入实际成本-整体成本(含税)
                            sjHappenMny = sjHappenMny.add(e.getHappenMny()==null?BigDecimal.ZERO:e.getHappenMny());
                            sjHappenTaxMny = sjHappenTaxMny.add(e.getHappenTaxMny()==null?BigDecimal.ZERO:e.getHappenTaxMny());
                            sjHappenMnyAll = sjHappenMnyAll.add(e.getHappenMnyAll()==null?BigDecimal.ZERO:e.getHappenMnyAll());
                            sjHappenTaxMnyAll = sjHappenTaxMnyAll.add(e.getHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getHappenTaxMnyAll());
                            subjectReportsVO.setHappenMny(sjHappenMny);
                            subjectReportsVO.setHappenTaxMny(sjHappenTaxMny);
                            subjectReportsVO.setHappenMnyAll(sjHappenMnyAll);
                            subjectReportsVO.setHappenTaxMnyAll(sjHappenTaxMnyAll);
                            sjMap.put(subjectId,subjectReportsVO);
                        }else{
                            sjMap.put(subjectId,e);
                        }
                    }else{
                        List<UnitDetailVO> unitDetailVOList = unitMap.get(subjectId);
                        if(unitName.equals(sjUnitName)){
                            logger.info("实际成本数据科目 对应主表单位一致==========");
                            //该科目成本单位 与实际成本单位一致，不进行转换
                            if(sjMap.containsKey(subjectId)){
                                SubjectReportsVO subjectReportsVO = sjMap.get(subjectId);
                                BigDecimal sjHappenMny = subjectReportsVO.getHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMny(); // 收入实际成本-本期发生成本(无税)
                                BigDecimal sjHappenTaxMny = subjectReportsVO.getHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenTaxMny(); // 收入实际成本-本期发生成本(含税)
                                BigDecimal sjHappenMnyAll = subjectReportsVO.getHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMnyAll(); // 收入实际成本-整体成本(无税)
                                BigDecimal sjHappenTaxMnyAll = subjectReportsVO.getHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getHappenTaxMnyAll(); // 收入实际成本-整体成本(含税)
                                BigDecimal num = subjectReportsVO.getNum() ==null?BigDecimal.ZERO:subjectReportsVO.getNum(); // 收入实际成本-产值总数量
                                sjHappenMny = sjHappenMny.add(e.getHappenMny()==null?BigDecimal.ZERO:e.getHappenMny());
                                sjHappenTaxMny = sjHappenTaxMny.add(e.getHappenTaxMny()==null?BigDecimal.ZERO:e.getHappenTaxMny());
                                sjHappenMnyAll = sjHappenMnyAll.add(e.getHappenMnyAll()==null?BigDecimal.ZERO:e.getHappenMnyAll());
                                sjHappenTaxMnyAll = sjHappenTaxMnyAll.add(e.getHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getHappenTaxMnyAll());
                                num = num.add(e.getNum() ==null?BigDecimal.ZERO:e.getNum());
                                subjectReportsVO.setHappenMny(sjHappenMny);
                                subjectReportsVO.setHappenTaxMny(sjHappenTaxMny);
                                subjectReportsVO.setHappenMnyAll(sjHappenMnyAll);
                                subjectReportsVO.setHappenTaxMnyAll(sjHappenTaxMnyAll);
                                subjectReportsVO.setNum(num);
                                sjMap.put(subjectId,subjectReportsVO);
                            }else{
                                sjMap.put(subjectId,e);
                            }
                        }else if(CollectionUtils.isEmpty(unitDetailVOList)){
                            logger.info("实际成本数据科目 对应未设置子表!!!!!!!!!");
                            //没有设置转换子表  和没有设置主表单位一样处理
                            e.setNum(BigDecimal.ZERO);
                            if(sjMap.containsKey(subjectId)){
                                SubjectReportsVO subjectReportsVO = sjMap.get(subjectId);
                                BigDecimal sjHappenMny = subjectReportsVO.getHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMny(); // 收入实际成本-本期发生成本(无税)
                                BigDecimal sjHappenTaxMny = subjectReportsVO.getHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenTaxMny(); // 收入实际成本-本期发生成本(含税)
                                BigDecimal sjHappenMnyAll = subjectReportsVO.getHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMnyAll(); // 收入实际成本-整体成本(无税)
                                BigDecimal sjHappenTaxMnyAll = subjectReportsVO.getHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getHappenTaxMnyAll(); // 收入实际成本-整体成本(含税)
                                sjHappenMny = sjHappenMny.add(e.getHappenMny()==null?BigDecimal.ZERO:e.getHappenMny());
                                sjHappenTaxMny = sjHappenTaxMny.add(e.getHappenTaxMny()==null?BigDecimal.ZERO:e.getHappenTaxMny());
                                sjHappenMnyAll = sjHappenMnyAll.add(e.getHappenMnyAll()==null?BigDecimal.ZERO:e.getHappenMnyAll());
                                sjHappenTaxMnyAll = sjHappenTaxMnyAll.add(e.getHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getHappenTaxMnyAll());
                                subjectReportsVO.setHappenMny(sjHappenMny);
                                subjectReportsVO.setHappenTaxMny(sjHappenTaxMny);
                                subjectReportsVO.setHappenMnyAll(sjHappenMnyAll);
                                subjectReportsVO.setHappenTaxMnyAll(sjHappenTaxMnyAll);
                                sjMap.put(subjectId,subjectReportsVO);
                            }else{
                                sjMap.put(subjectId,e);
                            }
                        }else{
                            //  有设置单位转换子表
                            Map<String,BigDecimal> map = unitDetailVOList.stream().collect(Collectors.toMap(UnitDetailVO::getConversionUnitName, UnitDetailVO::getScaleFactor));
                            if(!map.containsKey(sjUnitName)){
                                logger.info("实际成本数据科目 对应设置子表 没有该单位!!!!!!!!!");
                                e.setNum(BigDecimal.ZERO);
                                //如果【单位】不在其他转换单位范围中，【数量】=0，不参与统计；
                                if(sjMap.containsKey(subjectId)){
                                    SubjectReportsVO subjectReportsVO = sjMap.get(subjectId);
                                    BigDecimal sjHappenMny = subjectReportsVO.getHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMny(); // 收入实际成本-本期发生成本(无税)
                                    BigDecimal sjHappenTaxMny = subjectReportsVO.getHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenTaxMny(); // 收入实际成本-本期发生成本(含税)
                                    BigDecimal sjHappenMnyAll = subjectReportsVO.getHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMnyAll(); // 收入实际成本-整体成本(无税)
                                    BigDecimal sjHappenTaxMnyAll = subjectReportsVO.getHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getHappenTaxMnyAll(); // 收入实际成本-整体成本(含税)
                                    sjHappenMny = sjHappenMny.add(e.getHappenMny()==null?BigDecimal.ZERO:e.getHappenMny());
                                    sjHappenTaxMny = sjHappenTaxMny.add(e.getHappenTaxMny()==null?BigDecimal.ZERO:e.getHappenTaxMny());
                                    sjHappenMnyAll = sjHappenMnyAll.add(e.getHappenMnyAll()==null?BigDecimal.ZERO:e.getHappenMnyAll());
                                    sjHappenTaxMnyAll = sjHappenTaxMnyAll.add(e.getHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getHappenTaxMnyAll());
                                    subjectReportsVO.setHappenMny(sjHappenMny);
                                    subjectReportsVO.setHappenTaxMny(sjHappenTaxMny);
                                    subjectReportsVO.setHappenMnyAll(sjHappenMnyAll);
                                    subjectReportsVO.setHappenTaxMnyAll(sjHappenTaxMnyAll);
                                    sjMap.put(subjectId,subjectReportsVO);
                                }else{
                                    sjMap.put(subjectId,e);
                                }
                            }else{
                                logger.info("实际成本数据科目 转换开始------>");
                                //如果【单位】在其他转换单位范围中，【数量】=【数量】/转换系数；
                                BigDecimal scaleFactor = map.get(sjUnitName);//转换系数   【数量】=【数量】/转换系数；
                                logger.info("实际成本数据科目 转换系数------>"+scaleFactor);
                                BigDecimal sjNum = e.getNum() ==null?BigDecimal.ZERO:e.getNum(); // 收入实际成本-产值总数量
                                e.setNum(sjNum.divide(scaleFactor,2,BigDecimal.ROUND_HALF_DOWN));
                                if(sjMap.containsKey(subjectId)){
                                    SubjectReportsVO subjectReportsVO = sjMap.get(subjectId);
                                    BigDecimal sjHappenMny = subjectReportsVO.getHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMny(); // 收入实际成本-本期发生成本(无税)
                                    BigDecimal sjHappenTaxMny = subjectReportsVO.getHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getHappenTaxMny(); // 收入实际成本-本期发生成本(含税)
                                    BigDecimal sjHappenMnyAll = subjectReportsVO.getHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getHappenMnyAll(); // 收入实际成本-整体成本(无税)
                                    BigDecimal sjHappenTaxMnyAll = subjectReportsVO.getHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getHappenTaxMnyAll(); // 收入实际成本-整体成本(含税)
                                    BigDecimal num = subjectReportsVO.getNum() ==null?BigDecimal.ZERO:subjectReportsVO.getNum(); // 收入实际成本-产值总数量
                                    sjHappenMny = sjHappenMny.add(e.getHappenMny()==null?BigDecimal.ZERO:e.getHappenMny());
                                    sjHappenTaxMny = sjHappenTaxMny.add(e.getHappenTaxMny()==null?BigDecimal.ZERO:e.getHappenTaxMny());
                                    sjHappenMnyAll = sjHappenMnyAll.add(e.getHappenMnyAll()==null?BigDecimal.ZERO:e.getHappenMnyAll());
                                    sjHappenTaxMnyAll = sjHappenTaxMnyAll.add(e.getHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getHappenTaxMnyAll());
                                    num = num.add(e.getNum() ==null?BigDecimal.ZERO:e.getNum());
                                    subjectReportsVO.setHappenMny(sjHappenMny);
                                    subjectReportsVO.setHappenTaxMny(sjHappenTaxMny);
                                    subjectReportsVO.setHappenMnyAll(sjHappenMnyAll);
                                    subjectReportsVO.setHappenTaxMnyAll(sjHappenTaxMnyAll);
                                    subjectReportsVO.setNum(num);
                                    sjMap.put(subjectId,subjectReportsVO);
                                }else{
                                    sjMap.put(subjectId,e);
                                }
                            }
                        }
                    }
                }
            });
        }
        return sjMap;
    }


    public Map<Long,SubjectReportsVO> changeYsData(List<BudgetReportVO> budgetReportVOList,Map<Long,String> subjectMap,Map<Long, List<UnitDetailVO>> unitMap){
        logger.info("开始转换预算信息-----");
        Map<Long,SubjectReportsVO> ysMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(budgetReportVOList)){
            List<SubjectReportsVO> ysList = BeanMapper.mapList(budgetReportVOList,SubjectReportsVO.class);
            ysList.forEach(e->{
                //进行单位转换
                String ysUnitName = e.getYsUnitName();
                logger.info("预算信息单位-----"+ysUnitName);
                Long subjectId = e.getSubjectId();
                logger.info("预算信息科目主键-----"+subjectId);
                if(StringUtils.isEmpty(ysUnitName)){
                    logger.info("预算数据单位为空，则直接将数量为0  按照subjectId金额相加-----");
                    //预算数据单位为空，则直接将数量为0  按照subjectId金额相加
                    e.setYsNum(BigDecimal.ZERO);
                    e.setYsNumAll(BigDecimal.ZERO);
                    if(ysMap.containsKey(subjectId)){
                        SubjectReportsVO subjectReportsVO = ysMap.get(subjectId);
                        BigDecimal ysHappenMny = subjectReportsVO.getYsHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenMny(); // 收入预算-本期发生成本(无税)
                        BigDecimal ysHappenTaxMny = subjectReportsVO.getYsHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenTaxMny(); // 收入预算-本期发生成本(含税)
                        BigDecimal ysHappenMnyAll = subjectReportsVO.getYsHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenMnyAll(); // 收入预算-整体成本(无税)
                        BigDecimal ysHappenTaxMnyAll = subjectReportsVO.getYsHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenTaxMnyAll(); // 收入预算-整体成本(含税)
                        ysHappenMny = ysHappenMny.add(e.getYsHappenMny()==null?BigDecimal.ZERO:e.getYsHappenMny());
                        ysHappenTaxMny = ysHappenTaxMny.add(e.getYsHappenTaxMny()==null?BigDecimal.ZERO:e.getYsHappenTaxMny());
                        ysHappenMnyAll = ysHappenMnyAll.add(e.getYsHappenMnyAll()==null?BigDecimal.ZERO:e.getYsHappenMnyAll());
                        ysHappenTaxMnyAll = ysHappenTaxMnyAll.add(e.getYsHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getYsHappenTaxMnyAll());
                        subjectReportsVO.setYsHappenMny(ysHappenMny);
                        subjectReportsVO.setYsHappenTaxMny(ysHappenTaxMny);
                        subjectReportsVO.setYsHappenMnyAll(ysHappenMnyAll);
                        subjectReportsVO.setYsHappenTaxMnyAll(ysHappenTaxMnyAll);
                        ysMap.put(subjectId,subjectReportsVO);
                    }else{
                        ysMap.put(subjectId,e);
                    }
                }else if(subjectMap.containsKey(subjectId)){
                    logger.info("预算数据科目在对应关系表里。。");
                    //科目在转换表里有
                    String unitName = subjectMap.get(subjectId);
                    if(StringUtils.isEmpty(unitName)){
                        logger.info("预算数据科目 对应主表单位为空!!!!!!!!!!!");
                        //该科目成本单位为空  则不进行数量统计
                        e.setYsNum(BigDecimal.ZERO);
                        e.setYsNumAll(BigDecimal.ZERO);
                        if(ysMap.containsKey(subjectId)){
                            SubjectReportsVO subjectReportsVO = ysMap.get(subjectId);
                            BigDecimal ysHappenMny = subjectReportsVO.getYsHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenMny(); // 收入预算-本期发生成本(无税)
                            BigDecimal ysHappenTaxMny = subjectReportsVO.getYsHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenTaxMny(); // 收入预算-本期发生成本(含税)
                            BigDecimal ysHappenMnyAll = subjectReportsVO.getYsHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenMnyAll(); // 收入预算-整体成本(无税)
                            BigDecimal ysHappenTaxMnyAll = subjectReportsVO.getYsHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenTaxMnyAll(); // 收入预算-整体成本(含税)
                            ysHappenMny = ysHappenMny.add(e.getYsHappenMny()==null?BigDecimal.ZERO:e.getYsHappenMny());
                            ysHappenTaxMny = ysHappenTaxMny.add(e.getYsHappenTaxMny()==null?BigDecimal.ZERO:e.getYsHappenTaxMny());
                            ysHappenMnyAll = ysHappenMnyAll.add(e.getYsHappenMnyAll()==null?BigDecimal.ZERO:e.getYsHappenMnyAll());
                            ysHappenTaxMnyAll = ysHappenTaxMnyAll.add(e.getYsHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getYsHappenTaxMnyAll());
                            subjectReportsVO.setYsHappenMny(ysHappenMny);
                            subjectReportsVO.setYsHappenTaxMny(ysHappenTaxMny);
                            subjectReportsVO.setYsHappenMnyAll(ysHappenMnyAll);
                            subjectReportsVO.setYsHappenTaxMnyAll(ysHappenTaxMnyAll);
                            ysMap.put(subjectId,subjectReportsVO);
                        }else{
                            ysMap.put(subjectId,e);
                        }
                    }else{
                        List<UnitDetailVO> unitDetailVOList = unitMap.get(subjectId);
                        if(unitName.equals(ysUnitName)){
                            logger.info("预算数据科目 对应主表单位一致==========");
                            //该科目成本单位 与预算单位一致，不进行转换
                            if(ysMap.containsKey(subjectId)){
                                SubjectReportsVO subjectReportsVO = ysMap.get(subjectId);
                                BigDecimal ysHappenMny = subjectReportsVO.getYsHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenMny(); // 收入预算-本期发生成本(无税)
                                BigDecimal ysHappenTaxMny = subjectReportsVO.getYsHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenTaxMny(); // 收入预算-本期发生成本(含税)
                                BigDecimal ysHappenMnyAll = subjectReportsVO.getYsHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenMnyAll(); // 收入预算-整体成本(无税)
                                BigDecimal ysHappenTaxMnyAll = subjectReportsVO.getYsHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenTaxMnyAll(); // 收入预算-整体成本(含税)
                                BigDecimal num = subjectReportsVO.getYsNum() ==null?BigDecimal.ZERO:subjectReportsVO.getYsNum(); // 收入预算-产值总数量
                                BigDecimal numAll = subjectReportsVO.getYsNumAll() ==null?BigDecimal.ZERO:subjectReportsVO.getYsNumAll(); // 收入预算-总数量
                                ysHappenMny = ysHappenMny.add(e.getYsHappenMny()==null?BigDecimal.ZERO:e.getYsHappenMny());
                                ysHappenTaxMny = ysHappenTaxMny.add(e.getYsHappenTaxMny()==null?BigDecimal.ZERO:e.getYsHappenTaxMny());
                                ysHappenMnyAll = ysHappenMnyAll.add(e.getYsHappenMnyAll()==null?BigDecimal.ZERO:e.getYsHappenMnyAll());
                                ysHappenTaxMnyAll = ysHappenTaxMnyAll.add(e.getYsHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getYsHappenTaxMnyAll());
                                num = num.add(e.getYsNum() ==null?BigDecimal.ZERO:e.getYsNum());
                                numAll = numAll.add(e.getYsNumAll() ==null?BigDecimal.ZERO:e.getYsNumAll());
                                subjectReportsVO.setYsHappenMny(ysHappenMny);
                                subjectReportsVO.setYsHappenTaxMny(ysHappenTaxMny);
                                subjectReportsVO.setYsHappenMnyAll(ysHappenMnyAll);
                                subjectReportsVO.setYsHappenTaxMnyAll(ysHappenTaxMnyAll);
                                subjectReportsVO.setYsNum(num);
                                subjectReportsVO.setYsNumAll(numAll);
                                ysMap.put(subjectId,subjectReportsVO);
                            }else{
                                ysMap.put(subjectId,e);
                            }
                        }else if(CollectionUtils.isEmpty(unitDetailVOList)){
                            logger.info("预算数据科目 对应未设置子表!!!!!!!!!");
                            //没有设置转换子表  和没有设置主表单位一样处理
                            e.setYsNum(BigDecimal.ZERO);
                            e.setYsNumAll(BigDecimal.ZERO);
                            if(ysMap.containsKey(subjectId)){
                                SubjectReportsVO subjectReportsVO = ysMap.get(subjectId);
                                BigDecimal ysHappenMny = subjectReportsVO.getYsHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenMny(); // 收入预算-本期发生成本(无税)
                                BigDecimal ysHappenTaxMny = subjectReportsVO.getYsHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenTaxMny(); // 收入预算-本期发生成本(含税)
                                BigDecimal ysHappenMnyAll = subjectReportsVO.getYsHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenMnyAll(); // 收入预算-整体成本(无税)
                                BigDecimal ysHappenTaxMnyAll = subjectReportsVO.getYsHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenTaxMnyAll(); // 收入预算-整体成本(含税)
                                ysHappenMny = ysHappenMny.add(e.getYsHappenMny()==null?BigDecimal.ZERO:e.getYsHappenMny());
                                ysHappenTaxMny = ysHappenTaxMny.add(e.getYsHappenTaxMny()==null?BigDecimal.ZERO:e.getYsHappenTaxMny());
                                ysHappenMnyAll = ysHappenMnyAll.add(e.getYsHappenMnyAll()==null?BigDecimal.ZERO:e.getYsHappenMnyAll());
                                ysHappenTaxMnyAll = ysHappenTaxMnyAll.add(e.getYsHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getYsHappenTaxMnyAll());
                                subjectReportsVO.setYsHappenMny(ysHappenMny);
                                subjectReportsVO.setYsHappenTaxMny(ysHappenTaxMny);
                                subjectReportsVO.setYsHappenMnyAll(ysHappenMnyAll);
                                subjectReportsVO.setYsHappenTaxMnyAll(ysHappenTaxMnyAll);
                                ysMap.put(subjectId,subjectReportsVO);
                            }else{
                                ysMap.put(subjectId,e);
                            }
                        }else{
                            //  有设置单位转换子表
                            Map<String,BigDecimal> map = unitDetailVOList.stream().collect(Collectors.toMap(UnitDetailVO::getConversionUnitName, UnitDetailVO::getScaleFactor));
                            if(!map.containsKey(ysUnitName)){
                                logger.info("预算数据科目 对应设置子表 没有该单位!!!!!!!!!");
                                e.setYsNum(BigDecimal.ZERO);
                                e.setYsNumAll(BigDecimal.ZERO);
                                //如果【单位】不在其他转换单位范围中，【数量】=0，不参与统计；
                                if(ysMap.containsKey(subjectId)){
                                    SubjectReportsVO subjectReportsVO = ysMap.get(subjectId);
                                    BigDecimal ysHappenMny = subjectReportsVO.getYsHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenMny(); // 收入预算-本期发生成本(无税)
                                    BigDecimal ysHappenTaxMny = subjectReportsVO.getYsHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenTaxMny(); // 收入预算-本期发生成本(含税)
                                    BigDecimal ysHappenMnyAll = subjectReportsVO.getYsHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenMnyAll(); // 收入预算-整体成本(无税)
                                    BigDecimal ysHappenTaxMnyAll = subjectReportsVO.getYsHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenTaxMnyAll(); // 收入预算-整体成本(含税)
                                    ysHappenMny = ysHappenMny.add(e.getYsHappenMny()==null?BigDecimal.ZERO:e.getYsHappenMny());
                                    ysHappenTaxMny = ysHappenTaxMny.add(e.getYsHappenTaxMny()==null?BigDecimal.ZERO:e.getYsHappenTaxMny());
                                    ysHappenMnyAll = ysHappenMnyAll.add(e.getYsHappenMnyAll()==null?BigDecimal.ZERO:e.getYsHappenMnyAll());
                                    ysHappenTaxMnyAll = ysHappenTaxMnyAll.add(e.getYsHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getYsHappenTaxMnyAll());
                                    subjectReportsVO.setYsHappenMny(ysHappenMny);
                                    subjectReportsVO.setYsHappenTaxMny(ysHappenTaxMny);
                                    subjectReportsVO.setYsHappenMnyAll(ysHappenMnyAll);
                                    subjectReportsVO.setYsHappenTaxMnyAll(ysHappenTaxMnyAll);
                                    ysMap.put(subjectId,subjectReportsVO);
                                }else{
                                    ysMap.put(subjectId,e);
                                }
                            }else{
                                logger.info("预算数据科目 转换开始------>");
                                //如果【单位】在其他转换单位范围中，【数量】=【数量】/转换系数；
                                BigDecimal scaleFactor = map.get(ysUnitName);//转换系数   【数量】=【数量】/转换系数；
                                logger.info("预算数据科目 转换系数------>"+scaleFactor);
                                BigDecimal ysNum = e.getYsNum() ==null?BigDecimal.ZERO:e.getYsNum(); // 收入预算-产值总数量
                                BigDecimal ysNumAll = e.getYsNumAll() ==null?BigDecimal.ZERO:e.getYsNumAll(); // 收入预算-总数量
                                e.setYsNum(ysNum.divide(scaleFactor,2,BigDecimal.ROUND_HALF_DOWN));
                                e.setYsNumAll(ysNumAll.divide(scaleFactor,2,BigDecimal.ROUND_HALF_DOWN));
                                if(ysMap.containsKey(subjectId)){
                                    SubjectReportsVO subjectReportsVO = ysMap.get(subjectId);
                                    BigDecimal ysHappenMny = subjectReportsVO.getYsHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenMny(); // 收入预算-本期发生成本(无税)
                                    BigDecimal ysHappenTaxMny = subjectReportsVO.getYsHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenTaxMny(); // 收入预算-本期发生成本(含税)
                                    BigDecimal ysHappenMnyAll = subjectReportsVO.getYsHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenMnyAll(); // 收入预算-整体成本(无税)
                                    BigDecimal ysHappenTaxMnyAll = subjectReportsVO.getYsHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getYsHappenTaxMnyAll(); // 收入预算-整体成本(含税)
                                    BigDecimal num = subjectReportsVO.getYsNum() ==null?BigDecimal.ZERO:subjectReportsVO.getYsNum(); // 收入预算-产值总数量
                                    BigDecimal numAll = subjectReportsVO.getYsNumAll() ==null?BigDecimal.ZERO:subjectReportsVO.getYsNumAll(); // 收入预算-总数量
                                    ysHappenMny = ysHappenMny.add(e.getYsHappenMny()==null?BigDecimal.ZERO:e.getYsHappenMny());
                                    ysHappenTaxMny = ysHappenTaxMny.add(e.getYsHappenTaxMny()==null?BigDecimal.ZERO:e.getYsHappenTaxMny());
                                    ysHappenMnyAll = ysHappenMnyAll.add(e.getYsHappenMnyAll()==null?BigDecimal.ZERO:e.getYsHappenMnyAll());
                                    ysHappenTaxMnyAll = ysHappenTaxMnyAll.add(e.getYsHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getYsHappenTaxMnyAll());
                                    num = num.add(e.getYsNum() ==null?BigDecimal.ZERO:e.getYsNum());
                                    numAll = numAll.add(e.getYsNumAll() ==null?BigDecimal.ZERO:e.getYsNumAll());
                                    subjectReportsVO.setYsHappenMny(ysHappenMny);
                                    subjectReportsVO.setYsHappenTaxMny(ysHappenTaxMny);
                                    subjectReportsVO.setYsHappenMnyAll(ysHappenMnyAll);
                                    subjectReportsVO.setYsHappenTaxMnyAll(ysHappenTaxMnyAll);
                                    subjectReportsVO.setYsNum(num);
                                    subjectReportsVO.setYsNumAll(numAll);
                                    ysMap.put(subjectId,subjectReportsVO);
                                }else{
                                    ysMap.put(subjectId,e);
                                }
                            }
                        }
                    }
                }
            });
        }
        return ysMap;
    }


    public Map<Long,SubjectReportsVO> changeCbData(List<CostReportVO> mbReportVOList,Map<Long,String> subjectMap,Map<Long, List<UnitDetailVO>> unitMap){
        logger.info("开始转换目标成本信息-----");
        Map<Long,SubjectReportsVO> cbMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(mbReportVOList)){
            List<SubjectReportsVO> cbList = BeanMapper.mapList(mbReportVOList,SubjectReportsVO.class);
            cbList.forEach(e->{
                //进行单位转换
                String cbUnitName = e.getCbUnitName();
                logger.info("目标成本信息单位-----"+cbUnitName);
                Long subjectId = e.getSubjectId();
                logger.info("目标成本信息科目主键-----"+subjectId);
                if(StringUtils.isEmpty(cbUnitName)){
                    logger.info("目标成本数据单位为空，则直接将数量为0  按照subjectId金额相加-----");
                    e.setCbNum(BigDecimal.ZERO);
                    e.setCbNumAll(BigDecimal.ZERO);
                    //目标成本数据单位为空，则直接将数量为0  按照subjectId金额相加
                    if(cbMap.containsKey(subjectId)){
                        SubjectReportsVO subjectReportsVO = cbMap.get(subjectId);
                        BigDecimal cbHappenMny = subjectReportsVO.getCbHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenMny(); // 收入目标成本-本期发生成本(无税)
                        BigDecimal cbHappenTaxMny = subjectReportsVO.getCbHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenTaxMny(); // 收入目标成本-本期发生成本(含税)
                        BigDecimal cbHappenMnyAll = subjectReportsVO.getCbHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenMnyAll(); // 收入目标成本-整体成本(无税)
                        BigDecimal cbHappenTaxMnyAll = subjectReportsVO.getCbHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenTaxMnyAll(); // 收入目标成本-整体成本(含税)
                        cbHappenMny = cbHappenMny.add(e.getCbHappenMny()==null?BigDecimal.ZERO:e.getCbHappenMny());
                        cbHappenTaxMny = cbHappenTaxMny.add(e.getCbHappenTaxMny()==null?BigDecimal.ZERO:e.getCbHappenTaxMny());
                        cbHappenMnyAll = cbHappenMnyAll.add(e.getCbHappenMnyAll()==null?BigDecimal.ZERO:e.getCbHappenMnyAll());
                        cbHappenTaxMnyAll = cbHappenTaxMnyAll.add(e.getCbHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getCbHappenTaxMnyAll());
                        subjectReportsVO.setCbHappenMny(cbHappenMny);
                        subjectReportsVO.setCbHappenTaxMny(cbHappenTaxMny);
                        subjectReportsVO.setCbHappenMnyAll(cbHappenMnyAll);
                        subjectReportsVO.setCbHappenTaxMnyAll(cbHappenTaxMnyAll);
                        cbMap.put(subjectId,subjectReportsVO);
                    }else{
                        cbMap.put(subjectId,e);
                    }
                }else if(subjectMap.containsKey(subjectId)){
                    logger.info("目标成本数据科目在转换表里有-----");
                    //科目在转换表里有
                    String unitName = subjectMap.get(subjectId);
                    if(StringUtils.isEmpty(unitName)){
                        logger.info("目标成本数据科目 未设置主表单位!!!!!!!");
                        //该科目成本单位为空  则不进行数量统计
                        e.setCbNum(BigDecimal.ZERO);
                        e.setCbNumAll(BigDecimal.ZERO);
                        if(cbMap.containsKey(subjectId)){
                            SubjectReportsVO subjectReportsVO = cbMap.get(subjectId);
                            BigDecimal cbHappenMny = subjectReportsVO.getCbHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenMny(); // 收入目标成本-本期发生成本(无税)
                            BigDecimal cbHappenTaxMny = subjectReportsVO.getCbHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenTaxMny(); // 收入目标成本-本期发生成本(含税)
                            BigDecimal cbHappenMnyAll = subjectReportsVO.getCbHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenMnyAll(); // 收入目标成本-整体成本(无税)
                            BigDecimal cbHappenTaxMnyAll = subjectReportsVO.getCbHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenTaxMnyAll(); // 收入目标成本-整体成本(含税)
                            cbHappenMny = cbHappenMny.add(e.getCbHappenMny()==null?BigDecimal.ZERO:e.getCbHappenMny());
                            cbHappenTaxMny = cbHappenTaxMny.add(e.getCbHappenTaxMny()==null?BigDecimal.ZERO:e.getCbHappenTaxMny());
                            cbHappenMnyAll = cbHappenMnyAll.add(e.getCbHappenMnyAll()==null?BigDecimal.ZERO:e.getCbHappenMnyAll());
                            cbHappenTaxMnyAll = cbHappenTaxMnyAll.add(e.getCbHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getCbHappenTaxMnyAll());
                            subjectReportsVO.setCbHappenMny(cbHappenMny);
                            subjectReportsVO.setCbHappenTaxMny(cbHappenTaxMny);
                            subjectReportsVO.setCbHappenMnyAll(cbHappenMnyAll);
                            subjectReportsVO.setCbHappenTaxMnyAll(cbHappenTaxMnyAll);
                            cbMap.put(subjectId,subjectReportsVO);
                        }else{
                            cbMap.put(subjectId,e);
                        }
                    }else{
                        List<UnitDetailVO> unitDetailVOList = unitMap.get(subjectId);
                        if(unitName.equals(cbUnitName)){
                            logger.info("目标成本数据科目 与设置主表单位一致=====");
                            //该科目成本单位 与目标成本单位一致，不进行转换
                            if(cbMap.containsKey(subjectId)){
                                SubjectReportsVO subjectReportsVO = cbMap.get(subjectId);
                                BigDecimal cbHappenMny = subjectReportsVO.getCbHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenMny(); // 收入目标成本-本期发生成本(无税)
                                BigDecimal cbHappenTaxMny = subjectReportsVO.getCbHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenTaxMny(); // 收入目标成本-本期发生成本(含税)
                                BigDecimal cbHappenMnyAll = subjectReportsVO.getCbHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenMnyAll(); // 收入目标成本-整体成本(无税)
                                BigDecimal cbHappenTaxMnyAll = subjectReportsVO.getCbHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenTaxMnyAll(); // 收入目标成本-整体成本(含税)
                                BigDecimal num = subjectReportsVO.getCbNum() ==null?BigDecimal.ZERO:subjectReportsVO.getCbNum(); // 收入目标成本-产值总数量
                                BigDecimal numAll = subjectReportsVO.getCbNumAll() ==null?BigDecimal.ZERO:subjectReportsVO.getCbNumAll(); // 收入目标成本-总数量
                                cbHappenMny = cbHappenMny.add(e.getCbHappenMny()==null?BigDecimal.ZERO:e.getCbHappenMny());
                                cbHappenTaxMny = cbHappenTaxMny.add(e.getCbHappenTaxMny()==null?BigDecimal.ZERO:e.getCbHappenTaxMny());
                                cbHappenMnyAll = cbHappenMnyAll.add(e.getCbHappenMnyAll()==null?BigDecimal.ZERO:e.getCbHappenMnyAll());
                                cbHappenTaxMnyAll = cbHappenTaxMnyAll.add(e.getCbHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getCbHappenTaxMnyAll());
                                num = num.add(e.getCbNum() ==null?BigDecimal.ZERO:e.getCbNum());
                                numAll = numAll.add(e.getCbNumAll() ==null?BigDecimal.ZERO:e.getCbNumAll());
                                subjectReportsVO.setCbHappenMny(cbHappenMny);
                                subjectReportsVO.setCbHappenTaxMny(cbHappenTaxMny);
                                subjectReportsVO.setCbHappenMnyAll(cbHappenMnyAll);
                                subjectReportsVO.setCbHappenTaxMnyAll(cbHappenTaxMnyAll);
                                subjectReportsVO.setCbNum(num);
                                subjectReportsVO.setCbNumAll(numAll);
                                cbMap.put(subjectId,subjectReportsVO);
                            }else{
                                cbMap.put(subjectId,e);
                            }
                        }else if(CollectionUtils.isEmpty(unitDetailVOList)){
                            logger.info("目标成本数据科目 对应未设置子表!!!!!!!!!");
                            //没有设置转换子表  和没有设置主表单位一样处理
                            e.setCbNum(BigDecimal.ZERO);
                            e.setCbNumAll(BigDecimal.ZERO);
                            if(cbMap.containsKey(subjectId)){
                                SubjectReportsVO subjectReportsVO = cbMap.get(subjectId);
                                BigDecimal cbHappenMny = subjectReportsVO.getCbHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenMny(); // 收入目标成本-本期发生成本(无税)
                                BigDecimal cbHappenTaxMny = subjectReportsVO.getCbHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenTaxMny(); // 收入目标成本-本期发生成本(含税)
                                BigDecimal cbHappenMnyAll = subjectReportsVO.getCbHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenMnyAll(); // 收入目标成本-整体成本(无税)
                                BigDecimal cbHappenTaxMnyAll = subjectReportsVO.getCbHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenTaxMnyAll(); // 收入目标成本-整体成本(含税)
                                cbHappenMny = cbHappenMny.add(e.getCbHappenMny()==null?BigDecimal.ZERO:e.getCbHappenMny());
                                cbHappenTaxMny = cbHappenTaxMny.add(e.getCbHappenTaxMny()==null?BigDecimal.ZERO:e.getCbHappenTaxMny());
                                cbHappenMnyAll = cbHappenMnyAll.add(e.getCbHappenMnyAll()==null?BigDecimal.ZERO:e.getCbHappenMnyAll());
                                cbHappenTaxMnyAll = cbHappenTaxMnyAll.add(e.getCbHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getCbHappenTaxMnyAll());
                                subjectReportsVO.setCbHappenMny(cbHappenMny);
                                subjectReportsVO.setCbHappenTaxMny(cbHappenTaxMny);
                                subjectReportsVO.setCbHappenMnyAll(cbHappenMnyAll);
                                subjectReportsVO.setCbHappenTaxMnyAll(cbHappenTaxMnyAll);
                                cbMap.put(subjectId,subjectReportsVO);
                            }else{
                                cbMap.put(subjectId,e);
                            }
                        }else{
                            //  有设置单位转换子表
                            Map<String,BigDecimal> map = unitDetailVOList.stream().collect(Collectors.toMap(UnitDetailVO::getConversionUnitName, UnitDetailVO::getScaleFactor));
                            if(!map.containsKey(cbUnitName)){
                                logger.info("目标成本数据科目 对应设置子表 没有该单位!!!!!!!!!");
                                e.setCbNum(BigDecimal.ZERO);
                                e.setCbNumAll(BigDecimal.ZERO);
                                //如果【单位】不在其他转换单位范围中，【数量】=0，不参与统计；
                                if(cbMap.containsKey(subjectId)){
                                    SubjectReportsVO subjectReportsVO = cbMap.get(subjectId);
                                    BigDecimal cbHappenMny = subjectReportsVO.getCbHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenMny(); // 收入目标成本-本期发生成本(无税)
                                    BigDecimal cbHappenTaxMny = subjectReportsVO.getCbHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenTaxMny(); // 收入目标成本-本期发生成本(含税)
                                    BigDecimal cbHappenMnyAll = subjectReportsVO.getCbHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenMnyAll(); // 收入目标成本-整体成本(无税)
                                    BigDecimal cbHappenTaxMnyAll = subjectReportsVO.getCbHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenTaxMnyAll(); // 收入目标成本-整体成本(含税)
                                    cbHappenMny = cbHappenMny.add(e.getCbHappenMny()==null?BigDecimal.ZERO:e.getCbHappenMny());
                                    cbHappenTaxMny = cbHappenTaxMny.add(e.getCbHappenTaxMny()==null?BigDecimal.ZERO:e.getCbHappenTaxMny());
                                    cbHappenMnyAll = cbHappenMnyAll.add(e.getCbHappenMnyAll()==null?BigDecimal.ZERO:e.getCbHappenMnyAll());
                                    cbHappenTaxMnyAll = cbHappenTaxMnyAll.add(e.getCbHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getCbHappenTaxMnyAll());
                                    subjectReportsVO.setCbHappenMny(cbHappenMny);
                                    subjectReportsVO.setCbHappenTaxMny(cbHappenTaxMny);
                                    subjectReportsVO.setCbHappenMnyAll(cbHappenMnyAll);
                                    subjectReportsVO.setCbHappenTaxMnyAll(cbHappenTaxMnyAll);
                                    cbMap.put(subjectId,subjectReportsVO);
                                }else{
                                    cbMap.put(subjectId,e);
                                }
                            }else{
                                logger.info("目标成本数据科目 开始转换------>");
                                //如果【单位】在其他转换单位范围中，【数量】=【数量】/转换系数；
                                BigDecimal scaleFactor = map.get(cbUnitName);//转换系数   【数量】=【数量】/转换系数；
                                logger.info("目标成本数据科目 转换系数------>"+scaleFactor);
                                BigDecimal cbNum = e.getCbNum() ==null?BigDecimal.ZERO:e.getCbNum(); // 收入目标成本-产值总数量
                                BigDecimal cbNumAll = e.getCbNumAll() ==null?BigDecimal.ZERO:e.getCbNumAll(); // 收入目标成本-总数量
                                e.setCbNum(cbNum.divide(scaleFactor,2,BigDecimal.ROUND_HALF_DOWN));
                                e.setCbNumAll(cbNumAll.divide(scaleFactor,2,BigDecimal.ROUND_HALF_DOWN));
                                if(cbMap.containsKey(subjectId)){
                                    SubjectReportsVO subjectReportsVO = cbMap.get(subjectId);
                                    BigDecimal cbHappenMny = subjectReportsVO.getCbHappenMny()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenMny(); // 收入目标成本-本期发生成本(无税)
                                    BigDecimal cbHappenTaxMny = subjectReportsVO.getCbHappenTaxMny()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenTaxMny(); // 收入目标成本-本期发生成本(含税)
                                    BigDecimal cbHappenMnyAll = subjectReportsVO.getCbHappenMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenMnyAll(); // 收入目标成本-整体成本(无税)
                                    BigDecimal cbHappenTaxMnyAll = subjectReportsVO.getCbHappenTaxMnyAll()==null?BigDecimal.ZERO:subjectReportsVO.getCbHappenTaxMnyAll(); // 收入目标成本-整体成本(含税)
                                    BigDecimal num = subjectReportsVO.getCbNum() ==null?BigDecimal.ZERO:subjectReportsVO.getCbNum(); // 收入目标成本-产值总数量
                                    BigDecimal numAll = subjectReportsVO.getCbNumAll() ==null?BigDecimal.ZERO:subjectReportsVO.getCbNumAll(); // 收入目标成本-总数量
                                    cbHappenMny = cbHappenMny.add(e.getCbHappenMny()==null?BigDecimal.ZERO:e.getCbHappenMny());
                                    cbHappenTaxMny = cbHappenTaxMny.add(e.getCbHappenTaxMny()==null?BigDecimal.ZERO:e.getCbHappenTaxMny());
                                    cbHappenMnyAll = cbHappenMnyAll.add(e.getCbHappenMnyAll()==null?BigDecimal.ZERO:e.getCbHappenMnyAll());
                                    cbHappenTaxMnyAll = cbHappenTaxMnyAll.add(e.getCbHappenTaxMnyAll()==null?BigDecimal.ZERO:e.getCbHappenTaxMnyAll());
                                    num = num.add(e.getCbNum() ==null?BigDecimal.ZERO:e.getCbNum());
                                    numAll = numAll.add(e.getCbNumAll() ==null?BigDecimal.ZERO:e.getCbNumAll());
                                    subjectReportsVO.setCbHappenMny(cbHappenMny);
                                    subjectReportsVO.setCbHappenTaxMny(cbHappenTaxMny);
                                    subjectReportsVO.setCbHappenMnyAll(cbHappenMnyAll);
                                    subjectReportsVO.setCbHappenTaxMnyAll(cbHappenTaxMnyAll);
                                    subjectReportsVO.setCbNum(num);
                                    subjectReportsVO.setCbNumAll(numAll);
                                    cbMap.put(subjectId,subjectReportsVO);
                                }else{
                                    cbMap.put(subjectId,e);
                                }
                            }
                        }
                    }
                }
            });
        }
        return cbMap;
    }
    class BillDetailCallable implements Callable<JSONObject> {

        private RequestAttributes context;
        private String billTypeCode;
        private String parameter;
        private String condition;
        private String authority;
        private String taxFlag;
        private String path;

        public BillDetailCallable(RequestAttributes context,String billTypeCode, String parameter, String condition, String authority,String taxFlag,String path) {
            this.context = context;
            this.billTypeCode = billTypeCode;
            this.parameter = parameter;
            this.condition = condition;
            this.authority = authority;
            this.taxFlag = taxFlag;
            this.path = path;
        }

        @Override
        public JSONObject call() throws Exception {
            JSONObject jsonObject = new JSONObject();
            context.setAttribute("authority", authority, RequestAttributes.SCOPE_REQUEST);
            RequestContextHolder.setRequestAttributes(context);
            List<Map<String, Object>> list = commenQueryFieldsService.queryBillList(billTypeCode,parameter,condition);
//            System.out.println(list==null?0:list.size());
            List<ShareDetailVO> newsVos = null;
            if(CollectionUtils.isNotEmpty(list)){
                newsVos = BeanMapper.mapList(list, ShareDetailVO.class);
                newsVos.forEach(e->{
                    e.setBillType(billTypeCode);
                    if("0".equals(taxFlag)){
                        e.setHappenMny(e.getHappenTaxMny()==null?BigDecimal.ZERO:e.getHappenTaxMny());
                    }
                    e.setRowState("add");
                    e.setId(e.getSourceId());
                    e.setPath(path);
                });
            }
            jsonObject.put("jsonRes", newsVos);
            return jsonObject;
        }
    }

    //找到最底层的叶子节点
    public List<SubjectReportsVO> getBottomNode(List<SubjectReportsVO> listGoal) {
        Map<Long, SubjectReportsVO> map = new HashMap<Long, SubjectReportsVO>();
        for (SubjectReportsVO g : listGoal) {
            map.put(g.getId(), g);
        }

        for (SubjectReportsVO g : listGoal) {
            Long pid = g.getParentId();
            if (map.containsKey(pid)) {
                map.remove(pid);
            }
        }
        return new ArrayList<SubjectReportsVO>(map.values());
    }

    public List<SubjectReportsVO> setParentValue(List<SubjectReportsVO> listAllGoal, List<SubjectReportsVO> listBottomGoal) {

        Map<Long, List<SubjectReportsVO>> map = new HashMap<Long, List<SubjectReportsVO>>();
        for (SubjectReportsVO g : listBottomGoal) {
            Long pid = g.getParentId();
            List<SubjectReportsVO> listGoal = map.get(pid);
            if (listGoal == null) {
                listGoal = new ArrayList<SubjectReportsVO>();
            }
            listGoal.add(g);
            map.put(pid, listGoal);
        }

        for (Long i : map.keySet()) {
            List<SubjectReportsVO> tempListGoal = map.get(i);
            BigDecimal result = BigDecimal.ZERO;
            BigDecimal result2 = BigDecimal.ZERO;
            for (SubjectReportsVO g : tempListGoal) {
                result = result.add(g.getHappenMny()==null?BigDecimal.ZERO:g.getHappenMny());
                result2 = result2.add(g.getHappenMnySum()==null?BigDecimal.ZERO:g.getHappenMnySum());
            }
            for (SubjectReportsVO g : listAllGoal) {
                Long id = g.getId();
                if (id.longValue() == i.longValue()) {
                    List<SubjectReportsVO> tempList = g.getChildren();
                    if (tempList != null) {
                        tempListGoal.addAll(tempList);
                    }
                    g.setChildren(tempListGoal);
                    BigDecimal score = g.getHappenMny()==null?BigDecimal.ZERO:g.getHappenMny();
                    BigDecimal score2 = g.getHappenMnySum()==null?BigDecimal.ZERO:g.getHappenMnySum();
                    score = score.add(result);
                    score2 = score2.add(result2);
                    g.setHappenMny(score);
                    g.setHappenMnySum(score2);
                }
            }
        }

        for (SubjectReportsVO g : listBottomGoal) {
            listAllGoal.remove(g);
        }

        return listAllGoal;
    }

    public List<SubjectReportsVO> setParentValue2(List<SubjectReportsVO> listAllGoal, List<SubjectReportsVO> listBottomGoal) {

        Map<Long, List<SubjectReportsVO>> map = new HashMap<Long, List<SubjectReportsVO>>();
        for (SubjectReportsVO g : listBottomGoal) {
            Long pid = g.getParentId();
            List<SubjectReportsVO> listGoal = map.get(pid);
            if (listGoal == null) {
                listGoal = new ArrayList<SubjectReportsVO>();
            }
            listGoal.add(g);
            map.put(pid, listGoal);
        }

        for (Long i : map.keySet()) {
            List<SubjectReportsVO> tempListGoal = map.get(i);
            BigDecimal  result= BigDecimal.ZERO;//实际成本-本期发生成本(无税)
            BigDecimal result2 = BigDecimal.ZERO;// 实际成本-本期发生成本(含税)
            BigDecimal result3 = BigDecimal.ZERO;// 实际成本-整体成本(无税)
            BigDecimal result4 = BigDecimal.ZERO; // 实际成本-整体成本(含税)
            BigDecimal result5 = BigDecimal.ZERO;// 收入预算-本期发生成本(无税)
            BigDecimal result6 = BigDecimal.ZERO;// 收入预算-本期发生成本(含税)
            BigDecimal result7 = BigDecimal.ZERO;// 收入预算-整体成本(无税)
            BigDecimal result8 = BigDecimal.ZERO;// 收入预算-整体成本(含税)
//            BigDecimal result9 = BigDecimal.ZERO;// 目标成本-本期发生成本(无税)
//            BigDecimal result10 = BigDecimal.ZERO;// 目标成本-本期发生成本(含税)
            for (SubjectReportsVO g : tempListGoal) {
                result = result.add(g.getHappenMny()==null?BigDecimal.ZERO:g.getHappenMny());
                result2 = result2.add(g.getHappenTaxMny()==null?BigDecimal.ZERO:g.getHappenTaxMny());
                result3 = result3.add(g.getHappenMnyAll()==null?BigDecimal.ZERO:g.getHappenMnyAll());
                result4 = result4.add(g.getHappenTaxMnyAll()==null?BigDecimal.ZERO:g.getHappenTaxMnyAll());

                result5= result5.add(g.getYsHappenMny()==null?BigDecimal.ZERO:g.getYsHappenMny());
                result6 = result6.add(g.getYsHappenTaxMny()==null?BigDecimal.ZERO:g.getYsHappenTaxMny());
                result7 = result7.add(g.getYsHappenMnyAll()==null?BigDecimal.ZERO:g.getYsHappenMnyAll());
                result8 = result8.add(g.getYsHappenTaxMnyAll()==null?BigDecimal.ZERO:g.getYsHappenTaxMnyAll());

//                result9 = result9.add(g.getCbHappenMny()==null?BigDecimal.ZERO:g.getCbHappenMny());
//                result10 = result10.add(g.getCbHappenTaxMny()==null?BigDecimal.ZERO:g.getCbHappenTaxMny());


            }
            for (SubjectReportsVO g : listAllGoal) {
                Long id = g.getId();
                if (id.longValue() == i.longValue()) {
                    List<SubjectReportsVO> tempList = g.getChildren();
                    if (tempList != null) {
                        tempListGoal.addAll(tempList);
                    }
                    g.setChildren(tempListGoal);
                    BigDecimal score = g.getHappenMny()==null?BigDecimal.ZERO:g.getHappenMny();
                    BigDecimal score2 = g.getHappenTaxMny()==null?BigDecimal.ZERO:g.getHappenTaxMny();
                    BigDecimal score3 = g.getHappenMnyAll()==null?BigDecimal.ZERO:g.getHappenMnyAll();
                    BigDecimal score4 = g.getHappenTaxMnyAll()==null?BigDecimal.ZERO:g.getHappenTaxMnyAll();

                    BigDecimal score5 = g.getYsHappenMny()==null?BigDecimal.ZERO:g.getYsHappenMny();
                    BigDecimal score6 = g.getYsHappenTaxMny()==null?BigDecimal.ZERO:g.getYsHappenTaxMny();
                    BigDecimal score7 = g.getYsHappenMnyAll()==null?BigDecimal.ZERO:g.getYsHappenMnyAll();
                    BigDecimal score8 = g.getYsHappenTaxMnyAll()==null?BigDecimal.ZERO:g.getYsHappenTaxMnyAll();

                    BigDecimal score9 = g.getCbHappenMny()==null?BigDecimal.ZERO:g.getCbHappenMny();
                    BigDecimal score10 = g.getCbHappenTaxMny()==null?BigDecimal.ZERO:g.getCbHappenTaxMny();

                    score = score.add(result);
                    score2 = score2.add(result2);
                    score3 = score3.add(result3);
                    score4 = score4.add(result4);

                    score5 = score5.add(result5);
                    score6 = score6.add(result6);
                    score7 = score7.add(result7);
                    score8 = score8.add(result8);

//                    score9 = score9.add(result9);
//                    score10 = score10.add(result10);

                    g.setHappenMny(score);
                    g.setHappenTaxMny(score2);
                    g.setHappenMnyAll(score3);
                    g.setHappenTaxMnyAll(score4);

                    g.setYsHappenMny(score5);
                    g.setYsHappenTaxMny(score6);
                    g.setYsHappenMnyAll(score7);
                    g.setYsHappenTaxMnyAll(score8);

//                    g.setCbHappenMny(score9);
//                    g.setCbHappenTaxMny(score10);
                }
            }
        }

        for (SubjectReportsVO g : listBottomGoal) {
            listAllGoal.remove(g);
        }

        return listAllGoal;
    }

    public SubjectReportsVO calculateValue(List<SubjectReportsVO> listGoal) {
        if (listGoal.size() == 1) {
            return listGoal.get(0);
        } else {
            List<SubjectReportsVO> listBottomGoal = getBottomNode(listGoal);
            List<SubjectReportsVO> list = setParentValue(listGoal, listBottomGoal);
            return calculateValue(list);
        }
    }


    public void printGoal(SubjectReportsVO goal,List<SubjectReportsVO> list) {
        list.add(goal);
        List<SubjectReportsVO> listGoal = goal.getChildren();
        if (listGoal == null || listGoal.size() == 0) {
            return;
        }
        for (SubjectReportsVO g : listGoal) {
            printGoal(g,list);
        }
    }

    public SubjectReportsVO calculateValue2(List<SubjectReportsVO> listGoal) {
        if (listGoal.size() == 1) {
            return listGoal.get(0);
        } else {
            List<SubjectReportsVO> listBottomGoal = getBottomNode(listGoal);
            List<SubjectReportsVO> list = setParentValue2(listGoal, listBottomGoal);
            return calculateValue2(list);
        }
    }

    @Override
    public List<Map<String, Object>> queryCollectionWarnCost(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> mapList  = new ArrayList<>();
        //获取时间
        Date date = new Date();
        Date oneDate = DateUtil.setDays(date, 1);
        Integer betweenDays = DateUtil.getBetweenDays(date, oneDate);
        Date oldDate = DateUtil.addMonths(oneDate, -1);
        String s = DateFormatUtil.formatDate("yyyy-MM", oldDate);
        //获取项目
        CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectPoolList(null, null, null);
        if(!jsonArrayCommonResponse.isSuccess()){
            logger.error("查询所有项目失败！报错信息:-----{}"+jsonArrayCommonResponse.getMsg());
            return mapList;
        }
        JSONArray data = jsonArrayCommonResponse.getData();
        List<ProjectPoolSetVO> projectData = JSONObject.parseArray(data.toJSONString(), ProjectPoolSetVO.class);
        logger.info("项目信息条数：{}",projectData.size());
        //获取实际成本
        LambdaQueryWrapper<ShareEntity> lambda = new LambdaQueryWrapper<ShareEntity>();
        lambda.eq(ShareEntity::getPeriod,s);
        lambda.eq(ShareEntity::getDr, BaseVO.DR_UNDELETE);
        lambda.in(ShareEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        List<ShareEntity> list = super.list(lambda);
        logger.info("成本条数：{}",list.size());
        //按照租户id分组
        Map<Long, List<ShareEntity>> costTenantIdMap = list.stream().filter(t->null!=t.getTenantId()).collect(Collectors.groupingBy(ShareEntity::getTenantId));
        logger.info("成本租户分组条数：{}",costTenantIdMap.size());
        for (SqlParam sqlParam : sqlParamList) {
            Integer day = sqlParam.getValue().intValue();
            logger.info("当前日期：{},当前月第一天日期：{}，差值：{},上一个月：{},隔天数：{},租户id:{}",DateFormatUtil.formatDate("yyyy-MM-dd",date), DateFormatUtil.formatDate("yyyy-MM-dd",oneDate),betweenDays,s,day,sqlParam.getTenantId());
            if(betweenDays<day){
                logger.error("不到预警时间");
                continue;
            }
            //按照项目分组
            List<ShareEntity> shareList = null==costTenantIdMap.get(sqlParam.getTenantId()) ? new ArrayList<>(): costTenantIdMap.get(sqlParam.getTenantId());
            Map<Long, List<ShareEntity>> costMap = shareList.stream().filter(t->null!=t.getProjectId()).collect(Collectors.groupingBy(ShareEntity::getProjectId));
            //遍历项目组合预警信息
            if(CollectionUtils.isNotEmpty(projectData)){
                for (ProjectPoolSetVO projectPoolSetVO : projectData) {
                    if(null==projectPoolSetVO.getTenantId() || !projectPoolSetVO.getTenantId().equals(sqlParam.getTenantId())){
                        continue;
                    }
                    List<ShareEntity> shareEntities = costMap.get(projectPoolSetVO.getId());
                    if(null==shareEntities || CollectionUtils.isEmpty(shareEntities)){
                        Map<String, Object> map =  new HashMap<String, Object>();
                        map.put("orgId",projectPoolSetVO.getOrgId());
                        map.put("orgName",projectPoolSetVO.getOrgName());
                        map.put("tenantId",projectPoolSetVO.getTenantId());
                        map.put("projectName",projectPoolSetVO.getName());
                        map.put("projectId",projectPoolSetVO.getId());
                        map.put("warnLevel",sqlParam.getWarnLevel());
                        mapList.add(map);
                    }
                }
            }
        }
        return mapList;
    }
    @Override
    public List<Map<String, Object>> queryOutputWarnCost(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> mapList  = new ArrayList<>();
        //获取产值报量
        CommonResponse<Map<Long, ProductionVO>> mapCommonResponse = proincomeContractApi.queryTotalProduction();
        if(!mapCommonResponse.isSuccess()){
            logger.error("查询产值报量失败，报错信息：{}",mapCommonResponse.getMsg());
        }
        Map<Long, ProductionVO> data = mapCommonResponse.getData();
        logger.info("产值报量条数：{}",data.size());
        //获取项目
        CommonResponse<JSONArray> jsonArrayCommonResponse = projectPoolApi.queryProjectPoolList(null, null, null);
        if(!jsonArrayCommonResponse.isSuccess()){
            logger.error("查询所有项目失败！报错信息:-----{}"+jsonArrayCommonResponse.getMsg());
            return mapList;
        }
        JSONArray jsonArray = jsonArrayCommonResponse.getData();
        List<ProjectPoolSetVO> projectData = JSONObject.parseArray(jsonArray.toJSONString(), ProjectPoolSetVO.class);
        Map<Long, ProjectPoolSetVO> projectMap = projectData.stream().filter(t -> null!=t.getId()).collect(Collectors.toMap(ProjectPoolSetVO::getId, item -> item, (v1, v2) -> v2));
        logger.info("项目信息条数：{}",projectMap.size());
        //获取实际成本
        LambdaQueryWrapper<ShareEntity> lambda = new LambdaQueryWrapper<ShareEntity>();
        lambda.eq(ShareEntity::getDr, BaseVO.DR_UNDELETE);
        lambda.in(ShareEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        List<ShareEntity> list = super.list(lambda);
        logger.info("成本条数：{}",list.size());
        //按照租户id分组
        Map<Long, List<ShareEntity>> costTenantIdMap = list.stream().filter(t->null!=t.getTenantId()).collect(Collectors.groupingBy(ShareEntity::getTenantId));
        logger.info("成本租户分组条数：{}",costTenantIdMap.size());
        for (SqlParam sqlParam : sqlParamList) {
            BigDecimal bigDecimal = null ==sqlParam.getValue()?BigDecimal.ZERO: new BigDecimal(sqlParam.getValue());
            BigDecimal roleValue = ComputeUtil.safeDiv(bigDecimal, new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
            //按照项目分组
            List<ShareEntity> shareList = null==costTenantIdMap.get(sqlParam.getTenantId()) ? new ArrayList<>(): costTenantIdMap.get(sqlParam.getTenantId());
            if(CollectionUtils.isEmpty(shareList)){
                continue;
            }
            Map<Long, List<ShareEntity>> costMap = shareList.stream().filter(t->null!=t.getProjectId()).collect(Collectors.groupingBy(ShareEntity::getProjectId));
            //遍历项目组合预警信息
            if(MapUtil.isNotEmpty(costMap)){
                for (Long projectId : costMap.keySet()) {
                    List<ShareEntity> shareCost = costMap.get(projectId);
                    if(null==shareCost || CollectionUtils.isEmpty(shareCost)){
                        continue;
                    }
                    ProjectPoolSetVO projectPoolSetVO = projectMap.get(projectId);
                    ShareEntity shareEntity = shareCost.get(0);
                    BigDecimal reduce = shareCost.stream().filter(e -> null!= e.getCostMny()).map(ShareEntity::getCostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    ProductionVO productionVO = data.get(projectId);
                    BigDecimal productionTaxMny =null==productionVO ? BigDecimal.ZERO : (null==productionVO.getProductionTaxMny() ? BigDecimal.ZERO:productionVO.getProductionTaxMny());
                    BigDecimal bigDecimal1 = ComputeUtil.safeMultiply(productionTaxMny, roleValue);
                    logger.info("--项目id：{},项目名称：{},实际成本累计：{},产值报量累计：{},百分比：{},百分比后产值报量累计：{}--",projectId,shareEntity.getProjectName(),reduce,productionTaxMny,roleValue,bigDecimal1);
                    Long orgId = null==projectPoolSetVO ? shareEntity.getParentOrgId():projectPoolSetVO.getOrgId();
                    String orgName = null==projectPoolSetVO ? shareEntity.getParentOrgName():projectPoolSetVO.getOrgName();
                    if(bigDecimal1.compareTo(BigDecimal.ZERO)>0 && reduce.compareTo(bigDecimal1)>0){
                        Map<String, Object> map =  new HashMap<String, Object>();
                        map.put("orgId",orgId);
                        map.put("orgName",orgName);
                        map.put("tenantId",shareEntity.getTenantId());
                        map.put("projectName",shareEntity.getProjectName());
                        map.put("projectId",shareEntity.getId());
                        map.put("warnLevel",sqlParam.getWarnLevel());
                        mapList.add(map);
                    }
                }
            }
        }
        return mapList;
    }

    @Override
    public List<ThreeReportVO> getThreeReportVO(Long projectId, String beginPeriod,String endPeriod) {
        int type = 0;//是否显示为0的数据    0-显示  1-不显示
//        CommonResponse<List<SubjectOrgVO>> resDate= shareSubjectOrgApi.shareSubjectOrgApi();
//        if(!resDate.isSuccess()) {
//            throw new BusinessException("查询科目信息失败!");
//        }

        //不取税金值
        QueryParam param = new QueryParam();
        CommonResponse<List<SubjectOrgVO>> resDate= shareSubjectOrgApi.querySubjectOrg(param);
        if(!resDate.isSuccess()) {
            throw new BusinessException("查询科目信息失败!");
        }
        logger.info("科目信息-----"+JSONObject.toJSONString(resDate.getData()));

        //去收入预算  的  科目  金额
        CommonResponse<List<BudgetReportVO>> ysRes = budgetApi.querySumBudgetMny(projectId,beginPeriod,endPeriod);
        if(!ysRes.isSuccess()) {
            throw new BusinessException("查询预算信息失败!");
        }
        List<BudgetReportVO> budgetReportVOList = ysRes.getData();
        logger.info("预算返回信息---------"+JSONObject.toJSONString(budgetReportVOList));
        Map<Long,SubjectReportsVO> ysMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(budgetReportVOList)){
            List<SubjectReportsVO> ysList = BeanMapper.mapList(budgetReportVOList,SubjectReportsVO.class);
            ysList.forEach(e->{
                ysMap.put(e.getSubjectId(),e);
            });
        }
        //取实际成本的  科目  金额   截止本期
        List<SubjectReportsVO> listPeriod = baseMapper.getCostDetail(projectId,beginPeriod,endPeriod);
        Map<Long,SubjectReportsVO> mapPeriod = new HashMap<>();
        if(CollectionUtils.isNotEmpty(listPeriod)){
            listPeriod.forEach(e->{
                mapPeriod.put(e.getSubjectId(),e);
            });
        }

        //取实际成本的  科目  金额  全部
        List<SubjectReportsVO> listAll = baseMapper.getCostDetail(projectId,"","");
        Map<Long,SubjectReportsVO> cbMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(listAll)){
            listAll.forEach(e->{
                e.setHappenMnyAll(e.getHappenMny());
                e.setHappenTaxMnyAll(e.getHappenTaxMny());
                if(mapPeriod.containsKey(e.getSubjectId())){
                    e.setHappenMny(mapPeriod.get(e.getSubjectId()).getHappenMny()==null?BigDecimal.ZERO:mapPeriod.get(e.getSubjectId()).getHappenMny());
                    e.setHappenTaxMny(mapPeriod.get(e.getSubjectId()).getHappenTaxMny()==null?BigDecimal.ZERO:mapPeriod.get(e.getSubjectId()).getHappenTaxMny());
                }else{
                    e.setHappenMny(null);
                    e.setHappenTaxMny(null);
                }
                cbMap.put(e.getSubjectId(),e);
            });
        }
        //todo 取目标成本
        CommonResponse<List<CostReportVO>> mbRes = targetCostFinishApi.costReportQuery(projectId,endPeriod,beginPeriod);
        if(!mbRes.isSuccess()) {
            throw new BusinessException("查询，目标信息失败!");
        }
        List<CostReportVO> mbReportVOList = mbRes.getData();
        logger.info("目标返回信息---------"+JSONObject.toJSONString(mbReportVOList));
        Map<Long,SubjectReportsVO> sjMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(mbReportVOList)){
            List<SubjectReportsVO> sjList = BeanMapper.mapList(mbReportVOList,SubjectReportsVO.class);
            sjList.forEach(e->{
                sjMap.put(e.getSubjectId(),e);
            });
        }

        //根据科目树  将三算数据汇总到一起
        List<SubjectOrgVO> subjectOrgVOList = resDate.getData();
        Map<Long,SubjectReportsVO> mapList = new HashMap<>();
        if(CollectionUtils.isNotEmpty(subjectOrgVOList)){
            subjectOrgVOList.forEach(e->{
                SubjectReportsVO vo = new SubjectReportsVO();
                SubjectReportsVO ysvo = ysMap.get(e.getId());
                SubjectReportsVO cbvo = cbMap.get(e.getId());
                SubjectReportsVO sjvo = sjMap.get(e.getId());
                vo.setSubjectId(e.getId());
                vo.setSubjectName(e.getSubjectName());
                vo.setSubjectCode(e.getSubjectCode());
                if(null!=ysvo){
                    vo.setYsHappenMny(ysvo.getYsHappenMny());
                    vo.setYsHappenTaxMny(ysvo.getYsHappenTaxMny());
                    vo.setYsHappenMnyAll(ysvo.getYsHappenMnyAll());
                    vo.setYsHappenTaxMnyAll(ysvo.getYsHappenTaxMnyAll());
                }
                if(null!=cbvo){
                    vo.setHappenMny(cbvo.getHappenMny());
                    vo.setHappenMnyAll(cbvo.getHappenMnyAll());
                    vo.setHappenTaxMny(cbvo.getHappenTaxMny());
                    vo.setHappenTaxMnyAll(cbvo.getHappenTaxMnyAll());
                }
                if(null!=sjvo){
                    vo.setCbHappenMny(sjvo.getCbHappenMny());
                    vo.setCbHappenTaxMny(sjvo.getCbHappenTaxMny());
                    vo.setCbHappenMnyAll(sjvo.getCbHappenMnyAll());
                    vo.setCbHappenTaxMnyAll(sjvo.getCbHappenTaxMnyAll());
                }

                mapList.put(e.getId(),vo);
            });
        }
        List<SubjectReportsVO> allList = new ArrayList<>();
        for(int i=0;i<subjectOrgVOList.size();i++){
            SubjectOrgVO subjectOrgVO = subjectOrgVOList.get(i);
            SubjectReportsVO vo = mapList.get(subjectOrgVO.getId());
            if(null!=vo){
                vo.setId(subjectOrgVO.getId());
                vo.setNumber(i+1);
                vo.setSubjectId(subjectOrgVO.getId());
                vo.setSubjectCode(subjectOrgVO.getSubjectCode());
                vo.setSubjectName(subjectOrgVO.getSubjectName());
                vo.setParentId(subjectOrgVO.getParentId());
            }else{
                vo = new SubjectReportsVO();
                vo.setId(subjectOrgVO.getId());
                vo.setNumber(i+1);
                vo.setSubjectId(subjectOrgVO.getId());
                vo.setSubjectCode(subjectOrgVO.getSubjectCode());
                vo.setSubjectName(subjectOrgVO.getSubjectName());
                vo.setParentId(subjectOrgVO.getParentId());
                vo.setHappenDate(null);
                vo.setHappenMny(BigDecimal.ZERO);
                vo.setHappenMnySum(BigDecimal.ZERO);
            }
            allList.add(vo);
        }


        SubjectReportsVO tempVo = new SubjectReportsVO();
        tempVo.setId(999L);
        tempVo.setNumber(0);
        tempVo.setParentId(000L);
        allList.add(tempVo);
        List<SubjectReportsVO> listres = new ArrayList<>();
        SubjectReportsVO vo =   calculateValue2(allList);
        printGoal(vo,listres);
        listres = listres.stream().sorted(Comparator.comparing(SubjectReportsVO::getNumber)).collect(Collectors.toList());
        listres.remove(0);
        //计算差额，比率
        listres.forEach(e->{
            BigDecimal happenMny = e.getHappenMny()==null?BigDecimal.ZERO:e.getHappenMny();//本期实际成本金额
            BigDecimal ysHappenMny = e.getYsHappenMny()==null?BigDecimal.ZERO:e.getYsHappenMny();//本期预算金额
            BigDecimal cbHappenMny = e.getCbHappenMny()==null?BigDecimal.ZERO:e.getCbHappenMny();//本期目标成本金额
            BigDecimal srmbdifMny = ysHappenMny.subtract(cbHappenMny);//收入与目标差额
            BigDecimal srmbRate =  BigDecimal.ZERO;//收入与目标比率
            if(srmbdifMny.compareTo(BigDecimal.ZERO)!=0 && ysHappenMny.compareTo(BigDecimal.ZERO)!=0){
                srmbRate = srmbdifMny.multiply(new BigDecimal(100)).divide(ysHappenMny,2,BigDecimal.ROUND_HALF_DOWN);
            }
            e.setSrmbdifMny(srmbdifMny);
            e.setSrmbRate(srmbRate);

            BigDecimal mbsjdifMny = cbHappenMny.subtract(happenMny);//目标实际差额
            BigDecimal mbsjRate = BigDecimal.ZERO;//目标实际比率
            if(mbsjdifMny.compareTo(BigDecimal.ZERO)!=0 && cbHappenMny.compareTo(BigDecimal.ZERO)!=0){
                mbsjRate = mbsjdifMny.multiply(new BigDecimal(100)).divide(cbHappenMny,2,BigDecimal.ROUND_HALF_DOWN);
            }
            e.setMbsjdifMny(mbsjdifMny);
            e.setMbsjRate(mbsjRate);


            BigDecimal srsjdifMny = ysHappenMny.subtract(happenMny);;//收入与实际差额
            BigDecimal srsjRate = BigDecimal.ZERO;//收入与实际比率
            if(srsjdifMny.compareTo(BigDecimal.ZERO)!=0 && ysHappenMny.compareTo(BigDecimal.ZERO)!=0){
                srsjRate = srsjdifMny.multiply(new BigDecimal(100)).divide(ysHappenMny,2,BigDecimal.ROUND_HALF_DOWN);
            }
            e.setSrsjdifMny(srsjdifMny);
            e.setSrsjRate(srsjRate);
        });

        return BeanMapper.mapList(listres,ThreeReportVO.class);
    }
}
