/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procost.bean.BillSettingEntity;
import com.ejianc.business.procost.service.IBillSettingService;
import com.ejianc.business.procost.service.ISettingService;
import com.ejianc.business.procost.vo.BillSettingVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"billSetting"})
public class BillSettingController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillSettingService service;
    @Autowired
    private ISettingService settingService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BillSettingVO> saveOrUpdate(@RequestBody BillSettingVO saveorUpdateVO) {
        BillSettingEntity entity = (BillSettingEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BillSettingEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        BillSettingVO vo = (BillSettingVO)BeanMapper.map((Object)((Object)entity), BillSettingVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BillSettingVO> queryDetail(Long id) {
        BillSettingEntity entity = (BillSettingEntity)((Object)this.service.selectById(id));
        BillSettingVO vo = (BillSettingVO)BeanMapper.map((Object)((Object)entity), BillSettingVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryBillTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<BillSettingEntity>> queryBillTypes(Long projectId) {
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda2.in(BillSettingEntity::getType, new Object[]{2});
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.list((Wrapper)lambda2));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillSettingVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BillSettingVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BillSettingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

