package com.ejianc.business.procost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.bean.ReportEntity;
import com.ejianc.business.procost.service.IReportService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

@Service("report") 
public class ReportBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IReportService service;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ReportEntity e = service.selectById(billId);
		if(null == e.getContractFileId()) {
			//确保线上起草方式时，用户已编辑合同文件
			return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		if(1==state){
			ReportEntity e = service.selectById(billId);
			if(null == e.getContractFileId()) {
				//确保线上起草方式时，用户已编辑合同文件
				return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
			}
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ReportEntity e = service.selectById(billId);
		LambdaQueryWrapper<ReportEntity> lambda2 = Wrappers.<ReportEntity>lambdaQuery();
		lambda2.eq(ReportEntity::getTenantId,InvocationInfoProxy.getTenantid());
		lambda2.eq(ReportEntity::getProjectId,e.getProjectId());
		lambda2.ne(ReportEntity::getId,e.getId());
		lambda2.notIn(ReportEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
		List<ReportEntity> list2 = service.list(lambda2);
		if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list2)){
			return CommonResponse.error("该项目已存在未生效单据,请先处理未生效单据！");
		}

		Date reportDate = e.getReportDate();
		LambdaQueryWrapper<ReportEntity> lambda = Wrappers.<ReportEntity>lambdaQuery();
		lambda.eq(ReportEntity::getTenantId,InvocationInfoProxy.getTenantid());
		lambda.eq(ReportEntity::getProjectId,e.getProjectId());
		lambda.ne(ReportEntity::getId,e.getId());
		lambda.ge(ReportEntity::getReportDate,reportDate);
		List<ReportEntity> list = service.list(lambda);
		if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(list)){
			return CommonResponse.error("已存在下期成本分析报告！");
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
