package com.ejianc.business.procost.controller;

import java.io.Serializable;

import com.ejianc.business.procost.vo.UnitDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.procost.bean.UnitEntity;
import com.ejianc.business.procost.service.IUnitService;
import com.ejianc.business.procost.vo.UnitVO;

/**
 * 主材量价对比主表
 *
 * @author generator
 */
@Controller
@RequestMapping("unit")
@Api(value = "主材量价对比主表", tags = {"主材量价对比主表"})
public class UnitController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IUnitService service;

    @Autowired
    private SessionManager sessionManager;

    @Value("${procost.costSubjectId}")
    private String costSubjectId;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UnitVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody UnitVO saveOrUpdateVO) {
        UnitEntity entity = BeanMapper.map(saveOrUpdateVO, UnitEntity.class);
        service.saveOrUpdate(entity, false);
        UnitVO vo = BeanMapper.map(entity, UnitVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UnitVO> queryDetail(@RequestParam Long id) {
        UnitEntity entity = service.selectById(id);
        UnitVO vo = BeanMapper.map(entity, UnitVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UnitVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (UnitVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(UnitVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UnitVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<UnitEntity> page = service.queryPage(param, false);
        IPage<UnitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), UnitVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi
                .findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId)
                .collect(Collectors.toList())));
        List<UnitEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Unit-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refUnitData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UnitVO>> refUnitData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                     String condition,
                                                     String searchObject,
                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<UnitEntity> page = service.queryPage(param, false);
        IPage<UnitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), UnitVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryUnitList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<UnitVO>> queryUnitList(@RequestBody QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        return CommonResponse.success("查询列表数据成功！", service.queryUnitList(param));
    }

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveUnitBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<UnitVO>> saveUnitBatch(@RequestBody List<UnitVO> voList) {
        return CommonResponse.success("保存或修改单据成功！", service.saveUnitBatch(voList));
    }

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveUnitDetailBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<UnitDetailVO>> saveUnitDetailBatch(@RequestBody List<UnitDetailVO> voList) {
        return CommonResponse.success("保存或修改单据成功！", service.saveUnitDetailBatch(voList));
    }

    @ApiOperation("组装树形")
    @RequestMapping(value = "/packUnitTree", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<UnitVO>> packUnitTree(@RequestBody List<UnitVO> voList) {
        return CommonResponse.success("查询列表数据成功！", service.packUnitTree(voList));
    }

    @ApiOperation("查询子表")
    @RequestMapping(value = "/queryUnitDetailByPid", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<UnitDetailVO>> queryUnitDetailByPid(@RequestBody UnitDetailVO unitDetailVO) {
        return CommonResponse.success("查询列表数据成功！", service.queryUnitDetailByPid(unitDetailVO.getPid()));
    }

    @ApiOperation("查询人工费innerCode")
    @RequestMapping(value = "/querySubjectInnerCode", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> querySubjectInnerCode() {
        return CommonResponse.success("查询成功！", costSubjectId);
    }

    @ApiOperation("查询子表")
    @RequestMapping(value = "/clearUnitDetailByPid", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> clearUnitDetailByPid(@RequestBody UnitDetailVO unitDetailVO) {
        service.clearUnitDetailByPid(unitDetailVO.getPid());
        return CommonResponse.success("查询列表数据成功！");
    }

}
