/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.bean.SettingEntity;
import com.ejianc.business.procost.bean.SubjectEntity;
import com.ejianc.business.procost.service.ISettingService;
import com.ejianc.business.procost.service.ISubjectService;
import com.ejianc.business.procost.vo.SettingVO;
import com.ejianc.business.procost.vo.SubjectMaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/setting/"})
public class CostSettingApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISettingService settingService;
    @Autowired
    private ISubjectService subjectService;

    @RequestMapping(value={"checkSettingFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> checkSettingFlag(@RequestParam Long projectId) {
        List details = null;
        try {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            details = this.settingService.list((Wrapper)lambda);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            return CommonResponse.error((String)"\u83b7\u53d6\u4fe1\u606f\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            return CommonResponse.success((String)"\u8be5\u9879\u76ee\u5df2\u6210\u672c\u8bbe\u7f6e", (Object)true);
        }
        return CommonResponse.success((String)"\u8be5\u9879\u76ee\u672a\u6210\u672c\u8bbe\u7f6e", (Object)false);
    }

    @RequestMapping(value={"/querySubjectsByProj"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SubjectMaterialVO>> querySubjectsByProj(@RequestParam Long projectId) {
        List listRes = new ArrayList();
        try {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            List details = this.settingService.list((Wrapper)lambda);
            if (CollectionUtils.isNotEmpty((Collection)details)) {
                SettingEntity settingEntity = (SettingEntity)((Object)details.get(0));
                LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
                lambda2.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                lambda2.eq(SubjectEntity::getSettingId, (Object)settingEntity.getId());
                lambda2.eq(SubjectEntity::getStatus, (Object)"0");
                List list = this.subjectService.list((Wrapper)lambda2);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    listRes = BeanMapper.mapList((Iterable)list, SubjectMaterialVO.class);
                    listRes.forEach(e -> {
                        e.setMaterialCost(settingEntity.getMaterialCost());
                        e.setTaxFlag(settingEntity.getTaxFlag());
                    });
                }
            }
        }
        catch (Exception e2) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e2.getMessage());
            return CommonResponse.error((String)"\u83b7\u53d6\u4fe1\u606f\u5931\u8d25!!");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", listRes);
    }

    @GetMapping(value={"getSettingInfo"})
    CommonResponse<SettingVO> getSettingInfo(@RequestParam Long orgId) {
        List list = this.settingService.list((Wrapper)new QueryWrapper().eq((Object)"org_id", (Object)orgId));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.map(list.get(0), SettingVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01");
    }
}

