package com.ejianc.business.procost.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.bean.CostDetailEntity;
import com.ejianc.business.procost.bean.SettingEntity;
import com.ejianc.business.procost.bean.SubjectEntity;
import com.ejianc.business.procost.service.ICostDetailService;
import com.ejianc.business.procost.service.ISettingService;
import com.ejianc.business.procost.service.IShareDetailService;
import com.ejianc.business.procost.service.ISubjectService;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/procost/")
public class CostDetailApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private ICostDetailService costDetailService;

	@RequestMapping(value = "saveCostDetail", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<CostDetailVO> saveCostDetail(
			@RequestBody List<CostDetailVO> list) {
		try {
			if(CollectionUtils.isNotEmpty(list)){
//				LambdaQueryWrapper<SettingEntity> lambda = Wrappers.<SettingEntity>lambdaQuery();
////				lambda.eq(SettingEntity::getProjectId,list.get(0).getProjectId());
////				lambda.in(SettingEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
//				List<SettingEntity> settingEntityList  = settingService.list(lambda);
//				if(CollectionUtils.isNotEmpty(settingEntityList)){
//					LambdaQueryWrapper<SubjectEntity> lambda2 = Wrappers.<SubjectEntity>lambdaQuery();
//					lambda2.eq(SubjectEntity::getSettingId,settingEntityList.get(0).getId());
//					List<SubjectEntity> subjectEntityList  = subjectService.list(lambda2);
//					Map<Long, List<SubjectEntity>> map = subjectEntityList.stream().collect(Collectors.groupingBy(SubjectEntity::getId));
//					for(CostDetailVO e:list){
//						if(!map.containsKey(e.getSubjectId())){
//							return CommonResponse.error("插入失败,明细中科目有不存在成本设置中的数据!");
//						}
//					}
//				}else{
//					return CommonResponse.error("插入失败,未找到该项目成本设置信息");
//				}
				List<CostDetailEntity> listres = BeanMapper.mapList(list, CostDetailEntity.class);
				for (CostDetailEntity costDetailEntity :listres	) {
					costDetailEntity.setHappenMny(costDetailEntity.getHappenTaxMny());//无税金额 = 含税
				}
				costDetailService.deleteCostDetail(listres.get(0).getSourceId());
				costDetailService.saveBatch(listres);
			}
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			return CommonResponse.error("插入失败");
		}
		return CommonResponse.success("插入成功");
	}

	@RequestMapping(value = "deleteCostDetail", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<CostDetailVO> deleteCostDetail(@RequestParam Long id) {
		try {
			costDetailService.deleteCostDetail(id);
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			return CommonResponse.error("删除失败");
		}
		return CommonResponse.success("删除成功");
	}

	@RequestMapping(value = "queryCostMnyByProjectId", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> queryCostMnyByProjectId(@RequestParam Long projectId) {
		LambdaQueryWrapper<CostDetailEntity> lambda = Wrappers.<CostDetailEntity>lambdaQuery();
		lambda.eq(CostDetailEntity::getProjectId,projectId);
		lambda.eq(CostDetailEntity::getProportionFlag,1);
		List<CostDetailEntity> list  = costDetailService.list(lambda);
		BigDecimal costTaxMny = BigDecimal.ZERO;
		BigDecimal costMny = BigDecimal.ZERO;
		if(CollectionUtils.isNotEmpty(list)){
			costTaxMny = list.stream().filter(item -> null != item.getHappenTaxMny()).map(CostDetailEntity::getHappenTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
			costMny = list.stream().filter(item -> null != item.getHappenMny()).map(CostDetailEntity::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
		}
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("costTaxMny",costTaxMny);
		jsonObject.put("costMny",costMny);
		logger.info("查询结果：{}", jsonObject);
		return CommonResponse.success("查询成功", jsonObject);
	}

}
