package com.ejianc.business.procost.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procost.bean.SettingEntity;
import com.ejianc.business.procost.bean.ShareDetailEntity;
import com.ejianc.business.procost.bean.ShareEntity;
import com.ejianc.business.procost.service.ISettingService;
import com.ejianc.business.procost.service.IShareDetailService;
import com.ejianc.business.procost.service.IShareService;
import com.ejianc.business.procost.utils.TreeNodeBUtil;
import com.ejianc.business.procost.vo.*;
//import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 成本分摊
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("share")
public class ShareController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectPoolApi projectApi;

    @Autowired
    private IShareService service;

    @Autowired
    private ISettingService settingService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ShareVO> saveOrUpdate(@RequestBody ShareVO saveorUpdateVO) {
    	return service.saveOrUpdateShare(saveorUpdateVO);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ShareVO> queryDetail(Long id) {
    	ShareEntity entity = service.selectById(id);
    	BigDecimal sumCostMny = entity.getSumCostMny()==null?BigDecimal.ZERO:entity.getSumCostMny();
        BigDecimal costMny = entity.getCostMny()==null?BigDecimal.ZERO:entity.getCostMny();
        ShareVO vo = BeanMapper.map(entity, ShareVO.class);
        vo.setSumCostMnys(sumCostMny.add(costMny));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 新增查询
     * @param orgId
     */
    @RequestMapping(value = "/queryDetailByOrg", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ShareVO> queryCopyDetail(HttpServletRequest request,Long projectId,Long orgId) {
//        LambdaQueryWrapper<SettingEntity> lambda = Wrappers.<SettingEntity>lambdaQuery();
//        lambda.eq(SettingEntity::getTenantId,InvocationInfoProxy.getTenantid());
//        lambda.eq(SettingEntity::getId,id);
//        SettingEntity settingEntity  = settingService.getOne(lambda);

        SettingVO settingvo = settingService.queryByOrgId(orgId);
        if(null==settingvo){
            return CommonResponse.error("未查询到成本期间设置！");
        }
        LambdaQueryWrapper<ShareEntity> lambda2 = Wrappers.<ShareEntity>lambdaQuery();
        lambda2.eq(ShareEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda2.eq(ShareEntity::getOrgId,orgId);
        lambda2.orderByDesc(ShareEntity::getPeriod);
        List<ShareEntity> list = service.list(lambda2);

        ShareVO entity = new ShareVO();
        entity.setProjectId(projectId);
//        entity.setProjectName(settingEntity.getProjectName());
//        entity.setOrgId(settingEntity.getOrgId());
//        entity.setOrgName(settingEntity.getOrgName());
        entity.setMaterialCost(settingvo.getMaterialCost());
        entity.setTaxFlag(settingvo.getTaxFlag());
        if(CollectionUtils.isNotEmpty(list)){
            entity.setLastPeriod(list.get(0).getPeriod());
            entity.setLastCostMny(list.get(0).getCostMny());
            BigDecimal sum = list.stream().map(ShareEntity::getCostMny).reduce(BigDecimal.ZERO,BigDecimal::add);
            entity.setSumCostMny(sum);
        }else{
            entity.setLastCostMny(BigDecimal.ZERO);
            entity.setSumCostMny(BigDecimal.ZERO);
        }
        //0-固定日期，1-自然月
        String periodRule = settingvo.getPeriodRule();
        Calendar calendar = Calendar.getInstance();
        if("0".equals(periodRule)){
            //固定日期
            int endDay = settingvo.getEndDay();
            int day = calendar.get(Calendar.DAY_OF_MONTH);
            if(day>endDay){
                calendar.add(Calendar.MONTH, 1);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            String dateNowStr = sdf.format(calendar.getTime());
            if(StringUtils.isNotEmpty(entity.getLastPeriod())&&dateNowStr.compareTo(entity.getLastPeriod())<1){
                Calendar calendar2 = Calendar.getInstance();
                try {
                    calendar2.setTime(sdf.parse(entity.getLastPeriod()));
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                calendar2.add(Calendar.MONTH, 1);
                String dateNowStr2 = sdf.format(calendar2.getTime());
                entity.setPeriod(dateNowStr2);
                if(endDay<10){
                    entity.setEndDay(dateNowStr2+"-0"+endDay);
                }else{
                    entity.setEndDay(dateNowStr2+"-"+endDay);
                }
            }else{
                entity.setPeriod(dateNowStr);
                if(endDay<10){
                    entity.setEndDay(dateNowStr+"-0"+endDay);
                }else{
                    entity.setEndDay(dateNowStr+"-"+endDay);
                }
            }
        }else{
            //自然月
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            String dateNowStr = sdf.format(calendar.getTime());
            if(StringUtils.isNotEmpty(entity.getLastPeriod())&&dateNowStr.compareTo(entity.getLastPeriod())<1){
                Calendar calendar2 = Calendar.getInstance();
                try {
                    calendar2.setTime(sdf.parse(entity.getLastPeriod()));
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                calendar2.add(Calendar.MONTH, 1);
                String dateNowStr2 = sdf.format(calendar2.getTime());
                entity.setPeriod(dateNowStr2);
                entity.setEndDay(getEndDay(calendar2));
            }else{
                entity.setPeriod(dateNowStr);
                entity.setEndDay(getEndDay(calendar));
            }
        }
        List<ShareDetailVO> listDetail = service.getDetail(entity.getProjectId(),entity.getEndDay(),entity.getTaxFlag(),null,entity.getMaterialCost(),0,request);
        BigDecimal costMny = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(listDetail)){
            entity.setShareDetail(listDetail);
            costMny = listDetail.stream().map(ShareDetailVO::getHappenMny).reduce(BigDecimal.ZERO,BigDecimal::add);
        }
        entity.setCostMny(costMny);
        entity.setSumCostMnys(entity.getSumCostMny()==null?BigDecimal.ZERO:entity.getSumCostMny());
        return CommonResponse.success("查询详情数据成功！",entity);
    }

    /**
     * @Description queryDetail 新增查询
     */
    @RequestMapping(value = "/queryShareDetails", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ShareDetailVO>> queryCopyDetail(HttpServletRequest request,Long projectId,String endDay,String taxFlag,String billType,String materialCost) {
        return CommonResponse.success("查询详情数据成功！",service.getDetail(projectId,endDay,taxFlag,billType,materialCost,0,request));
    }

    /**
     * @Description queryDetail 获取明细行某数据对应的关联状态
     */
    @RequestMapping(value = "/querySubjectFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubjectFlagVO> querySubjectFlag(Long sourceId,String billType) {
        return CommonResponse.success("查询详情数据成功！",service.getSubkectFlag(sourceId,billType));
    }

    /**
     * @Description queryYears 查询年列表
     * @param id 项目主键
     */
    @RequestMapping(value = "/queryYears", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<String>> queryYears(Long id) {
        List<Long> listids = new ArrayList<>();
        listids.add(id);
        CommonResponse<JSONArray> res = projectApi.queryProjectPoolById(id);
        if(!res.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        ProjectPoolSetVO projectPoolSetVO = JSON.parseObject(JSON.toJSONString(res.getData().get(0)), ProjectPoolSetVO.class);;
//        Date signDate = res.getData().get(0).getSignDate();
        Date signDate = projectPoolSetVO.getProjectDate();
        if(null==signDate){
            signDate = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(signDate);
        calendar.add(Calendar.YEAR, -1);//签订时间减去一年，即签订一年前的时间
        calendar.getTime();//获取一年前的时间，或者一个月前的时间
        Date beforeDate = calendar.getTime();


        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(new Date());
        calendar2.add(Calendar.YEAR, 1);//当前时间加一年，即一年后的时间
        Date endDate = calendar2.getTime();


        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        List<String> list = new ArrayList<>();
        do{
            list.add(sdf.format(endDate));
            Calendar calendar3 = Calendar.getInstance();
            calendar3.setTime(endDate);
            calendar3.add(Calendar.YEAR, -1);
            endDate = calendar3.getTime() ;
        }while (beforeDate.before(endDate));{
        }
        list.add(sdf.format(beforeDate));
        return CommonResponse.success("查询详情数据成功！",list);
    }

    /**
     * @Description queryYears 查询年列表
     * @param id 项目主键
     */
    @RequestMapping(value = "/queryMonths", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MonthVO>> queryMonths(Long id,String year) {
        String MaxMonth = "";
        Boolean flag = true;
        LambdaQueryWrapper<ShareEntity> lambda = Wrappers.<ShareEntity>lambdaQuery();
        lambda.eq(ShareEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(ShareEntity::getProjectId,id);
        lambda.in(ShareEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.orderByDesc(ShareEntity::getPeriod);
        List<ShareEntity> listShares  = service.list(lambda);
        if(CollectionUtils.isNotEmpty(listShares)){
            MaxMonth = listShares.get(0).getPeriod();
        }else{
            flag = false;
        }

        List<MonthVO> list = service.getMonths(id,year);
        Map<String,MonthVO> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(e->{
                map.put(e.getMonth(),e);
            });
        }

        List<MonthVO> listMonth = new ArrayList<>();
        for(int i=1;i<13;i++){
          if(i<10){
              MonthVO vo = new MonthVO();
              vo.setMonth(year+"-0"+i);
              if(flag){
                  if(vo.getMonth().compareTo(MaxMonth)>0){
                      vo.setFlag(true);
                  }else{
                      vo.setFlag(false);
                  }
              }else{
                  vo.setFlag(true);
              }
              if(map.containsKey(vo.getMonth())){
                  vo.setCostMny(map.get(vo.getMonth()).getCostMny());
                  vo.setLatCostMny(map.get(vo.getMonth()).getLatCostMny());
                  vo.setCostFlag(true);
              }else{
                  vo.setCostMny(BigDecimal.ZERO);
                  vo.setLatCostMny(BigDecimal.ZERO);
                  vo.setCostFlag(false);
              }
              listMonth.add(vo);
          }else{
              MonthVO vo = new MonthVO();
              vo.setMonth(year+"-"+i);
              if(flag){
                  if(vo.getMonth().compareTo(MaxMonth)>0){
                      vo.setFlag(true);
                  }else{
                      vo.setFlag(false);
                  }
              }else{
                  vo.setFlag(true);
              }
              if(flag&&map.containsKey(vo.getMonth())){
                  vo.setCostMny(map.get(vo.getMonth()).getCostMny());
                  vo.setLatCostMny(map.get(vo.getMonth()).getLatCostMny());
                  vo.setCostFlag(true);
              }else{
                  vo.setCostMny(BigDecimal.ZERO);
                  vo.setLatCostMny(BigDecimal.ZERO);
                  vo.setCostFlag(false);
              }
              listMonth.add(vo);
          }
        }


//        LambdaQueryWrapper<SettingEntity> lambda2 = Wrappers.<SettingEntity>lambdaQuery();
//        lambda2.eq(SettingEntity::getTenantId,InvocationInfoProxy.getTenantid());
//        lambda2.eq(SettingEntity::getProjectId,id);
//        lambda2.in(SettingEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
//        SettingEntity settingEntity  = settingService.getOne(lambda2);
        SettingVO settingvo = settingService.queryByOrgId(InvocationInfoProxy.getOrgId());
        if(null==settingvo){
            return CommonResponse.error("未查询到成本期间设置！");
        }
        //todo  获取规则
        String periodRule = settingvo.getPeriodRule();
        listMonth.forEach(e->{
            if("1".equals(periodRule)){
                Calendar calendar = Calendar.getInstance();
                calendar.set(Calendar.YEAR, Integer.parseInt(e.getMonth().substring(0,4)));
                calendar.set(Calendar.MONTH, Integer.parseInt(e.getMonth().substring(5,7))-1);
                e.setEndDay(getEndDay(calendar));
            }else{
                int endDay = settingvo.getEndDay();
                if(endDay<10){
                    e.setEndDay(e.getMonth()+"-0"+endDay);
                }else{
                    e.setEndDay(e.getMonth()+"-"+endDay);
                }
            }
        });

        return CommonResponse.success("查询详情数据成功！",listMonth);
    }

    /**
     * @Description queryYears 查询本期汇总
     * @param
     */
    @RequestMapping(value = "/querySubjectReports", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SubjectReportVO>> querySubjectReports(Long projectId, String period, int type,Long wbsId) {
        List<SubjectReportVO> list = service.getSubjectReport(projectId,period,type,wbsId);
        return CommonResponse.success("查询详情数据成功！",TreeNodeBUtil.buildTree(list));
    }


    /**
     * @Description  根据项目获取科目树汇总成本
     * @param
     */
    @RequestMapping(value = "/getCostAllDetails", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SubjectReportVO>> getCostAllDetails(Long projectId, String beginPeriod, String endPeriod) {
        List<SubjectReportVO> list = service.getCostAllDetails(projectId,beginPeriod,endPeriod);
        return CommonResponse.success("查询详情数据成功！",TreeNodeBUtil.buildTree(list));
    }

    /**
     * @Description  根据项目获,科目  取核算对象汇总成本
     * @param
     */
    @RequestMapping(value = "/getDetailsBySubjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SubjectReportVO>> getDetailsBySubjectId(Long projectId, String beginPeriod, String endPeriod,Long subjectId) {
        List<SubjectReportVO> list = service.getDetailsBySubjectId(projectId,beginPeriod,endPeriod,subjectId);
        return CommonResponse.success("查询详情数据成功！",TreeNodeBUtil.buildTree(list));
    }

    /**
     * @Description  根据项目获,科目  核算对象  取各个单据汇总后明细
     * @param
     */
    @RequestMapping(value = "/getDetailsByWbsId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SubjectReportsVO>> getDetailsByWbsId(Long projectId, String beginPeriod, String endPeriod,Long subjectId,Long wbsId) {
        List<SubjectReportsVO> list = service.getDetailsByWbsId(projectId,beginPeriod,endPeriod,subjectId,wbsId);
        return CommonResponse.success("查询详情数据成功！",list);
    }


    /**
     * @Description  三算对比台账
     * @param
     */
    @RequestMapping(value = "/getThreeReports", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ThreeReportVO>> getThreeReports(Long projectId, String beginPeriod,String endPeriod) {
        List<ThreeReportVO> list = service.getThreeReports(projectId,beginPeriod,endPeriod);
        return CommonResponse.success("查询详情数据成功！",TreeNodeBUtil.buildTree(list));
    }

    /**
     * @Description  量价对比台账
     * @param
     */
    @RequestMapping(value = "/getNumpReports", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ThreeReportVO>> getNumpReports(Long projectId, String beginPeriod,String endPeriod) {
        List<ThreeReportVO> list = service.getNumpReports(projectId,beginPeriod,endPeriod);
        return CommonResponse.success("查询详情数据成功！",TreeNodeBUtil.buildTree(list));
    }

    /**
     * @Description  月度成本统计
     * @param
     */
    @RequestMapping(value = "/querySubjectReportAlls", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TemplateDatas>> querySubjectReportAlls(@RequestBody ShareVO vo) {
        List<TemplateDatas> list = service.getSubjectReportAlls(vo.getProjectId(),vo.getPeriods(),vo.getType());
        return CommonResponse.success("查询详情数据成功！",TreeNodeBUtil.buildTree(list));
    }

    /**
     * @Description queryYears 查询年列表
     * @param
     */
    @RequestMapping(value = "/queryProReports", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubjectReportVO> queryProReports(HttpServletRequest request,Long projectId) {
        SubjectReportVO res = service.queryProReports(request,projectId);
        return CommonResponse.success("查询详情数据成功！",res);
    }



    public String getEndDay(Calendar calendar){
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
        return sdf2.format(calendar.getTime());
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ShareVO> vos) {
        service.removeByIds(vos.stream().map(ShareVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ShareVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("period");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<ShareEntity> page = service.queryPage(param,false);
        IPage<ShareVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ShareVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 设置参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "periodRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ShareVO>> orderDetailRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("period");

        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));

        if(org.apache.commons.lang3.StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("projectId")) {
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, conditionMap.get("projectId")));
            }
        }
        queryParam.getOrderMap().put("period","asc");
        IPage<ShareEntity> page = service.queryPage(queryParam,false);

        IPage<ShareVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ShareVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }
}
