package com.ejianc.business.procost.controller.api;

import com.ejianc.business.procost.bean.ShareDetailEntity;
import com.ejianc.business.procost.bean.ShareEntity;
import com.ejianc.business.procost.service.IShareDetailService;
import com.ejianc.business.procost.service.IShareService;
import com.ejianc.business.procost.vo.ShareVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;

/**
 * @author CJ
 * @Description:
 * @date 2023/6/6 16:39
 */
@RestController
@RequestMapping(value = "/api/procostShare/")
public class CostShareApi {

    @Autowired
    private IShareService service;

    @Autowired
    private IShareDetailService detailService;

    private final String DETAIL_PC = "ejc-share-frontend/#/costShare/card?id=";

    @Value("${common.env.base-host}")
    private String BaseHost;

    @GetMapping(value = "/api/procostShare/getByBillId")
    public CommonResponse<ShareVO> getByBillId(@RequestParam Long billId) {
        ShareVO vo = null;
        ShareDetailEntity detail = detailService.getBySourceId(billId);

        if(null != detail) {
            ShareEntity entity = service.selectById(detail.getShareId());
            BigDecimal sumCostMny = entity.getSumCostMny()==null?BigDecimal.ZERO:entity.getSumCostMny();
            BigDecimal costMny = entity.getCostMny()==null?BigDecimal.ZERO:entity.getCostMny();
            vo = BeanMapper.map(entity, ShareVO.class);
            vo.setSumCostMnys(sumCostMny.add(costMny));
            vo.setPcDetailUrl(BaseHost + DETAIL_PC + entity.getId().toString());
        }

        return CommonResponse.success(vo);
    }

}
