package com.ejianc.business.procost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.procost.bean.CostDetailEntity;
import com.ejianc.business.procost.bean.HandshareDetailEntity;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.service.ICostDetailService;
import com.ejianc.business.procost.vo.HandshareDetailVO;
import com.ejianc.business.procost.vo.HandshareVO;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.procost.mapper.HandshareMapper;
import com.ejianc.business.procost.bean.HandshareEntity;
import com.ejianc.business.procost.service.IHandshareService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 成本单据
 *
 * @author generator
 */
@Service("handshareService")
public class HandshareServiceImpl extends BaseServiceImpl<HandshareMapper, HandshareEntity> implements IHandshareService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICostDetailService costDetailService;

    private static final String BillType = "EJCBT202205000032";//此处需要根据实际修改

    private static final String linkUrl = "/ejc-procost-frontend/#/handshare/card?id=";//此处需要根据实际修改

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Override
    public ExecutionVO targetCost(HandshareVO vo) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(vo.getId());
        totalVO.setTenantId(vo.getTenantId());
        totalVO.setBillCode(vo.getBillCode());
        totalVO.setBillType(BillType);
        totalVO.setBussinessType(BussinessTypeEnum.财务取数成本.getCode());
        totalVO.setBillCategory(BillCategoryEnum.其他.getCode());
        totalVO.setProjectId(vo.getProjectId());
        totalVO.setOrgId(vo.getOrgId());
        totalVO.setMoney(vo.getCostMny());
        totalVO.setTaxMoney(vo.getCostMny());
        totalVO.setLinkUrl(BaseHost + linkUrl + vo.getId());
        for (HandshareDetailVO planDetailVO : vo.getHandshareDetailList()) {
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(planDetailVO.getId());
            detailExecutionVO.setSourceBillId(vo.getId());
            detailExecutionVO.setDocType(DocTypeEnum.成本科目.getCode());
            detailExecutionVO.setDocId(planDetailVO.getSubjectId());
            detailExecutionVO.setName(planDetailVO.getSubjectName());
            detailExecutionVO.setCode(planDetailVO.getSubjectCode());
            detailExecutionVO.setCategoryFlag(false);
            detailExecutionVO.setCategoryId(planDetailVO.getSubjectId());
            detailExecutionVO.setMoney(planDetailVO.getHappenMny());
            detailExecutionVO.setTaxMoney(planDetailVO.getHappenMny());
            detailList.add(detailExecutionVO);
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }
    @Override
    public void saveCost(HandshareEntity handshareEntity,Integer effectiveStatus) {
        logger.info("推送数据开始--------");
        //推送成本
        //明细
        List<CostDetailEntity> costDetailVOList = new ArrayList<>();
        List<HandshareDetailEntity> handshareDetailList = handshareEntity.getHandshareDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(handshareDetailList)) {
            logger.info("开始处理子表--------"+handshareDetailList.size());
            for (HandshareDetailEntity handshareDetailEntity : handshareDetailList) {
                CostDetailEntity costDetailVO = new CostDetailEntity();
                costDetailVO.setSubjectId(handshareDetailEntity.getSubjectId());
                costDetailVO.setSubjectCode(handshareDetailEntity.getSubjectCode());
                costDetailVO.setSubjectName(handshareDetailEntity.getSubjectName());
                costDetailVO.setWbsId(handshareDetailEntity.getWbsId());
                costDetailVO.setWbsCode(handshareDetailEntity.getWbsCode());
                costDetailVO.setWbsName(handshareDetailEntity.getWbsName());
                costDetailVO.setSourceId(handshareEntity.getId());
                costDetailVO.setSourceDetailId(handshareDetailEntity.getId());
                costDetailVO.setHappenTaxMny(handshareDetailEntity.getHappenMny()==null?BigDecimal.ZERO:handshareDetailEntity.getHappenMny());
                costDetailVO.setHappenMny(handshareDetailEntity.getHappenMny()==null?BigDecimal.ZERO:handshareDetailEntity.getHappenMny());
                costDetailVO.setHappenDate(new Date());
                if(1==effectiveStatus){
                    costDetailVO.setPeriod(handshareEntity.getPeriod());
                    costDetailVO.setProportionFlag("1");
                }
                costDetailVO.setCreateUserName(handshareEntity.getCreateUserName());
                costDetailVO.setSourceType("COST_HANDSHARE");
                costDetailVO.setSourceTabType("COST_HANDSHARE_DETAIL");
                costDetailVO.setProjectId(handshareEntity.getProjectId());
                costDetailVO.setSourceBillCode(handshareEntity.getBillCode()); //填充自己的单据编号
                costDetailVO.setSourceBillName(SourceTypeEnum.成本单据.getTypeName());//填充枚举里  自己的单据名称
                costDetailVO.setSourceBillUrl("/ejc-procost-frontend/#/handshare/card?id="+handshareEntity.getId());//需要跳转路径与参数组成的全路径
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }

        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            costDetailService.deleteCostDetail(costDetailVOList.get(0).getSourceId());
            costDetailService.saveBatch(costDetailVOList);
        }

    }
}
