/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.procost.bean.CostDetailEntity;
import com.ejianc.business.procost.bean.HandshareDetailEntity;
import com.ejianc.business.procost.bean.HandshareEntity;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.mapper.HandshareMapper;
import com.ejianc.business.procost.service.ICostDetailService;
import com.ejianc.business.procost.service.IHandshareService;
import com.ejianc.business.procost.vo.HandshareDetailVO;
import com.ejianc.business.procost.vo.HandshareVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="handshareService")
public class HandshareServiceImpl
extends BaseServiceImpl<HandshareMapper, HandshareEntity>
implements IHandshareService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailService costDetailService;
    private static final String BillType = "EJCBT202205000032";
    private static final String linkUrl = "/ejc-procost-frontend/#/handshare/card?id=";
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${refer.base-host:null}")
    private String Refer_BaseHost;
    @Autowired
    private IExecutionApi executionApi;

    @Override
    public ExecutionVO targetCost(HandshareVO vo) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(vo.getId());
        totalVO.setTenantId(vo.getTenantId());
        totalVO.setBillCode(vo.getBillCode());
        totalVO.setBillType(BillType);
        totalVO.setBussinessType(BussinessTypeEnum.\u8d22\u52a1\u53d6\u6570\u6210\u672c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5176\u4ed6.getCode());
        totalVO.setProjectId(vo.getProjectId());
        totalVO.setOrgId(vo.getOrgId());
        totalVO.setMoney(vo.getCostMny());
        totalVO.setTaxMoney(vo.getCostMny());
        if (StringUtils.isNotBlank((CharSequence)this.Refer_BaseHost) && !"null".equals(this.Refer_BaseHost)) {
            this.BaseHost = this.Refer_BaseHost;
        }
        totalVO.setLinkUrl(this.BaseHost + linkUrl + vo.getId());
        for (HandshareDetailVO planDetailVO : vo.getHandshareDetailList()) {
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(planDetailVO.getId());
            detailExecutionVO.setSourceBillId(vo.getId());
            detailExecutionVO.setDocType(DocTypeEnum.\u6210\u672c\u79d1\u76ee.getCode());
            detailExecutionVO.setDocId(planDetailVO.getSubjectId());
            detailExecutionVO.setName(planDetailVO.getSubjectName());
            detailExecutionVO.setCode(planDetailVO.getSubjectCode());
            detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
            detailExecutionVO.setCategoryId(planDetailVO.getSubjectId());
            detailExecutionVO.setMoney(planDetailVO.getHappenMny());
            detailExecutionVO.setTaxMoney(planDetailVO.getHappenMny());
            detailList.add(detailExecutionVO);
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public void saveCost(HandshareEntity handshareEntity, Integer effectiveStatus) {
        this.logger.info("\u63a8\u9001\u6570\u636e\u5f00\u59cb--------");
        ArrayList<CostDetailEntity> costDetailVOList = new ArrayList<CostDetailEntity>();
        List<HandshareDetailEntity> handshareDetailList = handshareEntity.getHandshareDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(handshareDetailList)) {
            this.logger.info("\u5f00\u59cb\u5904\u7406\u5b50\u8868--------" + handshareDetailList.size());
            for (HandshareDetailEntity handshareDetailEntity : handshareDetailList) {
                CostDetailEntity costDetailVO = new CostDetailEntity();
                costDetailVO.setSubjectId(handshareDetailEntity.getSubjectId());
                costDetailVO.setSubjectCode(handshareDetailEntity.getSubjectCode());
                costDetailVO.setSubjectName(handshareDetailEntity.getSubjectName());
                costDetailVO.setWbsId(handshareDetailEntity.getWbsId());
                costDetailVO.setWbsCode(handshareDetailEntity.getWbsCode());
                costDetailVO.setWbsName(handshareDetailEntity.getWbsName());
                costDetailVO.setSourceId(handshareEntity.getId());
                costDetailVO.setSourceDetailId(handshareDetailEntity.getId());
                costDetailVO.setHappenTaxMny(handshareDetailEntity.getHappenMny() == null ? BigDecimal.ZERO : handshareDetailEntity.getHappenMny());
                costDetailVO.setHappenMny(handshareDetailEntity.getHappenMny() == null ? BigDecimal.ZERO : handshareDetailEntity.getHappenMny());
                costDetailVO.setHappenDate(new Date());
                if (1 == effectiveStatus) {
                    costDetailVO.setPeriod(handshareEntity.getPeriod());
                    costDetailVO.setProportionFlag("1");
                }
                costDetailVO.setCreateUserName(handshareEntity.getCreateUserName());
                costDetailVO.setSourceType("COST_HANDSHARE");
                costDetailVO.setSourceTabType("COST_HANDSHARE_DETAIL");
                costDetailVO.setProjectId(handshareEntity.getProjectId());
                costDetailVO.setSourceBillCode(handshareEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u6210\u672c\u5355\u636e.getTypeName());
                costDetailVO.setSourceBillUrl(linkUrl + handshareEntity.getId());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            this.costDetailService.deleteCostDetail(((CostDetailEntity)((Object)costDetailVOList.get(0))).getSourceId());
            this.costDetailService.saveBatch(costDetailVOList);
        }
    }

    @Override
    public ParamsCheckVO checkParams(HandshareVO otStoreVO) {
        CommonResponse costResponse;
        ParamsCheckVO costRes;
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        CostCtrlVO costCtrlVO = this.sjCost(otStoreVO);
        if (null != costCtrlVO && null != (costRes = (ParamsCheckVO)(costResponse = this.executionApi.ctrlCost(costCtrlVO)).getData())) {
            paramsCheckVOS.add(costRes);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public CostCtrlVO sjCost(HandshareVO vo) {
        List detailList = vo.getHandshareDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
            for (HandshareDetailVO handshareDetailVO : detailList) {
                CostCtrlDetailVO costCtrlDetailVO;
                BigDecimal taxMoney;
                if (null == handshareDetailVO.getSubjectId()) continue;
                BigDecimal money = handshareDetailVO.getHappenMny() == null ? BigDecimal.ZERO : handshareDetailVO.getHappenMny();
                BigDecimal bigDecimal = taxMoney = handshareDetailVO.getHappenMny() == null ? BigDecimal.ZERO : handshareDetailVO.getHappenMny();
                if (map.containsKey(handshareDetailVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(handshareDetailVO.getSubjectId());
                    BigDecimal mny = costCtrlDetailVO.getMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getMny();
                    BigDecimal taxMny = costCtrlDetailVO.getTaxMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getTaxMny();
                    costCtrlDetailVO.setMny(mny.add(money));
                    costCtrlDetailVO.setTaxMny(taxMny.add(taxMoney));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(handshareDetailVO.getSubjectId());
                costCtrlDetailVO.setMny(money);
                costCtrlDetailVO.setTaxMny(taxMoney);
                map.put(handshareDetailVO.getSubjectId(), costCtrlDetailVO);
            }
            if (null != map) {
                CostCtrlVO ctrlVO = new CostCtrlVO();
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList(map.values()));
                return ctrlVO;
            }
            return null;
        }
        return null;
    }
}

