package com.ejianc.business.procost.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.bean.CostDetailEntity;
import com.ejianc.business.procost.bean.SettingEntity;
import com.ejianc.business.procost.bean.SubjectEntity;
import com.ejianc.business.procost.service.ICostDetailService;
import com.ejianc.business.procost.service.ISettingService;
import com.ejianc.business.procost.service.IShareDetailService;
import com.ejianc.business.procost.service.ISubjectService;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/procost/")
public class CostDetailApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private ICostDetailService costDetailService;

	@RequestMapping(value = "saveCostDetail", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<CostDetailVO> saveCostDetail(
			@RequestBody List<CostDetailVO> list) {
		try {
			if(CollectionUtils.isNotEmpty(list)){
				List<CostDetailEntity> listres = BeanMapper.mapList(list, CostDetailEntity.class);
				costDetailService.deleteCostDetail(listres.get(0).getSourceId());
				costDetailService.saveBatch(listres);
			}
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			return CommonResponse.error("插入失败");
		}
		return CommonResponse.success("插入成功");
	}

	@RequestMapping(value = "deleteCostDetail", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<CostDetailVO> deleteCostDetail(@RequestParam Long id) {
		try {
			costDetailService.deleteCostDetail(id);
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			return CommonResponse.error("删除失败");
		}
		return CommonResponse.success("删除成功");
	}

	@RequestMapping(value = "updateCostDetail", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<CostDetailVO> updateCostDetail(@RequestParam Long sourceId,Integer effectiveStatus) {
		try {
			//更新生效状态
			LambdaUpdateWrapper<CostDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.eq(CostDetailEntity::getSourceId, sourceId);
			updateWrapper.set(CostDetailEntity::getEffectiveStatus, effectiveStatus);//生效状态 0-未生效，1-生效
			costDetailService.update(updateWrapper);
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			return CommonResponse.error("更新生效状态失败");
		}
		return CommonResponse.success("更新生效状态成功");
	}

	@RequestMapping(value = "queryCostMnyByProjectId", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> queryCostMnyByProjectId(@RequestParam Long projectId) {
		LambdaQueryWrapper<CostDetailEntity> lambda = Wrappers.<CostDetailEntity>lambdaQuery();
		lambda.eq(CostDetailEntity::getProjectId,projectId);
		lambda.eq(CostDetailEntity::getProportionFlag,1);
		List<CostDetailEntity> list  = costDetailService.list(lambda);
		BigDecimal costTaxMny = BigDecimal.ZERO;
		BigDecimal costMny = BigDecimal.ZERO;
		if(CollectionUtils.isNotEmpty(list)){
			costTaxMny = list.stream().filter(item -> null != item.getHappenTaxMny()).map(CostDetailEntity::getHappenTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
			costMny = list.stream().filter(item -> null != item.getHappenMny()).map(CostDetailEntity::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
		}
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("costTaxMny",costTaxMny);
		jsonObject.put("costMny",costMny);
		logger.info("查询结果：{}", jsonObject);
		return CommonResponse.success("查询成功", jsonObject);
	}

	@RequestMapping(value = "queryMnyBySubjectId", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<CostDetailVO>> queryMnyBySubjectId(@RequestParam(value = "sourceId", required = false) Long sourceId,@RequestParam Long projectId ,@RequestParam List<Long> subjectIds) {
		QueryWrapper<CostDetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.select("SUM(happen_mny) AS happenMny,SUM(happen_tax_mny) AS happenTaxMny,subject_id AS subjectId ");
		queryWrapper.eq("project_id",projectId);
		if(null!=sourceId){
			queryWrapper.ne("source_id",sourceId);
		}
		if(CollectionUtils.isNotEmpty(subjectIds)){
			queryWrapper.in("subject_id",subjectIds);
		}
		queryWrapper.groupBy("subject_id");
		List<CostDetailEntity> list  = costDetailService.list(queryWrapper);
		List<CostDetailVO> resList = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(list)){
			resList = BeanMapper.mapList(list,CostDetailVO.class);
		}
		return CommonResponse.success("查询成功", resList);
	}
}
