package com.ejianc.business.procost.controller;

import java.io.Serializable;

import com.ejianc.foundation.share.api.IShareProjectWbsApi;
import com.ejianc.foundation.share.api.IShareSubjectOrgApi;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.procost.bean.CostDetailEntity;
import com.ejianc.business.procost.service.ICostDetailService;
import com.ejianc.business.procost.vo.CostDetailVO;

/**
 * 数据明细表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("costDetail")
public class CostDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICostDetailService service;

    @Autowired
    private IShareSubjectOrgApi shareSubjectOrgApi;

    @Autowired
    private IShareProjectWbsApi shareProjectWbsApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CostDetailVO> saveOrUpdate(@RequestBody CostDetailVO saveorUpdateVO) {
    	CostDetailEntity entity = BeanMapper.map(saveorUpdateVO, CostDetailEntity.class);
    	service.saveOrUpdate(entity, false);
    	CostDetailVO vo = BeanMapper.map(entity, CostDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CostDetailVO> queryDetail(Long id) {
    	CostDetailEntity entity = service.selectById(id);
    	CostDetailVO vo = BeanMapper.map(entity, CostDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CostDetailVO> vos) {
        service.removeByIds(vos.stream().map(CostDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CostDetailVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Parameter parameter = param.getParams().get("subjectId");
        Map<Long, SubjectOrgVO> subjectMap = new HashMap<>();
        if(null != parameter){
            String subjectId = String.valueOf(parameter.getValue());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("innerCode", new Parameter(QueryParam.LIKE, subjectId));
            CommonResponse<List<SubjectOrgVO>> commonResponse = shareSubjectOrgApi.querySubjectOrg(queryParam);
            if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty(commonResponse.getData())) {
                List<Long> longList = new ArrayList<>();
                for(SubjectOrgVO subjectOrgVO : commonResponse.getData()){
                    longList.add(subjectOrgVO.getId());
                    subjectMap.put(subjectOrgVO.getId(), subjectOrgVO);
                }
                param.getParams().put("subjectId", new Parameter(QueryParam.IN, longList));
            }
        }

        IPage<CostDetailEntity> page = service.queryPage(param,false);
        IPage<CostDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            Parameter parm = param.getParams().get("projectId");
            Map<Long, ProjectWbsVO> wbsMap = new HashMap<>();
            if (null != parm) {
                Long projectId = (Long) parm.getValue();
                CommonResponse<List<ProjectWbsVO>> response = shareProjectWbsApi.queryByProjectId(projectId);
                if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
                    wbsMap = response.getData().stream().collect(Collectors.toMap(ProjectWbsVO::getId, Function.identity(), (key1, key2) -> key1));
                }
            }
            for(CostDetailEntity detailEntity : page.getRecords()){
                if (subjectMap.containsKey(detailEntity.getSubjectId())) {
                    SubjectOrgVO subjectOrgVO = subjectMap.get(detailEntity.getSubjectId());
                    detailEntity.setSubjectCode(subjectOrgVO.getSubjectCode());
                    detailEntity.setSubjectName(subjectOrgVO.getSubjectName());
                }
                if (wbsMap.containsKey(detailEntity.getWbsId())) {
                    ProjectWbsVO wbsVO = wbsMap.get(detailEntity.getWbsId());
                    detailEntity.setWbsCode(wbsVO.getCode());
                    detailEntity.setWbsName(wbsVO.getName());
                }
            }
        }
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CostDetailVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryTaxesByOrg 获取税金+间接费接口
     * @param year = 2022  //年度
     * @param orgId //组织
     */
    @RequestMapping(value = "/queryTaxesByOrg", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryTaxesByOrg(
            @RequestParam(value = "year", required = false) String year,
            @RequestParam(value = "orgId", required = false) Long orgId) {
        return service.queryTaxesByOrg(year, orgId);
    }
}
