package com.ejianc.business.procost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.bean.CostDetailEntity;
import com.ejianc.business.procost.bean.SettingEntity;
import com.ejianc.business.procost.bean.ShareEntity;
import com.ejianc.business.procost.service.ICostDetailService;
import com.ejianc.business.procost.service.ISettingService;
import com.ejianc.business.procost.service.IShareService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("setting") 
public class SettingBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ISettingService settingService;

	@Autowired
	private IShareService shareService;

	@Autowired
	private ICostDetailService costDetailService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		SettingEntity settingEntity = settingService.selectById(billId);

		LambdaQueryWrapper<ShareEntity> lambda = Wrappers.<ShareEntity>lambdaQuery();
		lambda.eq(ShareEntity::getTenantId,InvocationInfoProxy.getTenantid());
//		lambda.eq(ShareEntity::getProjectId,settingEntity.getProjectId());
		List<ShareEntity> list = shareService.list(lambda);
		if(CollectionUtils.isNotEmpty(list)){
			return CommonResponse.error("该设置已存在成本分摊,不允许回退");
		}
		LambdaQueryWrapper<CostDetailEntity> lambda2 = Wrappers.<CostDetailEntity>lambdaQuery();
		lambda2.eq(CostDetailEntity::getTenantId,InvocationInfoProxy.getTenantid());
//		lambda2.eq(CostDetailEntity::getProjectId,settingEntity.getProjectId());
		List<CostDetailEntity> list2  = costDetailService.list(lambda2);
		if(CollectionUtils.isNotEmpty(list2)){
			return CommonResponse.error("该设置已有单据发生成本分摊,不允许回退");
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
