package com.ejianc.business.procost.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.bean.CostDetailEntity;
import com.ejianc.business.procost.mapper.CostDetailMapper;
import com.ejianc.business.procost.service.ICostDetailService;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 数据明细表
 * 
 * @author generator
 * 
 */
@Service("costDetailService")
public class CostDetailServiceImpl extends BaseServiceImpl<CostDetailMapper, CostDetailEntity> implements ICostDetailService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectPoolApi projectSetApi;

    @Override
    public boolean deleteCostDetail(Long id) {
        return baseMapper.deleteCostDetail(id);
    }

    @Override
    public CommonResponse<BigDecimal> queryTaxesByOrg(String year, Long orgId) {
        BigDecimal sum = BigDecimal.ZERO;
        List<Long> projectIds = new ArrayList<>();
        List<ProjectPoolSetVO> projectList = this.queryProjectPoolList("1", null, orgId);
        projectIds = projectList.stream().map(ProjectPoolSetVO:: getId).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(projectIds)){
            return CommonResponse.success("项目为空！");
        }
        LambdaQueryWrapper<CostDetailEntity> lambda = Wrappers.<CostDetailEntity>lambdaQuery();
        lambda.eq(CostDetailEntity::getSourceType,"COST_HANDSHARE");
        lambda.eq(CostDetailEntity::getProportionFlag,"1");
        lambda.in(CostDetailEntity::getProjectId,projectIds);
        if(StringUtils.isNotEmpty(year)){
            lambda.le(CostDetailEntity::getPeriod,year+"-12");
        }
        List<CostDetailEntity> list = super.list(lambda);
        if(CollectionUtils.isNotEmpty(list)){
            sum =list.stream().filter(item -> null != item.getHappenMny()).map(CostDetailEntity::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return CommonResponse.success(sum);
    }

    @Override
    public CommonResponse<BigDecimal> queryTaxesByOrgNoProjectStatus(String year, Long orgId) {
        BigDecimal sum = BigDecimal.ZERO;
        List<Long> projectIds = new ArrayList<>();
        List<ProjectPoolSetVO> projectList = this.queryProjectPoolList(null, null, orgId);
        projectIds = projectList.stream().map(ProjectPoolSetVO:: getId).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(projectIds)){
            return CommonResponse.success("项目为空！");
        }
        LambdaQueryWrapper<CostDetailEntity> lambda = Wrappers.<CostDetailEntity>lambdaQuery();
        lambda.eq(CostDetailEntity::getSourceType,"COST_HANDSHARE");
        lambda.eq(CostDetailEntity::getProportionFlag,"1");
        lambda.in(CostDetailEntity::getProjectId,projectIds);
        if(StringUtils.isNotEmpty(year)){
            lambda.le(CostDetailEntity::getPeriod,year+"-12");
        }
        List<CostDetailEntity> list = super.list(lambda);
        if(CollectionUtils.isNotEmpty(list)){
            sum =list.stream().filter(item -> null != item.getHappenMny()).map(CostDetailEntity::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return CommonResponse.success(sum);
    }

    public List<ProjectPoolSetVO> queryProjectPoolList(String projectStatus, String dateIn, Long orgId) {
        CommonResponse<JSONArray> resp = projectSetApi.queryProjectPoolList(projectStatus, dateIn, orgId);
        List<ProjectPoolSetVO> result = new ArrayList<>();
        if(resp.isSuccess()){
            result = JSONArray.parseArray(JSONObject.toJSONString(resp.getData()), ProjectPoolSetVO.class);
        } else {
            logger.error(resp.getMsg());
        }
        return result;
    }
}
