package com.ejianc.business.procost.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.procost.bean.ReportEntity;
import com.ejianc.business.procost.service.IReportService;
import com.ejianc.business.procost.vo.ReportVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 * 合同文件管理控制
 *
 * @author CJ
 * @Description: 合同文件管理控制
 * @date 2021/11/26 14:16
 */
@RestController
@RequestMapping("/reportFileUpdate/")
public class ReportFileController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IReportService service;

    @Autowired
    private ISignatureManageApi signatureManageApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    /**
     * 合同附件信息更新
     *
     * @param updateData {
     *   billId 单据Id
     *   sourceType 单据业务类型
     *   billType 单据类型
     *   fileId 文件Id
     *   fileSize 文件大小（以B为单位）
     *   fileName 文件名称
     *   fileOnlinePath 文件在线预览地址
     *   imgServerPath 文件服务地址
     *   formatPathStr 文件格式化地址
     * }
     * @return
     */
    @PostMapping(value = "updateFileInfo")
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();

        ReportEntity contract = service.selectById(updateData.getLong("billId"));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        //将合同文件同步状态设置为已同步
//        contract.setContractFileSyncFlag(true);
        service.saveOrUpdate(contract, false);

        resp.put("message", "合同文件信息更新成功");
        resp.put("billData", contract);
        return CommonResponse.success("合同文件信息更新成功！", resp);
    }


    @GetMapping(value = "getBillDataJson")
    public CommonResponse<ReportVO> getBillDataJson(@RequestParam Long id) {
        ReportEntity contract = service.selectById(id);
        ReportVO vo = BeanMapper.map(contract, ReportVO.class);

        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,##0.00");
        if(CollectionUtils.isNotEmpty(vo.getReportDetailList())) {
            vo.getReportDetailList().forEach(item -> {
                item.setYsHappenMnyAllStr(null != item.getYsHappenMnyAll() ? mnyFmt.format(item.getYsHappenMnyAll()) : mnyFmt.format(BigDecimal.ZERO));
                item.setCbHappenMnyAllStr(null != item.getCbHappenMnyAll() ? mnyFmt.format(item.getCbHappenMnyAll()) : mnyFmt.format(BigDecimal.ZERO));
                item.setYsHappenMnyStr(null != item.getYsHappenMny() ? mnyFmt.format(item.getYsHappenMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setCbHappenMnyStr(null != item.getCbHappenMny() ? priceFmt.format(item.getCbHappenMny()) : priceFmt.format(BigDecimal.ZERO));
                item.setHappenMnyStr(null != item.getHappenMny() ? priceFmt.format(item.getHappenMny()) : priceFmt.format(BigDecimal.ZERO));
                item.setSrmbdifMnyStr(null != item.getSrmbdifMny() ? priceFmt.format(item.getSrmbdifMny()) : priceFmt.format(BigDecimal.ZERO));
                item.setSrmbRateStr(null != item.getSrmbRate() ? priceFmt.format(item.getSrmbRate()) : priceFmt.format(BigDecimal.ZERO));
                item.setSrsjdifMnyStr(null != item.getSrsjdifMny() ? priceFmt.format(item.getSrsjdifMny()) : priceFmt.format(BigDecimal.ZERO));
                item.setSrsjRateStr(null != item.getSrsjRate() ? priceFmt.format(item.getSrsjRate()) : priceFmt.format(BigDecimal.ZERO));
                item.setMbsjdifMnyStr(null != item.getMbsjdifMny() ? priceFmt.format(item.getMbsjdifMny()) : priceFmt.format(BigDecimal.ZERO));
                item.setMbsjRateStr(null != item.getMbsjRate() ? priceFmt.format(item.getMbsjRate()) : priceFmt.format(BigDecimal.ZERO));
                item.setCostMnyStr(null != item.getCostMny() ? mnyFmt.format(item.getCostMny()) : mnyFmt.format(BigDecimal.ZERO));

            });
        }
        return CommonResponse.success(vo);
    }
}
