/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procost.bean.ReportEntity;
import com.ejianc.business.procost.service.IReportService;
import com.ejianc.business.procost.service.IShareService;
import com.ejianc.business.procost.vo.ReportDetailVO;
import com.ejianc.business.procost.vo.ReportNumpVO;
import com.ejianc.business.procost.vo.ReportThreeVO;
import com.ejianc.business.procost.vo.ReportVO;
import com.ejianc.business.procost.vo.ThreeReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"report"})
@Api(value="\u6210\u672c\u5206\u6790\u62a5\u544a", tags={"\u6210\u672c\u5206\u6790\u62a5\u544a"})
public class ReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "COST_REPORT";
    @Autowired
    private IReportService service;
    @Autowired
    private IShareService shareService;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ReportVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody ReportVO saveOrUpdateVO) {
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda2.eq(ReportEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        if (null != saveOrUpdateVO.getId()) {
            lambda2.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        }
        lambda2.notIn(ReportEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.service.list((Wrapper)lambda2);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u5df2\u5b58\u5728\u672a\u751f\u6548\u5355\u636e,\u8bf7\u5148\u5904\u7406\u672a\u751f\u6548\u5355\u636e\uff01");
        }
        ReportEntity entity = (ReportEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ReportEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setContractFileId(null);
        this.service.saveOrUpdate((Object)entity, false);
        ReportVO vo = (ReportVO)BeanMapper.map((Object)((Object)entity), ReportVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReportVO> queryDetail(@RequestParam Long id) {
        ReportEntity entity = (ReportEntity)((Object)this.service.selectById(id));
        ReportVO vo = (ReportVO)BeanMapper.map((Object)((Object)entity), ReportVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryThreeReports"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReportThreeVO> queryThreeReports(@RequestParam Long projectId) {
        ReportThreeVO resVo = new ReportThreeVO();
        List<ThreeReportVO> reportVOList = this.shareService.getThreeReportVO(projectId, "", "");
        this.logger.info("\u4e09\u7b97\u5bf9\u6bd4\u8fd4\u56de\u6570\u636e-----result\uff1a" + JSONObject.toJSONString(reportVOList));
        if (CollectionUtils.isNotEmpty(reportVOList)) {
            List<ThreeReportVO> result = reportVOList.stream().filter(ThreeReportVO2 -> ThreeReportVO2.getParentID().equals(999L)).collect(Collectors.toList());
            this.logger.info("\u79d1\u76ee-----result\uff1a" + JSONObject.toJSONString(result));
            if (CollectionUtils.isNotEmpty(result)) {
                BigDecimal srcztjMny = result.stream().filter(item -> null != item.getYsHappenMny()).map(ThreeReportVO::getYsHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                resVo.setSrcztjMny(srcztjMny);
                BigDecimal mbcbtjMny = result.stream().filter(item -> null != item.getCbHappenMny()).map(ThreeReportVO::getCbHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                resVo.setMbcbtjMny(mbcbtjMny);
                BigDecimal sjcbtjMny = result.stream().filter(item -> null != item.getHappenMny()).map(ThreeReportVO::getHappenMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                resVo.setSjcbtjMny(sjcbtjMny);
                BigDecimal srsjdifMny = srcztjMny.subtract(sjcbtjMny);
                BigDecimal srsjRate = BigDecimal.ZERO;
                if (srsjdifMny.compareTo(BigDecimal.ZERO) != 0 && srcztjMny.compareTo(BigDecimal.ZERO) != 0) {
                    srsjRate = srsjdifMny.multiply(new BigDecimal(100)).divide(srcztjMny, 2, 5);
                }
                resVo.setSrsjRate(srsjRate);
                BigDecimal mbsjdifMny = mbcbtjMny.subtract(sjcbtjMny);
                BigDecimal mbsjRate = BigDecimal.ZERO;
                if (mbsjdifMny.compareTo(BigDecimal.ZERO) != 0 && mbcbtjMny.compareTo(BigDecimal.ZERO) != 0) {
                    mbsjRate = mbsjdifMny.multiply(new BigDecimal(100)).divide(mbcbtjMny, 2, 5);
                }
                resVo.setMbsjRate(mbsjRate);
                result.forEach(e -> {
                    e.setRowState("add");
                    if ("02".equals(e.getSubjectCode())) {
                        resVo.setMaterialIncomeMny(e.getYsHappenMny());
                        resVo.setMaterialTargetcostMny(e.getCbHappenMny());
                        resVo.setMaterialCostMny(e.getHappenMny());
                        resVo.setMaterialSrsjMny(e.getSrsjdifMny());
                        resVo.setMaterialMbsjMny(e.getMbsjdifMny());
                    } else if ("04".equals(e.getSubjectCode())) {
                        resVo.setSubIncomeMny(e.getYsHappenMny());
                        resVo.setSubTargetcostMny(e.getCbHappenMny());
                        resVo.setSubCostMny(e.getHappenMny());
                        resVo.setSubSrsjMny(e.getSrsjdifMny());
                        resVo.setSubMbsjMny(e.getMbsjdifMny());
                    } else if ("06".equals(e.getSubjectCode())) {
                        resVo.setJjfIncomeMny(e.getYsHappenMny());
                        resVo.setJjfTargetcostMny(e.getCbHappenMny());
                        resVo.setJjfCostMny(e.getHappenMny());
                        resVo.setJjfSrsjMny(e.getSrsjdifMny());
                        resVo.setJjfMbsjMny(e.getMbsjdifMny());
                    } else if ("07".equals(e.getSubjectCode())) {
                        BigDecimal sjincomeMny = e.getYsHappenMny() == null ? BigDecimal.ZERO : e.getYsHappenMny();
                        BigDecimal sjcostMny = e.getHappenMny() == null ? BigDecimal.ZERO : e.getHappenMny();
                        resVo.setSjIncomeMny(sjincomeMny);
                        resVo.setSjTargetcostMny(e.getCbHappenMny());
                        resVo.setSjCostMny(sjcostMny);
                        resVo.setSjMny(sjincomeMny.subtract(sjcostMny));
                    }
                });
                resVo.setReportDetailList(BeanMapper.mapList(result, ReportDetailVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)resVo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryNumpReports"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReportNumpVO> queryNumpReports(@RequestParam Long projectId) {
        ReportNumpVO resVo = new ReportNumpVO();
        List<ThreeReportVO> reportVOList = this.shareService.getNumpReports(projectId, "", "");
        if (CollectionUtils.isNotEmpty(reportVOList)) {
            List gjResult = reportVOList.stream().filter(ThreeReportVO2 -> ThreeReportVO2.getSubjectCode().equals("020101")).collect(Collectors.toList());
            this.logger.info("\u79d1\u76ee\u94a2\u7b4b-----result\uff1a" + JSONObject.toJSONString(gjResult));
            if (CollectionUtils.isNotEmpty(gjResult)) {
                ThreeReportVO threeReportVO = (ThreeReportVO)gjResult.get(0);
                resVo.setGjIncomeNum(threeReportVO.getYsNum());
                resVo.setGjTargetcostNum(threeReportVO.getCbNum());
                resVo.setGjCostNum(threeReportVO.getNum());
                resVo.setGjSrsjNum(threeReportVO.getSrsjNum());
                resVo.setGjMbsjNum(threeReportVO.getMbsjNum());
                resVo.setGjIncomeMny(threeReportVO.getYsHappenMny());
                resVo.setGjTargetcostMny(threeReportVO.getCbHappenMny());
                resVo.setGjCostMny(threeReportVO.getHappenMny());
                resVo.setGjSrsjMny(threeReportVO.getSrsjdifMny());
                resVo.setGjMbsjMny(threeReportVO.getMbsjdifMny());
            }
            List sptResult = reportVOList.stream().filter(ThreeReportVO2 -> ThreeReportVO2.getSubjectCode().equals("020401")).collect(Collectors.toList());
            this.logger.info("\u79d1\u76ee\u5546\u54c1\u783c-----result\uff1a" + JSONObject.toJSONString(sptResult));
            if (CollectionUtils.isNotEmpty(sptResult)) {
                ThreeReportVO threeReportVO = (ThreeReportVO)sptResult.get(0);
                resVo.setSptIncomeNum(threeReportVO.getYsNum());
                resVo.setSptTargetcostNum(threeReportVO.getCbNum());
                resVo.setSptCostNum(threeReportVO.getNum());
                resVo.setSptSrsjNum(threeReportVO.getSrsjNum());
                resVo.setSptMbsjNum(threeReportVO.getMbsjNum());
                resVo.setSptIncomeMny(threeReportVO.getYsHappenMny());
                resVo.setSptTargetcostMny(threeReportVO.getCbHappenMny());
                resVo.setSptCostMny(threeReportVO.getHappenMny());
                resVo.setSptSrsjMny(threeReportVO.getSrsjdifMny());
                resVo.setSptMbsjMny(threeReportVO.getMbsjdifMny());
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)resVo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReportVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ReportVO reportVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReportVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Report-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refReportData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ReportVO>> refReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

