package com.ejianc.business.procost.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.procost.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.procost.bean.ShareEntity;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 成本分摊
 *
 * @author generator
 *
 */
public interface IShareService extends IBaseService<ShareEntity> {

    CommonResponse<ShareVO> saveOrUpdateShare(ShareVO saveorUpdateVO);

    List<MonthVO> getMonths(Long projectId,String year);

    List<SubjectReportVO> getSubjectReport(Long projectId,String period,int type,Long wbsId);

    List<TemplateDatas> getSubjectReportAlls(Long projectId,List<String> period,int type);

    SubjectReportVO queryProReports(HttpServletRequest request,Long projectId);

    List<ShareDetailVO> getDetail(Long projectId, String endDay, String taxFlag,String billType,String materialCost,int type, HttpServletRequest request,String costType);

    SubjectFlagVO getSubkectFlag(Long sourceId, String billType);

    List<SubjectReportVO> getCostAllDetails(Long projectId, String beginPeriod, String endPeriod);

    List<SubjectReportVO> getDetailsBySubjectId(Long projectId, String beginPeriod, String endPeriod,Long subjectId);

    List<SubjectReportsVO> getDetailsByWbsId(Long projectId, String beginPeriod, String endPeriod,Long subjectId,Long wbsId);

    List<ThreeReportVO> getThreeReports(Long projectId, String beginPeriod,String endPeriod);

    List<ThreeReportVO> getNumpReports(Long projectId, String beginPeriod,String endPeriod);
    List<CostDetailVO> queryDetailByProject(Long projectId, Long sourceId,List<Long> subjectIds);
    List<Map<String, Object>> queryCollectionWarnCost(List<SqlParam> sqlParamList);
    List<Map<String, Object>> queryOutputWarnCost(List<SqlParam> sqlParamList);


    List<ThreeReportVO> getThreeReportVO(Long projectId, String beginPeriod,String endPeriod);

}
