/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.controller;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.business.procost.bean.ShareEntity;
import com.ejianc.business.procost.service.IShareService;
import com.ejianc.business.procost.util.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"warnTiming"})
public class WarnTimingController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareService shareService;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IProincomeContractApi proincomeContractApi;

    @RequestMapping(value={"/notCollectionTimingWarn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> notCollectionTimingWarn(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        Date date = new Date();
        Date oneDate = DateUtil.setDays(date, 1);
        Integer betweenDays = DateUtil.getBetweenDays(date, oneDate);
        Date oldDate = DateUtil.addMonths(oneDate, -1);
        String s = DateFormatUtil.formatDate((String)"yyyy-MM", (Date)oldDate);
        Map<Object, Object> projectMap = new HashMap();
        CommonResponse jsonArrayCommonResponse = this.projectPoolApi.queryProjectPoolList(null, null, null);
        if (jsonArrayCommonResponse.isSuccess() && null != jsonArrayCommonResponse.getData() && CollectionUtils.isNotEmpty((Collection)((Collection)jsonArrayCommonResponse.getData()))) {
            JSONArray data = (JSONArray)jsonArrayCommonResponse.getData();
            List projectData = JSONObject.parseArray((String)data.toJSONString(), ProjectPoolSetVO.class);
            projectMap = projectData.stream().filter(t -> null != t.getTenantId()).collect(Collectors.groupingBy(BaseVO::getTenantId));
            if (null == projectMap) {
                projectMap = new HashMap();
            }
            this.logger.info("\u9879\u76ee\u4fe1\u606f\u6761\u6570\uff1a{}", (Object)projectData.size());
        }
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ShareEntity::getPeriod, (Object)s);
        lambda.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
        lambda.in(ShareEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list = this.shareService.list((Wrapper)lambda);
        this.logger.info("\u6210\u672c\u6761\u6570\uff1a{}", (Object)list.size());
        Map<Long, List<ShareEntity>> costTenantIdMap = list.stream().filter(t -> null != t.getTenantId()).collect(Collectors.groupingBy(BaseEntity::getTenantId));
        this.logger.info("\u6210\u672c\u79df\u6237\u5206\u7ec4\u6761\u6570\uff1a{}", (Object)costTenantIdMap.size());
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List projectPoolSetVOS = (List)projectMap.get(tenantId);
            if (null == projectPoolSetVOS || !ListUtil.isNotEmpty((List)projectPoolSetVOS)) continue;
            for (ProjectPoolSetVO projectPoolSetVO : projectPoolSetVOS) {
                int i1;
                OrgVO orgVO;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = projectPoolSetVO.getProjectDepartmentId();
                if (orgId == null || (orgVO = (OrgVO)this.orgApi.getOneById(orgId).getData()) == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                List<Object> shareList = null == costTenantIdMap.get(tenantId) ? new ArrayList() : costTenantIdMap.get(tenantId);
                Map<Long, List<ShareEntity>> costMap = shareList.stream().filter(t -> null != t.getProjectId()).collect(Collectors.groupingBy(ShareEntity::getProjectId));
                List<ShareEntity> shareEntities = costMap.get(projectPoolSetVO.getId());
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    Integer day = set.getIntValue("parameterValue");
                    this.logger.info("\u5f53\u524d\u65e5\u671f\uff1a{},\u5f53\u524d\u6708\u7b2c\u4e00\u5929\u65e5\u671f\uff1a{}\uff0c\u5dee\u503c\uff1a{},\u4e0a\u4e00\u4e2a\u6708\uff1a{},\u9694\u5929\u6570\uff1a{},\u79df\u6237id:{}", new Object[]{DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)date), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)oneDate), betweenDays, s, day, tenantId});
                    if ("\u9ad8".equals(set.getString("warningLevel")) && betweenDays >= day && (null == shareEntities || CollectionUtils.isEmpty(shareEntities))) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && betweenDays >= day && (null == shareEntities || CollectionUtils.isEmpty(shareEntities))) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || betweenDays < day || null != shareEntities && !CollectionUtils.isEmpty(shareEntities)) continue;
                    low = true;
                    useSetLow = set;
                }
                DecimalFormat df = new DecimalFormat("###,##0.00");
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + projectPoolSetVO.getName());
                vo.setPcTitle("\u6210\u672c\u5f52\u96c6\u5355");
                vo.setOrgId(projectPoolSetVO.getOrgId());
                vo.setSendOrgId(projectPoolSetVO.getOrgId() + "");
                vo.setOrgName(projectPoolSetVO.getOrgName());
                vo.setSourceId(projectPoolSetVO.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(projectPoolSetVO.getName())));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(projectPoolSetVO.getName())));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(projectPoolSetVO.getName())));
                }
                warnList.add(vo);
            }
        }
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName("\u6210\u672c\u5f52\u96c6\u5355-" + String.valueOf(m.get("projectName")));
            vo.setPcTitle("\u6210\u672c\u5f52\u96c6\u5355");
            vo.setOrgId(this.strLon(m.get("orgId")));
            vo.setOrgName(String.valueOf(m.get("orgName")));
            vo.setSourceId(String.valueOf(m.get("projectId")));
            vo.setTenantId(this.strLon(m.get("tenantId")));
            vo.setWarnLevel(String.valueOf(m.get("warnLevel")));
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(m.get("projectName"))));
            resp.add(vo);
        }
        this.logger.info("\u53d1\u9001\u9884\u8b66\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(resp));
        return resp;
    }

    private Long strLon(Object obj) {
        if (null == obj) {
            return null;
        }
        String s = obj.toString();
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        return Long.valueOf(s);
    }

    @RequestMapping(value={"/costOutputTimingWarn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> costOutputTimingWarn(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        Map data = new HashMap();
        CommonResponse mapCommonResponse = this.proincomeContractApi.queryTotalProduction();
        this.logger.info("\u4ea7\u503c\u62a5\u91cfapi\u7ed3\u679c\uff1a{}", (Object)mapCommonResponse.getMsg());
        if (mapCommonResponse.isSuccess() && null != mapCommonResponse.getData()) {
            data = (Map)mapCommonResponse.getData();
        }
        this.logger.info("\u4ea7\u503c\u62a5\u91cf\u6761\u6570\uff1a{}", (Object)data.size());
        Map<Object, Object> projectMap = new HashMap();
        CommonResponse jsonArrayCommonResponse = this.projectPoolApi.queryProjectPoolList(null, null, null);
        this.logger.info("\u9879\u76ee\u6c60api\u7ed3\u679c\uff1a{}", (Object)jsonArrayCommonResponse.getMsg());
        if (jsonArrayCommonResponse.isSuccess() && null != jsonArrayCommonResponse.getData() && CollectionUtils.isNotEmpty((Collection)((Collection)jsonArrayCommonResponse.getData()))) {
            JSONArray jsonArray = (JSONArray)jsonArrayCommonResponse.getData();
            List projectData = JSONObject.parseArray((String)jsonArray.toJSONString(), ProjectPoolSetVO.class);
            projectMap = projectData.stream().filter(t -> null != t.getId()).collect(Collectors.toMap(BaseVO::getId, item -> item, (v1, v2) -> v2));
        }
        this.logger.info("\u9879\u76ee\u4fe1\u606f\u6761\u6570\uff1a{}", (Object)projectMap.size());
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
        lambda.in(ShareEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list = this.shareService.list((Wrapper)lambda);
        this.logger.info("\u6210\u672c\u6761\u6570\uff1a{}", (Object)list.size());
        Map<Long, List<ShareEntity>> costTenantIdMap = list.stream().filter(t -> null != t.getTenantId()).collect(Collectors.groupingBy(BaseEntity::getTenantId));
        this.logger.info("\u6210\u672c\u79df\u6237\u5206\u7ec4\u6761\u6570\uff1a{}", (Object)costTenantIdMap.size());
        for (int i = 0; i < jsonParam.size(); ++i) {
            Map<Long, List<ShareEntity>> costMap;
            ArrayList shareList;
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            ArrayList shareEntityList = costTenantIdMap.get(tenantId);
            ArrayList arrayList = shareList = null == shareEntityList ? new ArrayList() : shareEntityList;
            if (CollectionUtils.isEmpty(shareList) || !MapUtil.isNotEmpty(costMap = shareList.stream().filter(t -> null != t.getProjectId()).collect(Collectors.groupingBy(ShareEntity::getProjectId)))) continue;
            for (Long projectId : costMap.keySet()) {
                int i1;
                OrgVO orgVO;
                Long orgId;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                List<ShareEntity> shareCost = costMap.get(projectId);
                if (null == shareCost || CollectionUtils.isEmpty(shareCost) || (orgId = shareCost.get(0).getOrgId()) == null || (orgVO = (OrgVO)this.orgApi.getOneById(orgId).getData()) == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)projectMap.get(projectId);
                ShareEntity shareEntity = shareCost.get(0);
                BigDecimal costMny = shareCost.stream().filter(e -> null != e.getCostMny()).map(ShareEntity::getCostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                ProductionVO productionVO = (ProductionVO)data.get(projectId);
                BigDecimal productionTaxMny = null == productionVO ? BigDecimal.ZERO : (null == productionVO.getProductionTaxMny() ? BigDecimal.ZERO : productionVO.getProductionTaxMny());
                Long parentOrgId = null == projectPoolSetVO ? shareEntity.getParentOrgId() : projectPoolSetVO.getOrgId();
                String parentOrgName = null == projectPoolSetVO ? shareEntity.getParentOrgName() : projectPoolSetVO.getOrgName();
                List<ShareEntity> shareEntities = costMap.get(projectPoolSetVO.getId());
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    BigDecimal bigDecimal = null == set.getBigDecimal("parameterValue") ? BigDecimal.ZERO : ComputeUtil.safeDiv((BigDecimal)set.getBigDecimal("parameterValue"), (BigDecimal)new BigDecimal("100")).setScale(4, 4);
                    BigDecimal bigDecimal1 = ComputeUtil.safeMultiply((BigDecimal)productionTaxMny, (BigDecimal)bigDecimal);
                    this.logger.info("--\u9879\u76eeid\uff1a{},\u9879\u76ee\u540d\u79f0\uff1a{},\u5b9e\u9645\u6210\u672c\u7d2f\u8ba1\uff1a{},\u4ea7\u503c\u62a5\u91cf\u7d2f\u8ba1\uff1a{},\u767e\u5206\u6bd4\uff1a{},\u767e\u5206\u6bd4\u540e\u4ea7\u503c\u62a5\u91cf\u7d2f\u8ba1\uff1a{}--", new Object[]{projectId, shareEntity.getProjectName(), costMny, productionTaxMny, bigDecimal, bigDecimal1});
                    if ("\u9ad8".equals(set.getString("warningLevel")) && bigDecimal1.compareTo(BigDecimal.ZERO) > 0 && costMny.compareTo(bigDecimal1) > 0) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && bigDecimal1.compareTo(BigDecimal.ZERO) > 0 && costMny.compareTo(bigDecimal1) > 0) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || bigDecimal1.compareTo(BigDecimal.ZERO) <= 0 || costMny.compareTo(bigDecimal1) <= 0) continue;
                    low = true;
                    useSetLow = set;
                }
                DecimalFormat df = new DecimalFormat("###,##0.00");
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + projectPoolSetVO.getName());
                vo.setPcTitle("\u6210\u672c\u5f52\u96c6\u5355");
                vo.setOrgId(projectPoolSetVO.getOrgId());
                vo.setSendOrgId(projectPoolSetVO.getOrgId() + "");
                vo.setOrgName(projectPoolSetVO.getOrgName());
                vo.setSourceId(projectPoolSetVO.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(projectPoolSetVO.getName())));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(projectPoolSetVO.getName())));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", String.valueOf(projectPoolSetVO.getName())));
                }
                warnList.add(vo);
            }
        }
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }
}

