package com.ejianc.business.procurement.plan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 采购计划授权实体
 * 
 * @author generator
 * 
 */
public class AuthapplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private BigDecimal ctrlTaxMny; // 控制含税总额
    private BigDecimal preTaxMny; // 预估含税总额
    private BigDecimal bidTaxMny; // 投标含税总额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    private String billCode; // 单据编号
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private String orgName; // 项目部名称
    private String orgCode; // 项目部编码
    private String parentOrgName; // 项目部上级名称
    private String parentOrgCode; // 项目部上级编码
    private String allOrgName; // 所属组织(所属单位-项目经理部)
    private String employeeName; // 经办人名称
    private String businessType; // 业务类别1-工程，2-货物，3-服务
    private String authapplyType; // 授权类别1-授权申请，2-授权委托
    private String memo; // 备注
    private String authCode; // 一级集采授权编号
    private Integer billState; // 单据状态
    private Integer permissionType; // 实施权限 1-一级集采，2-二级集采，3-所属单位，4-项目经理部
    private Integer authMemo; // 授权委托说明
    private Integer supplierMemo; // 拟采用采购方案及供应商信息
    private Long projectId; // 项目Id
    private Long orgId; // 项目部Id
    private Long parentOrgId; // 项目部上级Id
    private Long employeeId; // 经办人
    
    private List<AuthapplyDetailVO> authapplyDetailList = new ArrayList<>(); // 采购计划授权明细实体

    public BigDecimal getCtrlTaxMny() {
        return ctrlTaxMny;
    }

    public void setCtrlTaxMny(BigDecimal ctrlTaxMny) {
        this.ctrlTaxMny = ctrlTaxMny;
    }
    public BigDecimal getPreTaxMny() {
        return preTaxMny;
    }

    public void setPreTaxMny(BigDecimal preTaxMny) {
        this.preTaxMny = preTaxMny;
    }
    public BigDecimal getBidTaxMny() {
        return bidTaxMny;
    }

    public void setBidTaxMny(BigDecimal bidTaxMny) {
        this.bidTaxMny = bidTaxMny;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getAllOrgName() {
        return allOrgName;
    }

    public void setAllOrgName(String allOrgName) {
        this.allOrgName = allOrgName;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public String getAuthapplyType() {
        return authapplyType;
    }

    public void setAuthapplyType(String authapplyType) {
        this.authapplyType = authapplyType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getAuthCode() {
        return authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getPermissionType() {
        return permissionType;
    }

    public void setPermissionType(Integer permissionType) {
        this.permissionType = permissionType;
    }
    public Integer getAuthMemo() {
        return authMemo;
    }

    public void setAuthMemo(Integer authMemo) {
        this.authMemo = authMemo;
    }
    public Integer getSupplierMemo() {
        return supplierMemo;
    }

    public void setSupplierMemo(Integer supplierMemo) {
        this.supplierMemo = supplierMemo;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    
     public List<AuthapplyDetailVO> getAuthapplyDetailList() {
        return authapplyDetailList;
     }

     public void setAuthapplyDetailList(List<AuthapplyDetailVO> authapplyDetailList) {
        this.authapplyDetailList = authapplyDetailList;
     }
}
