package com.ejianc.business.procurement.plan.vo;

import com.ejianc.framework.skeleton.fieldCompare.CompareDifferenceUtil;
import com.ejianc.framework.skeleton.fieldCompare.DifferenceComparison;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


/**
 * 采购策划-明细
 *
 * @author generator
 *
 */
@DifferenceComparison(changeFlag = "changeType", differnceList = "differnceList", beforeKeyPrefix = "before")
public class PurchaseStrategyDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private BigDecimal num; // 计划数量
    private BigDecimal payScale; // 支付比例
    private BigDecimal ctrlDetailTaxMny; // 控制价(万元)
    private BigDecimal preDetailTaxMny; // 策划暂估金额(万元)
    private BigDecimal bidDetailTaxMny; // 市场投标金额(万元)
    private BigDecimal subDetailTaxMny; // 拟分包金额(万元)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commitDate; // 提报时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date enterDate; // 进场时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bidDate; // 采购招标时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date exitDate; // 退场时间
    private String usageCategoryName; // 材料/设备使用类别名称
    private String materialCode; // 档案编码
    private String materialName; // 档案名称
    private String materialTypeName; // 分类名称
    private String materialTypeCode; // 分类编码
    private String spec; // 规则/型号
    private String unitName; // 计量单位
    private String purchaseDeployPlaceName; // 采购实施地点名称
    private String purchaseTypeName; // 采购类型名称
    private String payCycleName; // 付款周期
    private String payShapeName; // 付款形式
    private String payTypeName; // 付款类型
    private String supplierNames; // 推荐供应商单位
    private String subLot; // 分标段/包组情况
    private String memo; // 备注
    private String subItemName; // 分包项目
    private String subContent; // 分包内容
    private String subWayName; // 分包方式
    private String serviceTypeName; // 服务类别
    private String serviceContent; // 服务内容
    private Integer planPermissionType; // 实施权限 1-一级集采，2-二级集采，3-所属单位，4-项目经理部
    private Long pid; // 计划Id
    private Long usageCategoryId; // 材料/设备使用类别id
    private Long materialId; // 档案Id
    private Long materialTypeId; // 分类Id
    private Long unitId; // 计量单位主键
    private Long purchaseDeployPlaceId; // 采购实施地点id
    private Long purchaseTypeId; // 采购类型
    private Long payCycleId; // 付款周期
    private Long payShapeId; // 付款形式
    private Long payTypeId; // 付款类型
    private Long targetId; // 原明细id
    private Long targetMainId; // 原主表id
    private Long subWayId; // 分包方式id
    private Long subItemId; // 分包项目id
    private Long serviceTypeId; // 服务类别id


    /**
     * 对比字段说明
     */
    private BigDecimal beforeNum; // 变更前计划数量
    private BigDecimal beforeCtrlDetailTaxMny; // 控制价(万元)
    private BigDecimal beforePreDetailTaxMny; // 策划暂估金额(万元)
    private BigDecimal beforeBidDetailTaxMny; // 市场投标金额(万元)
    private BigDecimal beforeSubDetailTaxMny; // 拟分包金额(万元)
    private String changeType;
    List<CompareDifferenceUtil.FieldDifference> differnceList;

    public BigDecimal getBeforeNum() {
        return beforeNum;
    }

    public void setBeforeNum(BigDecimal beforeNum) {
        this.beforeNum = beforeNum;
    }

    public BigDecimal getBeforeCtrlDetailTaxMny() {
        return beforeCtrlDetailTaxMny;
    }

    public void setBeforeCtrlDetailTaxMny(BigDecimal beforeCtrlDetailTaxMny) {
        this.beforeCtrlDetailTaxMny = beforeCtrlDetailTaxMny;
    }

    public BigDecimal getBeforePreDetailTaxMny() {
        return beforePreDetailTaxMny;
    }

    public void setBeforePreDetailTaxMny(BigDecimal beforePreDetailTaxMny) {
        this.beforePreDetailTaxMny = beforePreDetailTaxMny;
    }

    public BigDecimal getBeforeBidDetailTaxMny() {
        return beforeBidDetailTaxMny;
    }

    public void setBeforeBidDetailTaxMny(BigDecimal beforeBidDetailTaxMny) {
        this.beforeBidDetailTaxMny = beforeBidDetailTaxMny;
    }

    public BigDecimal getBeforeSubDetailTaxMny() {
        return beforeSubDetailTaxMny;
    }

    public void setBeforeSubDetailTaxMny(BigDecimal beforeSubDetailTaxMny) {
        this.beforeSubDetailTaxMny = beforeSubDetailTaxMny;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public List<CompareDifferenceUtil.FieldDifference> getDiffernceList() {
        return differnceList;
    }

    public void setDiffernceList(List<CompareDifferenceUtil.FieldDifference> differnceList) {
        this.differnceList = differnceList;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public BigDecimal getCtrlDetailTaxMny() {
        return ctrlDetailTaxMny;
    }

    public void setCtrlDetailTaxMny(BigDecimal ctrlDetailTaxMny) {
        this.ctrlDetailTaxMny = ctrlDetailTaxMny;
    }

    public BigDecimal getPreDetailTaxMny() {
        return preDetailTaxMny;
    }

    public void setPreDetailTaxMny(BigDecimal preDetailTaxMny) {
        this.preDetailTaxMny = preDetailTaxMny;
    }

    public BigDecimal getBidDetailTaxMny() {
        return bidDetailTaxMny;
    }

    public void setBidDetailTaxMny(BigDecimal bidDetailTaxMny) {
        this.bidDetailTaxMny = bidDetailTaxMny;
    }

    public BigDecimal getSubDetailTaxMny() {
        return subDetailTaxMny;
    }

    public void setSubDetailTaxMny(BigDecimal subDetailTaxMny) {
        this.subDetailTaxMny = subDetailTaxMny;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public Date getEnterDate() {
        return enterDate;
    }

    public void setEnterDate(Date enterDate) {
        this.enterDate = enterDate;
    }

    public Date getBidDate() {
        return bidDate;
    }

    public void setBidDate(Date bidDate) {
        this.bidDate = bidDate;
    }

    public Date getExitDate() {
        return exitDate;
    }

    public void setExitDate(Date exitDate) {
        this.exitDate = exitDate;
    }

    public String getUsageCategoryName() {
        return usageCategoryName;
    }

    public void setUsageCategoryName(String usageCategoryName) {
        this.usageCategoryName = usageCategoryName;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getPurchaseDeployPlaceName() {
        return purchaseDeployPlaceName;
    }

    public void setPurchaseDeployPlaceName(String purchaseDeployPlaceName) {
        this.purchaseDeployPlaceName = purchaseDeployPlaceName;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public String getPayCycleName() {
        return payCycleName;
    }

    public void setPayCycleName(String payCycleName) {
        this.payCycleName = payCycleName;
    }

    public String getPayShapeName() {
        return payShapeName;
    }

    public void setPayShapeName(String payShapeName) {
        this.payShapeName = payShapeName;
    }

    public String getPayTypeName() {
        return payTypeName;
    }

    public void setPayTypeName(String payTypeName) {
        this.payTypeName = payTypeName;
    }

    public String getSupplierNames() {
        return supplierNames;
    }

    public void setSupplierNames(String supplierNames) {
        this.supplierNames = supplierNames;
    }

    public String getSubLot() {
        return subLot;
    }

    public void setSubLot(String subLot) {
        this.subLot = subLot;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSubItemName() {
        return subItemName;
    }

    public void setSubItemName(String subItemName) {
        this.subItemName = subItemName;
    }

    public String getSubContent() {
        return subContent;
    }

    public void setSubContent(String subContent) {
        this.subContent = subContent;
    }

    public String getSubWayName() {
        return subWayName;
    }

    public void setSubWayName(String subWayName) {
        this.subWayName = subWayName;
    }

    public String getServiceTypeName() {
        return serviceTypeName;
    }

    public void setServiceTypeName(String serviceTypeName) {
        this.serviceTypeName = serviceTypeName;
    }

    public String getServiceContent() {
        return serviceContent;
    }

    public void setServiceContent(String serviceContent) {
        this.serviceContent = serviceContent;
    }

    public Integer getPlanPermissionType() {
        return planPermissionType;
    }

    public void setPlanPermissionType(Integer planPermissionType) {
        this.planPermissionType = planPermissionType;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getUsageCategoryId() {
        return usageCategoryId;
    }

    @ReferDeserialTransfer
    public void setUsageCategoryId(Long usageCategoryId) {
        this.usageCategoryId = usageCategoryId;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPurchaseDeployPlaceId() {
        return purchaseDeployPlaceId;
    }

    @ReferDeserialTransfer
    public void setPurchaseDeployPlaceId(Long purchaseDeployPlaceId) {
        this.purchaseDeployPlaceId = purchaseDeployPlaceId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPurchaseTypeId() {
        return purchaseTypeId;
    }

    @ReferDeserialTransfer
    public void setPurchaseTypeId(Long purchaseTypeId) {
        this.purchaseTypeId = purchaseTypeId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayCycleId() {
        return payCycleId;
    }

    @ReferDeserialTransfer
    public void setPayCycleId(Long payCycleId) {
        this.payCycleId = payCycleId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayShapeId() {
        return payShapeId;
    }

    @ReferDeserialTransfer
    public void setPayShapeId(Long payShapeId) {
        this.payShapeId = payShapeId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayTypeId() {
        return payTypeId;
    }

    @ReferDeserialTransfer
    public void setPayTypeId(Long payTypeId) {
        this.payTypeId = payTypeId;
    }

    public Long getTargetId() {
        return targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    public Long getTargetMainId() {
        return targetMainId;
    }

    public void setTargetMainId(Long targetMainId) {
        this.targetMainId = targetMainId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSubWayId() {
        return subWayId;
    }

    @ReferDeserialTransfer
    public void setSubWayId(Long subWayId) {
        this.subWayId = subWayId;
    }

    public Long getSubItemId() {
        return subItemId;
    }

    public void setSubItemId(Long subItemId) {
        this.subItemId = subItemId;
    }

    public Long getServiceTypeId() {
        return serviceTypeId;
    }

    public void setServiceTypeId(Long serviceTypeId) {
        this.serviceTypeId = serviceTypeId;
    }

}
