package com.ejianc.business.procurement.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.bean.CatalogCategoryEntity;
import com.ejianc.business.procurement.bean.CatalogItemEntity;
import com.ejianc.business.procurement.service.ICatalogCategoryService;
import com.ejianc.business.procurement.service.ICatalogItemService;
import com.ejianc.business.procurement.vo.CatalogCategoryVO;
import com.ejianc.business.procurement.vo.CatalogItemVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 一级集采目录-明细
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("catalogItem")
public class CatalogItemController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "CATALOG_ITEM_CODE";

    @Autowired
    private ICatalogItemService service;

    @Autowired
    private ICatalogCategoryService categoryService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CatalogItemVO> saveOrUpdate(@RequestBody CatalogItemVO saveOrUpdateVO) {
        CatalogItemEntity entity = BeanMapper.map(saveOrUpdateVO, CatalogItemEntity.class);
        if (StringUtils.isBlank(entity.getCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        CatalogItemVO vo = BeanMapper.map(entity, CatalogItemVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CatalogItemVO> queryDetail(Long id) {
        CatalogItemEntity entity = service.selectById(id);
        CatalogItemVO vo = BeanMapper.map(entity, CatalogItemVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CatalogItemVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CatalogItemVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CatalogItemVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CatalogItemVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<CatalogItemEntity> page = service.queryPage(param, false);
        IPage<CatalogItemVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CatalogItemVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<CatalogItemEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CatalogItem-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refCatalogItemData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CatalogItemVO>> refCatalogItemData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                   @RequestParam(required = false) String relyCondition,
                                                                   String condition,
                                                                   String searchObject,
                                                                   String searchText) {
        Map<String, Object> params = new HashMap<>();
        params.put("enabled", 1);
        if (StringUtils.isNotBlank(relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            CatalogCategoryEntity categoryEntity = categoryService.getById(categoryId);
            if (categoryEntity != null) {
                params.put("innerCode", categoryEntity.getInnerCode());
            }
        }
        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSON.parseObject(searchObject);
            if (search.get("code") != null) {
                params.put("code", search.get("code").toString());
            }
            if (search.get("name") != null) {
                params.put("name", search.get("name").toString());
            }
        }
        Page<CatalogItemVO> pageData = new Page<>(pageNumber, pageSize);
        List<CatalogItemVO> list = service.queryCatalogItemPageData(pageData, params);
        pageData.setRecords(list);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @RequestMapping(value = "/enableOrDisable", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> enableOrDisable(@RequestBody CatalogItemVO categoryVO) {
        if (categoryVO.getId() != null && categoryVO.getEnabled() != null) {
            LambdaUpdateWrapper<CatalogItemEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(CatalogItemEntity::getId, categoryVO.getId());
            updateWrapper.set(CatalogItemEntity::getEnabled, categoryVO.getEnabled());
            service.update(updateWrapper);
        }
        return CommonResponse.success("操作成功");
    }
}
