/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.bean.CatalogCategoryEntity;
import com.ejianc.business.procurement.bean.CatalogItemEntity;
import com.ejianc.business.procurement.service.ICatalogCategoryService;
import com.ejianc.business.procurement.service.ICatalogItemService;
import com.ejianc.business.procurement.vo.CatalogItemVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"catalogItem"})
public class CatalogItemController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "CATALOG_ITEM_CODE";
    @Autowired
    private ICatalogItemService service;
    @Autowired
    private ICatalogCategoryService categoryService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CatalogItemVO> saveOrUpdate(@RequestBody CatalogItemVO saveOrUpdateVO) {
        CatalogItemEntity entity = (CatalogItemEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CatalogItemEntity.class));
        if (StringUtils.isBlank((CharSequence)entity.getCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setCode((String)billCode.getData());
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            queryWrapper.eq(CatalogItemEntity::getCode, (Object)entity.getCode().trim());
            if (this.service.count((Wrapper)queryWrapper) > 0) {
                throw new BusinessException("\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        CatalogItemVO vo = (CatalogItemVO)BeanMapper.map((Object)((Object)entity), CatalogItemVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CatalogItemVO> queryDetail(Long id) {
        CatalogItemEntity entity = (CatalogItemEntity)((Object)this.service.selectById(id));
        CatalogItemVO vo = (CatalogItemVO)BeanMapper.map((Object)((Object)entity), CatalogItemVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CatalogItemVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CatalogItemVO catalogItemVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CatalogItemVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CatalogItemVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CatalogItem-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCatalogItemData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CatalogItemVO>> refCatalogItemData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String relyCondition, String condition, String searchObject, String searchText) {
        Long categoryId;
        CatalogCategoryEntity categoryEntity;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("enabled", 1);
        if (StringUtils.isNotBlank((CharSequence)relyCondition) && (categoryEntity = (CatalogCategoryEntity)((Object)this.categoryService.getById(categoryId = Long.valueOf(Long.parseLong(relyCondition.split("=")[1]))))) != null) {
            params.put("innerCode", categoryEntity.getInnerCode());
        }
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSON.parseObject((String)searchObject);
            if (search.get((Object)"code") != null) {
                params.put("code", search.get((Object)"code").toString());
            }
            if (search.get((Object)"name") != null) {
                params.put("name", search.get((Object)"name").toString());
            }
        }
        Page pageData = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        List<CatalogItemVO> list = this.service.queryCatalogItemPageData((Page<CatalogItemVO>)pageData, params);
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/enableOrDisable"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> enableOrDisable(@RequestBody CatalogItemVO categoryVO) {
        if (categoryVO.getId() != null && categoryVO.getEnabled() != null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)categoryVO.getId());
            updateWrapper.set(CatalogItemEntity::getEnabled, (Object)categoryVO.getEnabled());
            this.service.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

