package com.ejianc.business.procurement.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procurement.plan.bean.AnswerDetailEntity;
import com.ejianc.business.procurement.plan.bean.AnswerEntity;
import com.ejianc.business.procurement.plan.bean.ReplyDetailEntity;
import com.ejianc.business.procurement.plan.bean.ReplyEntity;
import com.ejianc.business.procurement.plan.service.IAnswerService;
import com.ejianc.business.procurement.plan.service.IReplyDetailService;
import com.ejianc.business.procurement.plan.service.IReplyService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@Service("answer") 
public class AnswerBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAnswerService answerService;
    @Autowired
    private IReplyService replyService;
    @Autowired
    private IReplyDetailService replyDetailService;

	@Autowired
	private IAttachmentApi attachmentApi;

	private static final String HW_BILL_CODE = "BT202512000002";//货物

	private static final String REPLY_HW_BILL_CODE = "BT202512000010";//待回复货物


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//生成待回复单据信息
		AnswerEntity answerEntity = answerService.selectById(billId);
		ReplyEntity replyEntity = BeanMapper.map(answerEntity, ReplyEntity.class);
		replyEntity.setId(IdWorker.getId());
		replyEntity.setBillState(0);
		replyEntity.setBillState(1);
		replyService.save(replyEntity);
		List<AnswerDetailEntity> answerDetailList = answerEntity.getAnswerDetailList();
		List<ReplyDetailEntity> replyDetailEntities = BeanMapper.mapList(answerDetailList, ReplyDetailEntity.class);
		for (ReplyDetailEntity replyDetailEntity : replyDetailEntities){
			replyDetailEntity.setSourceDetailId(replyDetailEntity.getId());
			replyDetailEntity.setId(IdWorker.getId());
			replyDetailEntity.setSourceId(answerEntity.getId());
            //复制疑问附件信息
			CommonResponse<String> responseCopy = attachmentApi.copyFilesFromSourceBillToTargetBill(
					replyDetailEntity.getSourceDetailId().toString(),
					HW_BILL_CODE,
					"answerYwFile",
					replyDetailEntity.getId().toString(),
					REPLY_HW_BILL_CODE,
					"replyYwFile"
			);
			if (!responseCopy.isSuccess()) {
				throw new BusinessException("招标立项向招标文件附件复制失败:" + responseCopy.getMsg());
			}

		}

		replyDetailService.saveBatch(replyDetailEntities);





		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
//		AnswerEntity answerEntity = answerService.selectById(billId);
		LambdaQueryWrapper<ReplyEntity> lambdaReply = Wrappers.<ReplyEntity>lambdaQuery();
		lambdaReply.eq(ReplyEntity::getSourceAnswerId, billId);
		ReplyEntity replyEntity = replyService.getOne(lambdaReply);
		if (replyEntity.getReplyStatus() == 2){
			return CommonResponse.error("下游已回复,不能撤回!");
		}



		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//删除下游数据
		LambdaQueryWrapper<ReplyEntity> lambdaReply = Wrappers.<ReplyEntity>lambdaQuery();
		lambdaReply.eq(ReplyEntity::getSourceAnswerId, billId);
		replyService.remove(lambdaReply);

		return CommonResponse.success();
	}

}
