/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.plan.bean.PurchasePlanDetailEntity;
import com.ejianc.business.procurement.plan.bean.PurchasePlanEntity;
import com.ejianc.business.procurement.plan.service.IPurchasePlanDetailService;
import com.ejianc.business.procurement.plan.service.IPurchasePlanService;
import com.ejianc.business.procurement.plan.vo.PurchasePlanDetailRefVO;
import com.ejianc.business.procurement.plan.vo.PurchasePlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchasePlan"})
public class PurchasePlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String HW_BILL_CODE = "PLAN_HW_CODE";
    private static final String GC_BILL_CODE = "PLAN_GC_CODE";
    private static final String FW_BILL_CODE = "PLAN_FW_CODE";
    @Autowired
    private IPurchasePlanService service;
    @Autowired
    private IPurchasePlanDetailService detailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchasePlanVO> saveOrUpdate(@RequestBody PurchasePlanVO saveOrUpdateVO) {
        PurchasePlanEntity entity = (PurchasePlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PurchasePlanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            String billcode = "";
            if ("1".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = GC_BILL_CODE;
            } else if ("2".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = HW_BILL_CODE;
            } else if ("3".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = FW_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)billcode, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PurchasePlanVO vo = (PurchasePlanVO)BeanMapper.map((Object)((Object)entity), PurchasePlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchasePlanVO> queryDetail(Long id) {
        PurchasePlanEntity entity = (PurchasePlanEntity)((Object)this.service.selectById(id));
        PurchasePlanVO vo = (PurchasePlanVO)BeanMapper.map((Object)((Object)entity), PurchasePlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchasePlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PurchasePlanVO purchasePlanVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchasePlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("allOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("planObject");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasePlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PurchasePlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryDetailList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<PurchasePlanDetailRefVO>> queryDetailList(@RequestBody List<Long> planIds) {
        ArrayList resList = new ArrayList();
        planIds.forEach(planId -> {
            PurchasePlanEntity planEntity = (PurchasePlanEntity)((Object)((Object)this.service.getById((Serializable)planId)));
            List detailList = new ArrayList();
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.eq(PurchasePlanDetailEntity::getPlanId, planId);
            lambdachange.eq(PurchasePlanDetailEntity::getAuthStatus, (Object)2);
            lambdachange.eq(PurchasePlanDetailEntity::getAllocateStatus, (Object)2);
            List entityList = this.detailService.list((Wrapper)lambdachange);
            if (CollectionUtils.isNotEmpty((Collection)entityList)) {
                detailList = BeanMapper.mapList((Iterable)entityList, PurchasePlanDetailRefVO.class);
                for (PurchasePlanDetailRefVO vo : detailList) {
                    vo.setBillCode(planEntity.getBillCode());
                    vo.setProjectName(planEntity.getProjectName());
                    vo.setAllOrgName(planEntity.getAllOrgName());
                    vo.setSpecialType(planEntity.getSpecialType());
                    vo.setSpecialCode(planEntity.getSpecialCode());
                    vo.setSpecialId(planEntity.getSpecialId());
                    vo.setSpecialMatter(planEntity.getSpecialMatter());
                    resList.add(vo);
                }
            }
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", resList);
    }

    @RequestMapping(value={"/refPurchasePlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchasePlanVO>> refPurchasePlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        Boolean flag = true;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"specialMatter")) {
                param.getParams().put("specialMatter", new Parameter("eq", _con.get((Object)"specialMatter")));
            }
            if (_con.containsKey((Object)"answer")) {
                flag = false;
            }
            if (_con.containsKey((Object)"unabnormal")) {
                param.getParams().put("abnormalStatus", new Parameter("eq", (Object)3));
            }
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (_con.containsKey((Object)"businessType")) {
                param.getParams().put("businessType", new Parameter("eq", _con.get((Object)"businessType")));
            }
            if (_con.containsKey((Object)"orgId")) {
                Long orgId = _con.getLong("orgId");
                param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        if (flag.booleanValue()) {
            param.getParams().put("specialStatus", new Parameter("eq", (Object)1));
            param.getParams().put("abnormalStatus", new Parameter("eq", (Object)1));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasePlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/purchasePlanRef"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PurchasePlanVO> purchasePlanRef(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("specialStatus", new Parameter("eq", (Object)1));
        param.getParams().put("abnormalStatus", new Parameter("eq", (Object)1));
        Boolean flag = true;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (_con.containsKey((Object)"auth")) {
                flag = false;
            }
            if (_con.containsKey((Object)"permissionType")) {
                param.getParams().put("permissionType", new Parameter("eq", _con.get((Object)"permissionType")));
            }
            if (_con.containsKey((Object)"businessType")) {
                param.getParams().put("businessType", new Parameter("eq", _con.get((Object)"businessType")));
            }
            if (_con.containsKey((Object)"orgId")) {
                Long orgId = _con.getLong("orgId");
                param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        if (flag.booleanValue()) {
            param.getParams().put("allocateStatus", new Parameter("eq", (Object)2));
        } else {
            param.getParams().put("authStatus", new Parameter("eq", (Object)2));
            param.getParams().put("allocateStatus", new Parameter("eq", (Object)2));
        }
        List dataList = this.service.queryList(param);
        List list = BeanMapper.mapList((Iterable)dataList, PurchasePlanVO.class);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (PurchasePlanVO vo : list) {
                vo.setName(vo.getBillCode());
            }
        }
        return list;
    }

    @RequestMapping(value={"/purchasePlanDetailsRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchasePlanDetailRefVO>> purchasePlanDetailsRef(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, @RequestParam(required=false) String relyCondition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        PurchasePlanEntity planEntity = new PurchasePlanEntity();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("authStatus", new Parameter("eq", (Object)2));
        param.getParams().put("allocateStatus", new Parameter("eq", (Object)2));
        Boolean flag = true;
        if (!StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5de6\u4fa7\u6570\u636e\uff01");
        }
        Long planId = Long.valueOf(relyCondition.split("=")[1]);
        param.getParams().put("planId", new Parameter("eq", (Object)planId));
        planEntity = (PurchasePlanEntity)((Object)this.service.selectById(planId));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"auth")) {
            flag = false;
        }
        if (flag.booleanValue()) {
            param.getParams().put("allocateStatus", new Parameter("eq", (Object)2));
        } else {
            param.getParams().put("authStatus", new Parameter("eq", (Object)2));
            param.getParams().put("allocateStatus", new Parameter("eq", (Object)2));
        }
        IPage page = this.detailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List resList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resList = BeanMapper.mapList((Iterable)page.getRecords(), PurchasePlanDetailRefVO.class);
            for (PurchasePlanDetailRefVO vo : resList) {
                vo.setBillCode(planEntity.getBillCode());
                vo.setProjectName(planEntity.getProjectName());
                vo.setAllOrgName(planEntity.getAllOrgName());
                vo.setSpecialType(planEntity.getSpecialType());
                vo.setSpecialCode(planEntity.getSpecialCode());
                vo.setSpecialId(planEntity.getSpecialId());
            }
        }
        pageData.setRecords(resList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

