package com.ejianc.business.procurement.plan.controller;

import java.io.Serializable;

import com.ejianc.business.procurement.plan.bean.PurchasePlanDetailEntity;
import com.ejianc.business.procurement.plan.bean.PurchasePlanEntity;
import com.ejianc.business.procurement.plan.service.IPurchasePlanDetailService;
import com.ejianc.business.procurement.plan.service.IPurchasePlanService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.procurement.plan.bean.AuthapplyEntity;
import com.ejianc.business.procurement.plan.service.IAuthapplyService;
import com.ejianc.business.procurement.plan.vo.AuthapplyVO;

/**
 * 采购计划授权实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("authapply")
public class AuthapplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String HW_APPLY_BILL_CODE = "APPLY_HW_CODE";
    private static final String GC_APPLY_BILL_CODE = "APPLY_GC_CODE";
    private static final String FW_APPLY_BILL_CODE = "APPLY_FW_CODE";

    private static final String HW_WT_BILL_CODE = "WT_HW_CODE";
    private static final String GC_WT_BILL_CODE = "WT_GC_CODE";
    private static final String FW_WT_BILL_CODE = "WT_FW_CODE";

    @Autowired
    private IAuthapplyService service;
    @Autowired
    private IPurchasePlanService planService;
    @Autowired
    private IPurchasePlanDetailService detailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AuthapplyVO> saveOrUpdate(@RequestBody AuthapplyVO saveOrUpdateVO) {
    	AuthapplyEntity entity = BeanMapper.map(saveOrUpdateVO, AuthapplyEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            String billcode = "";
            if("1".equals(saveOrUpdateVO.getAuthapplyType())){
                if("1".equals(saveOrUpdateVO.getBusinessType())){
                    billcode = GC_APPLY_BILL_CODE;
                }else if("2".equals(saveOrUpdateVO.getBusinessType())){
                    billcode = HW_APPLY_BILL_CODE;
                }else if("3".equals(saveOrUpdateVO.getBusinessType())){
                    billcode = FW_APPLY_BILL_CODE;
                }
            }else{
                if("1".equals(saveOrUpdateVO.getBusinessType())){
                    billcode = GC_WT_BILL_CODE;
                }else if("2".equals(saveOrUpdateVO.getBusinessType())){
                    billcode = HW_WT_BILL_CODE;
                }else if("3".equals(saveOrUpdateVO.getBusinessType())){
                    billcode = FW_WT_BILL_CODE;
                }
            }
            BillCodeParam billCodeParam = BillCodeParam.build(billcode,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //将计划子表改为已授权
        if(CollectionUtils.isNotEmpty(saveOrUpdateVO.getAuthapplyDetailList())){
            Map<String,List<String>> map = new HashMap<>();
            Map<String,List<String>> delMap = new HashMap<>();
            saveOrUpdateVO.getAuthapplyDetailList().forEach(e->{
                if("del".equals(e.getRowState())){
                    if(delMap.containsKey(e.getSourceBillId())){
                        List<String> list = delMap.get(e.getSourceBillId());
                        list.add(e.getSourceId());
                        delMap.put(e.getSourceBillId(),list);
                    }else{
                        List<String> list = new ArrayList<>();
                        list.add(e.getSourceId());
                        delMap.put(e.getSourceBillId(),list);
                    }
                }else{
                    if(map.containsKey(e.getSourceBillId())){
                        List<String> list = map.get(e.getSourceBillId());
                        list.add(e.getSourceId());
                        map.put(e.getSourceBillId(),list);
                    }else{
                        List<String> list = new ArrayList<>();
                        list.add(e.getSourceId());
                        map.put(e.getSourceBillId(),list);
                    }
                }
            });
            if(null!=map&&!map.isEmpty()){
                for(String key:map.keySet()){
                    List<String> detailList = map.get(key);
                   PurchasePlanEntity planEntity =  planService.selectById(key);
                    planEntity.getPurchasePlanDetailList().forEach(e->{
                        if(detailList.contains(e.getId().toString())){
                            e.setAuthStatus(1);
                        }
                    });
                    Boolean flag = true;
                    for(PurchasePlanDetailEntity detailEntity:planEntity.getPurchasePlanDetailList()){
                        if(2==detailEntity.getAuthStatus()){
                            flag = false;
                        }
                    }
                    if(flag){
                        //如果子表全部已分配，则需要将主表也改为已分配
                        planEntity.setAuthStatus(1);
                    }
                    planService.updateById(planEntity);
                }
            }

            if(null!=delMap&&!delMap.isEmpty()){
                for(String key:delMap.keySet()){
                    List<String> detailList = delMap.get(key);
                    PurchasePlanEntity planEntity =  planService.selectById(key);
                    planEntity.getPurchasePlanDetailList().forEach(e->{
                        if(detailList.contains(e.getId().toString())){
                            e.setAuthStatus(2);
                        }
                    });
                    planEntity.setAuthStatus(2);
                    planService.updateById(planEntity);
                }
            }


        }

    	service.saveOrUpdate(entity, false);
    	AuthapplyVO vo = BeanMapper.map(entity, AuthapplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AuthapplyVO> queryDetail(Long id) {
    	AuthapplyEntity entity = service.selectById(id);
    	AuthapplyVO vo = BeanMapper.map(entity, AuthapplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AuthapplyVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            Map<String,List<String>> delMap = new HashMap<>();
            for (AuthapplyVO vo : vos) {
                AuthapplyEntity entity = service.selectById(vo.getId());
                entity.getAuthapplyDetailList().forEach(e->{
                    if(delMap.containsKey(e.getSourceBillId())){
                        List<String> list = delMap.get(e.getSourceBillId());
                        list.add(e.getSourceId());
                        delMap.put(e.getSourceBillId(),list);
                    }else{
                        List<String> list = new ArrayList<>();
                        list.add(e.getSourceId());
                        delMap.put(e.getSourceBillId(),list);
                    }
                });
            }
            if(null!=delMap&&!delMap.isEmpty()){
                for(String key:delMap.keySet()){
                    List<String> detailList = delMap.get(key);
                    PurchasePlanEntity planEntity =  planService.selectById(key);
                    planEntity.getPurchasePlanDetailList().forEach(e->{
                        if(detailList.contains(e.getId().toString())){
                            e.setAuthStatus(2);
                        }
                    });
                    planEntity.setAuthStatus(2);
                    planService.updateById(planEntity);
                }
            }
        }
        service.removeByIds(vos.stream().map(AuthapplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AuthapplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<AuthapplyEntity> page = service.queryPage(param,false);
        IPage<AuthapplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AuthapplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AuthapplyEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Authapply-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refAuthapplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AuthapplyVO>> refAuthapplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AuthapplyEntity> page = service.queryPage(param,false);
        IPage<AuthapplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AuthapplyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
