package com.ejianc.business.procurement.plan.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.procurement.plan.bean.ExecutePlanDetailEntity;
/**
 * 采购执行计划
 * 
 * @author generator
 * 
 */
 @TableName("ejc_procurement_execute_plan")
public class ExecutePlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="ctrl_tax_mny")
    private BigDecimal ctrlTaxMny; // 控制含税总额
    @TableField(value="pre_tax_mny")
    private BigDecimal preTaxMny; // 预估含税总额
    @TableField(value="bid_tax_mny")
    private BigDecimal bidTaxMny; // 投标含税总额
    @TableField(value="make_date")
    private Date makeDate; // 编制日期
    @TableField(value="bill_code")
    private String billCode; // 执行计划编号
    @TableField(value="org_name")
    private String orgName; // 采购实施单位名称
    @TableField(value="org_code")
    private String orgCode; // 采购实施单位编码
    @TableField(value="all_org_name")
    private String allOrgName; // 所属组织(所属单位-项目经理部)
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="business_type")
    private String businessType; // 业务类别1-工程，2-货物，3-服务
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="name")
    private String name; // 执行计划名称
    @TableField(value="purchase_type")
    private String purchaseType; // 采购方式：1-带量；2-入围；3-框架
    @TableField(value="purchase_stage")
    private String purchaseStage; // 入围阶段：1-一阶段；2-二阶段
    @TableField(value="stage_one_result_name")
    private String stageOneResultName; // 一阶段入围计划结果（参照定标结果）
    @TableField(value="purchase_plan_code")
    private String purchasePlanCode; // 一阶段采购计划编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="permission_type")
    private Integer permissionType; // 实施流程 1-一级集采，2-二级集采，3-所属单位，4-项目经理部
    @TableField(value="abnormal_status")
    private Integer abnormalStatus; // 计划异常状态 1-正常，2-取消采购，3-暂停采购
    @TableField(value="org_id")
    private Long orgId; // 采购实施单位Id
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="stage_one_result_id")
    private Long stageOneResultId; // 一阶段入围计划结果id（参照定标结果）
    @TableField(value="purchase_plan_id")
    private Long purchasePlanId; // 一阶段采购计划id
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="executePlanDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<ExecutePlanDetailEntity> executePlanDetailList = new ArrayList<>(); // 采购执行计划-明细
    

    public BigDecimal getCtrlTaxMny() {
        return ctrlTaxMny;
    }

    public void setCtrlTaxMny(BigDecimal ctrlTaxMny) {
        this.ctrlTaxMny = ctrlTaxMny;
    }
    public BigDecimal getPreTaxMny() {
        return preTaxMny;
    }

    public void setPreTaxMny(BigDecimal preTaxMny) {
        this.preTaxMny = preTaxMny;
    }
    public BigDecimal getBidTaxMny() {
        return bidTaxMny;
    }

    public void setBidTaxMny(BigDecimal bidTaxMny) {
        this.bidTaxMny = bidTaxMny;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getAllOrgName() {
        return allOrgName;
    }

    public void setAllOrgName(String allOrgName) {
        this.allOrgName = allOrgName;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getPurchaseStage() {
        return purchaseStage;
    }

    public void setPurchaseStage(String purchaseStage) {
        this.purchaseStage = purchaseStage;
    }
    public String getStageOneResultName() {
        return stageOneResultName;
    }

    public void setStageOneResultName(String stageOneResultName) {
        this.stageOneResultName = stageOneResultName;
    }
    public String getPurchasePlanCode() {
        return purchasePlanCode;
    }

    public void setPurchasePlanCode(String purchasePlanCode) {
        this.purchasePlanCode = purchasePlanCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getPermissionType() {
        return permissionType;
    }

    public void setPermissionType(Integer permissionType) {
        this.permissionType = permissionType;
    }
    public Integer getAbnormalStatus() {
        return abnormalStatus;
    }

    public void setAbnormalStatus(Integer abnormalStatus) {
        this.abnormalStatus = abnormalStatus;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Long getStageOneResultId() {
        return stageOneResultId;
    }

    public void setStageOneResultId(Long stageOneResultId) {
        this.stageOneResultId = stageOneResultId;
    }
    public Long getPurchasePlanId() {
        return purchasePlanId;
    }

    public void setPurchasePlanId(Long purchasePlanId) {
        this.purchasePlanId = purchasePlanId;
    }
    
    public List<ExecutePlanDetailEntity> getExecutePlanDetailList() {
        return executePlanDetailList;
    }

    public void setExecutePlanDetailList(List<ExecutePlanDetailEntity> executePlanDetailList) {
        this.executePlanDetailList = executePlanDetailList;
    }
}
