package com.ejianc.business.procurement.plan.service.impl;

import com.ejianc.business.procurement.plan.bean.PurchaseStrategyChangeEntity;
import com.ejianc.business.procurement.plan.bean.PurchaseStrategyEntity;
import com.ejianc.business.procurement.plan.bean.PurchaseStrategyRecordEntity;
import com.ejianc.business.procurement.plan.mapper.PurchaseStrategyMapper;
import com.ejianc.business.procurement.plan.service.IPurchaseStrategyChangeService;
import com.ejianc.business.procurement.plan.service.IPurchaseStrategyRecordService;
import com.ejianc.business.procurement.plan.service.IPurchaseStrategyService;
import com.ejianc.business.procurement.plan.vo.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.fieldCompare.CompareDifferenceUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 采购策划
 *
 * @author generator
 *
 */
@Service("purchaseStrategyService")
public class PurchaseStrategyServiceImpl extends BaseServiceImpl<PurchaseStrategyMapper, PurchaseStrategyEntity> implements IPurchaseStrategyService {


    @Autowired
    private IPurchaseStrategyRecordService recordService;

    @Autowired
    private IPurchaseStrategyChangeService changeService;

    @Override
    public List<PurchaseStrategyChangeDetailVO> compareDetail(Long id, Long historyId) {
        PurchaseStrategyRecordEntity recordEntity = recordService.selectById(historyId);
        PurchaseStrategyChangeEntity changeEntity = changeService.selectById(recordEntity.getCurChangingPlanId());
        PurchaseStrategyChangeVO vo = BeanMapper.map(changeEntity, PurchaseStrategyChangeVO.class);
        List<PurchaseStrategyChangeDetailVO> detailList = vo.getPurchaseStrategyDetailList();
        PurchaseStrategyRecordVO recordVO = BeanMapper.map(recordEntity, PurchaseStrategyRecordVO.class);
        List<PurchaseStrategyRecordDetailVO> list = recordVO.getPurchaseStrategyDetailList();
        if (CollectionUtils.isNotEmpty(list)) {
            CompareDifferenceUtil.compareList(list, detailList, true);
        }
        return detailList;
    }
}
