/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.plan.service.impl;

import com.ejianc.business.procurement.plan.bean.YearBudgetDetailEntity;
import com.ejianc.business.procurement.plan.bean.YearBudgetEntity;
import com.ejianc.business.procurement.plan.mapper.YearBudgetMapper;
import com.ejianc.business.procurement.plan.service.IYearBudgetDetailService;
import com.ejianc.business.procurement.plan.service.IYearBudgetService;
import com.ejianc.business.procurement.plan.vo.YearBudgetDetailVO;
import com.ejianc.business.procurement.plan.vo.YearBudgetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="yearBudgetService")
public class YearBudgetServiceImpl
extends BaseServiceImpl<YearBudgetMapper, YearBudgetEntity>
implements IYearBudgetService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "YEAR_BUDGET_CODE";
    @Autowired
    private IYearBudgetDetailService detailService;

    @Override
    public YearBudgetVO insertOrUpdate(YearBudgetVO vo) {
        if (StringUtils.isBlank((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                vo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        YearBudgetEntity entity = (YearBudgetEntity)((Object)BeanMapper.map((Object)vo, YearBudgetEntity.class));
        boolean b = this.saveOrUpdateNoES((Object)entity);
        List<YearBudgetDetailEntity> detailEntityList = entity.getYearBudgetDetailList();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (YearBudgetDetailEntity cdEntity : detailEntityList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (YearBudgetDetailEntity cdEntity : detailEntityList) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.detailService.saveOrUpdateBatch(detailEntityList);
        }
        return this.queryDetail(entity.getId());
    }

    @Override
    public YearBudgetVO queryDetail(Long id) {
        YearBudgetEntity entity = (YearBudgetEntity)((Object)super.selectById((Serializable)id));
        YearBudgetVO vo = (YearBudgetVO)BeanMapper.map((Object)((Object)entity), YearBudgetVO.class);
        List detailList = vo.getYearBudgetDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (YearBudgetDetailVO detailVo : detailList) {
                detailVo.setTid(vo.getId().toString());
                detailVo.setTpid(detailVo.getParentId() != null && detailVo.getParentId() > 0L ? detailVo.getParentId().toString() : "");
                detailVo.setRowState("edit");
            }
            List detailMapList = BeanMapper.mapList((Iterable)detailList, Map.class);
            List resultList = BeanMapper.mapList((Iterable)detailMapList, YearBudgetDetailVO.class);
            vo.setYearBudgetDetailList(resultList);
        }
        return vo;
    }
}

