package com.ejianc.business.procurement.plan.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procurement.plan.bean.UnTenderMatterEntity;
import com.ejianc.business.procurement.plan.bean.YearBudgetDetailEntity;
import com.ejianc.business.procurement.plan.service.IYearBudgetDetailService;
import com.ejianc.business.procurement.plan.vo.YearBudgetDetailVO;
import com.ejianc.business.procurement.plan.vo.YearBudgetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.procurement.plan.mapper.YearBudgetMapper;
import com.ejianc.business.procurement.plan.bean.YearBudgetEntity;
import com.ejianc.business.procurement.plan.service.IYearBudgetService;

import java.util.*;

/**
 * 年度预算
 * 
 * @author generator
 * 
 */
@Service("yearBudgetService")
public class YearBudgetServiceImpl extends BaseServiceImpl<YearBudgetMapper, YearBudgetEntity> implements IYearBudgetService{
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "YEAR_BUDGET_CODE";//此处需要根据实际修改
    @Autowired
    private IYearBudgetDetailService detailService;

    @Override
    public YearBudgetVO insertOrUpdate(YearBudgetVO vo) {
        LambdaQueryWrapper<YearBudgetEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(YearBudgetEntity::getProjectId,vo.getProjectId())
                .ne(null != vo.getId(),YearBudgetEntity::getId,vo.getId())
                .apply("DATE_FORMAT (create_time,'%Y')="+ DateUtil.format(new Date(),"YYYY"))
                .eq(YearBudgetEntity::getTenantId, InvocationInfoProxy.getTenantid());
        int count = super.count(lambdaQueryWrapper);
        if (count>0){
            throw new BusinessException("该项目本年度已存在业务单据");
        }
        if (StringUtils.isBlank(vo.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                vo.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        YearBudgetEntity entity = BeanMapper.map(vo, YearBudgetEntity.class);
        boolean b = this.saveOrUpdateNoES(entity);
        List<YearBudgetDetailEntity> detailEntityList = entity.getYearBudgetDetailList();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (YearBudgetDetailEntity cdEntity : detailEntityList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (YearBudgetDetailEntity cdEntity : detailEntityList) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            detailService.saveOrUpdateBatch(detailEntityList);
        }
        return queryDetail(entity.getId());
    }

    @Override
    public YearBudgetVO queryDetail(Long id) {
        YearBudgetEntity entity = super.selectById(id);
        YearBudgetVO vo = BeanMapper.map(entity, YearBudgetVO.class);
        List<YearBudgetDetailVO> detailList = vo.getYearBudgetDetailList();
        if (CollectionUtils.isNotEmpty(detailList)){
            for (YearBudgetDetailVO detailVo : detailList) {
                detailVo.setTid(detailVo.getId().toString());
                detailVo.setTpid(detailVo.getParentId() != null && detailVo.getParentId() > 0 ? detailVo.getParentId().toString() : "");
                detailVo.setRowState("edit");
            }
            sortIntMethod(detailList);
            vo.setYearBudgetDetailList(createTreeData(detailList));
        }
        return vo;

    }
    private static void sortIntMethod(List<YearBudgetDetailVO> list) {
        Collections.sort(list, new Comparator() {
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                YearBudgetDetailVO o1Detail = objectMapper.convertValue(o1, YearBudgetDetailVO.class);
                YearBudgetDetailVO o2Detail = objectMapper.convertValue(o2, YearBudgetDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                String[] strs2 = o2Detail.getTreeIndex().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }
    public static List<YearBudgetDetailVO> createTreeData(List<YearBudgetDetailVO> list) {
        List<YearBudgetDetailVO> resp = new ArrayList<>();
        List<Long> rootItems = new ArrayList<Long>();

        //循环list，放入listMap重
        Map<Long, YearBudgetDetailVO> listMap = new HashMap<>();
        for(YearBudgetDetailVO item:list) {
            listMap.put(item.getId(), item);
        }

        for(int i =0; i<list.size(); i++) {
            YearBudgetDetailVO item = list.get(i);
            Long parentId = item.getParentId();
            YearBudgetDetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<YearBudgetDetailVO> child = parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<YearBudgetDetailVO> children = new ArrayList<>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getId());
            }
        }

        for(Long rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

}
