/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.perform.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.consts.BusinessTypeEnum;
import com.ejianc.business.procurement.perform.bean.ExpertExtractionEntity;
import com.ejianc.business.procurement.perform.bean.PurchaseProjectEntity;
import com.ejianc.business.procurement.perform.service.IExpertExtractionMemberService;
import com.ejianc.business.procurement.perform.service.IExpertExtractionService;
import com.ejianc.business.procurement.perform.service.IPurchaseProjectService;
import com.ejianc.business.procurement.perform.vo.ExpertExtractionMemberVO;
import com.ejianc.business.procurement.perform.vo.ExpertExtractionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"expertExtraction"})
public class ExpertExtractionController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IExpertExtractionService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPurchaseProjectService purchaseProjectService;
    @Autowired
    private IExpertExtractionMemberService memberService;
    private static Map<String, String> codeRuleMap = new HashMap<String, String>();

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ExpertExtractionVO> saveOrUpdate(@RequestBody ExpertExtractionVO saveOrUpdateVO) {
        boolean b;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ExpertExtractionEntity::getPurchaseProjectId, (Object)saveOrUpdateVO.getPurchaseProjectId());
        wrapper.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        if (this.service.count((Wrapper)wrapper) > 0) {
            return CommonResponse.error((String)"\u8be5\u91c7\u8d2d\u9879\u76ee\u5df2\u5b58\u5728\u4e00\u6761\u4e13\u5bb6\u62bd\u53d6\u8bb0\u5f55\uff01");
        }
        ExpertExtractionEntity entity = (ExpertExtractionEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ExpertExtractionEntity.class));
        if (StringUtils.isBlank((CharSequence)saveOrUpdateVO.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)codeRuleMap.get(saveOrUpdateVO.getBusinessType()), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if ((b = this.service.saveOrUpdate((Object)entity, false)) && entity.getPurchaseProjectId() != null) {
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getPurchaseProjectId());
            updateWrapper.set(PurchaseProjectEntity::getExpertFlag, (Object)1);
            this.purchaseProjectService.update((Wrapper)updateWrapper);
        }
        ExpertExtractionVO vo = (ExpertExtractionVO)BeanMapper.map((Object)((Object)entity), ExpertExtractionVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ExpertExtractionVO> queryDetail(Long id) {
        ExpertExtractionEntity entity = (ExpertExtractionEntity)((Object)this.service.selectById(id));
        ExpertExtractionVO vo = (ExpertExtractionVO)BeanMapper.map((Object)((Object)entity), ExpertExtractionVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExpertExtractionVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ExpertExtractionVO expertExtractionVO : vos) {
            }
        }
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        List extractionEntities = (List)this.service.listByIds(ids);
        ArrayList<Long> purchaseProjectIs = new ArrayList<Long>();
        for (ExpertExtractionEntity extractionEntity : extractionEntities) {
            Long purchaseProjectId = extractionEntity.getPurchaseProjectId();
            if (purchaseProjectId == null) continue;
            purchaseProjectIs.add(purchaseProjectId);
        }
        if (CollectionUtils.isNotEmpty(purchaseProjectIs)) {
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.in(BaseEntity::getId, purchaseProjectIs);
            updateWrapper.set(PurchaseProjectEntity::getExpertFlag, (Object)0);
            this.purchaseProjectService.update((Wrapper)updateWrapper);
        }
        this.service.removeByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ExpertExtractionVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "purchaseProjectName", "orgName", "executePlanCode"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpertExtractionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "purchaseProjectName", "orgName", "executePlanCode"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("ExpertExtraction-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refExpertExtractionData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ExpertExtractionVO>> refExpertExtractionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpertExtractionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refExpertExtractionMemberData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ExpertExtractionMemberVO>> refExpertExtractionMemberData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long pid = 1L;
        ExpertExtractionEntity expertExtractionEntity = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"purchaseProjectId")) {
                Long purchaseProjectId = Long.valueOf(_con.get((Object)"purchaseProjectId").toString());
                LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
                wrapper.eq(ExpertExtractionEntity::getPurchaseProjectId, (Object)purchaseProjectId);
                wrapper.in(ExpertExtractionEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
                List list = this.service.list((Wrapper)wrapper);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    expertExtractionEntity = (ExpertExtractionEntity)((Object)list.get(0));
                    pid = expertExtractionEntity.getId();
                }
            }
            if (_con.containsKey((Object)"inStore")) {
                param.getParams().put("inStore", new Parameter("eq", _con.get((Object)"inStore")));
            }
        }
        param.getParams().put("pid", new Parameter("eq", (Object)pid));
        IPage page = this.memberService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List expertExtractionMemberVOS = BeanMapper.mapList((Iterable)page.getRecords(), ExpertExtractionMemberVO.class);
        if (expertExtractionEntity != null) {
            for (ExpertExtractionMemberVO memberVO : expertExtractionMemberVOS) {
                memberVO.setStartDate(expertExtractionEntity.getStartDate());
            }
        }
        pageData.setRecords(expertExtractionMemberVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    static {
        codeRuleMap.put(BusinessTypeEnum.HUO_WU.getCode(), "EXPERT_EXTRACTION_CODE");
        codeRuleMap.put(BusinessTypeEnum.GONG_CHENG.getCode(), "EXPERT_EXTRACTION_GC_CODE");
        codeRuleMap.put(BusinessTypeEnum.FU_WU.getCode(), "EXPERT_EXTRACTION_FW_CODE");
    }
}

