package com.ejianc.business.procurement.perform.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procurement.perform.bean.FileSuperviseEntity;
import com.ejianc.business.procurement.perform.bean.PurchaseProjectEntity;
import com.ejianc.business.procurement.perform.service.IFileSuperviseService;
import com.ejianc.business.procurement.perform.service.IPurchaseProjectService;
import com.ejianc.business.procurement.perform.vo.CandidateSuperviseVO;
import com.ejianc.business.procurement.perform.vo.PurchaseProjectVO;
import com.ejianc.business.procurement.perform.vo.ResultDetailVO;
import com.ejianc.business.procurement.utils.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.procurement.perform.bean.CandidateEntity;
import com.ejianc.business.procurement.perform.service.ICandidateService;
import com.ejianc.business.procurement.perform.vo.CandidateVO;

/**
 * 成交候选人确认
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("candidate")
public class CandidateController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String HW_BILL_CODE = "HW-CANDIDATE-CODE";
    private static final String GC_BILL_CODE = "GC-CANDIDATE-CODE";
    private static final String FW_BILL_CODE = "FW-CANDIDATE-CODE";

    @Autowired
    private ICandidateService service;

    @Autowired
    private IPurchaseProjectService purchaseProjectService;
    @Autowired
    private IFileSuperviseService fileSuperviseService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CandidateVO> saveOrUpdate(@RequestBody CandidateVO saveOrUpdateVO) {
        LambdaQueryWrapper<CandidateEntity> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(CandidateEntity::getPurchaseProjectId, saveOrUpdateVO.getPurchaseProjectId());
        wrapper.ne(saveOrUpdateVO.getId() != null, CandidateEntity::getId, saveOrUpdateVO.getId());
        if (service.count(wrapper) > 0) {
            return CommonResponse.error("该采购项目已存在一条成交候选人单据，不允许重复添加！");
        }
        saveOrUpdateVO.sumDetailList();
    	CandidateEntity entity = BeanMapper.map(saveOrUpdateVO, CandidateEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            String billcode = "";
            if("1".equals(saveOrUpdateVO.getBusinessType())){
                billcode = GC_BILL_CODE;
            }else if("2".equals(saveOrUpdateVO.getBusinessType())){
                billcode = HW_BILL_CODE;
            }else if("3".equals(saveOrUpdateVO.getBusinessType())){
                billcode = FW_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam.build(billcode,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	CandidateVO vo = BeanMapper.map(entity, CandidateVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CandidateVO> queryDetail(Long id) {
    	CandidateEntity entity = service.selectById(id);
    	CandidateVO vo = BeanMapper.map(entity, CandidateVO.class);
        vo.splitDetailList();
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description
     * @param purchaseProjectId
     */
    @RequestMapping(value = "/queryDetailByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CandidateVO> queryDetailByProjectId(Long purchaseProjectId,Long id) {
        LambdaQueryWrapper<CandidateEntity> candidatewrapper = Wrappers.lambdaQuery();
        candidatewrapper.eq(CandidateEntity::getPurchaseProjectId, purchaseProjectId);
        candidatewrapper.ne(id != null, CandidateEntity::getId, id);
        if (service.count(candidatewrapper) > 0) {
            return CommonResponse.error("该采购项目已存在一条成交候选人单据，不允许重复添加！");
        }

        CandidateVO vo = new CandidateVO();
        List<CandidateSuperviseVO> candidateSuperviseList = new ArrayList<>();
        PurchaseProjectEntity purchaseProjectEntity = purchaseProjectService.selectById(purchaseProjectId);
        //监督记录情况表
        LambdaQueryWrapper<FileSuperviseEntity> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(FileSuperviseEntity::getEnabled, true);
        wrapper.eq(FileSuperviseEntity::getKeyLink, "成交候选人确认");
        List<FileSuperviseEntity> fileSuperviseEntityList = fileSuperviseService.list(wrapper);
        fileSuperviseEntityList.forEach(e->{
            CandidateSuperviseVO candidateSuperviseVO = new CandidateSuperviseVO();
            candidateSuperviseVO.setContentId(e.getId());
            candidateSuperviseVO.setContent(e.getContent());
            candidateSuperviseList.add(candidateSuperviseVO);
        });
        vo.setCandidateSuperviseList(candidateSuperviseList);
        //区分招标非招标
        if("2".equals(purchaseProjectEntity.getPerformWay())){
            //非招标  子表来源 上游的评审汇总
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CandidateVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (CandidateVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CandidateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CandidateVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<CandidateEntity> page = service.queryPage(param,false);
        IPage<CandidateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CandidateVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CandidateEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Candidate-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refCandidateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CandidateVO>> refCandidateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CandidateEntity> page = service.queryPage(param,false);
        IPage<CandidateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CandidateVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
