/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.perform.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.consts.BusinessTypeEnum;
import com.ejianc.business.procurement.perform.bean.PurchaseProjectAnswerEntity;
import com.ejianc.business.procurement.perform.bean.PurchaseProjectConfirmEntity;
import com.ejianc.business.procurement.perform.bean.PurchaseProjectEntity;
import com.ejianc.business.procurement.perform.consts.BusinessStateEnum;
import com.ejianc.business.procurement.perform.consts.NobidMethodEnum;
import com.ejianc.business.procurement.perform.service.IPurchaseProjectAnswerService;
import com.ejianc.business.procurement.perform.service.IPurchaseProjectConfirmService;
import com.ejianc.business.procurement.perform.service.IPurchaseProjectDetailService;
import com.ejianc.business.procurement.perform.service.IPurchaseProjectService;
import com.ejianc.business.procurement.perform.service.IPurchaseProjectSupplierService;
import com.ejianc.business.procurement.perform.vo.ExpertExtractionVO;
import com.ejianc.business.procurement.perform.vo.PurchaseProjectDetailVO;
import com.ejianc.business.procurement.perform.vo.PurchaseProjectSupplierVO;
import com.ejianc.business.procurement.perform.vo.PurchaseProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchaseProject"})
public class PurchaseProjectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPurchaseProjectService service;
    @Autowired
    private IPurchaseProjectDetailService detailService;
    @Autowired
    private IPurchaseProjectSupplierService supplierService;
    @Autowired
    private IPurchaseProjectConfirmService confirmService;
    @Autowired
    private IPurchaseProjectAnswerService answerService;
    @Autowired
    private SessionManager sessionManager;
    private static Map<String, String> codeRuleMap = new HashMap<String, String>();

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseProjectVO> saveOrUpdate(@RequestBody PurchaseProjectVO saveOrUpdateVO) {
        List<PurchaseProjectAnswerEntity> answerList;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(PurchaseProjectEntity::getExecutePlanId, (Object)saveOrUpdateVO.getExecutePlanId());
        wrapper.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        wrapper.ne(PurchaseProjectEntity::getBusinessState, (Object)BusinessStateEnum.CHONG_XIN.getCode());
        if (this.service.count((Wrapper)wrapper) > 0) {
            return CommonResponse.error((String)"\u8be5\u6267\u884c\u8ba1\u5212\u5df2\u5b58\u5728\u4e00\u6761\u91c7\u8d2d\u9879\u76ee\uff01");
        }
        if (StringUtils.isBlank((CharSequence)saveOrUpdateVO.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)codeRuleMap.get(saveOrUpdateVO.getBusinessType()), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        saveOrUpdateVO.sumDetailList();
        PurchaseProjectEntity entity = (PurchaseProjectEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PurchaseProjectEntity.class));
        if (entity.getId() == null) {
            entity.setExpertFlag(0);
            entity.setDirectFlag(0);
        }
        entity.setBusinessState(Optional.ofNullable(entity.getBusinessState()).orElse(BusinessStateEnum.ZHENG_CHANG.getCode()));
        this.service.saveOrUpdate((Object)entity, false);
        List<PurchaseProjectConfirmEntity> confirmList = entity.getConfirmList();
        if (CollectionUtils.isNotEmpty(confirmList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (PurchaseProjectConfirmEntity cdEntity : confirmList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (PurchaseProjectConfirmEntity cdEntity : confirmList) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.confirmService.saveOrUpdateBatch(confirmList);
        }
        if (CollectionUtils.isNotEmpty(answerList = entity.getAnswerList())) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (PurchaseProjectAnswerEntity cdEntity : answerList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (PurchaseProjectAnswerEntity cdEntity : answerList) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.answerService.saveOrUpdateBatch(answerList);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.queryDetailById(entity.getId()));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseProjectVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetailById(id));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseProjectVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PurchaseProjectVO purchaseProjectVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchaseProjectVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "name", "orgName", "executePlanCode"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryExist"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> queryExist(@RequestBody ExpertExtractionVO saveOrUpdateVO) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(PurchaseProjectEntity::getExecutePlanId, (Object)saveOrUpdateVO.getExecutePlanId());
        wrapper.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        wrapper.ne(PurchaseProjectEntity::getBusinessState, (Object)BusinessStateEnum.CHONG_XIN.getCode());
        if (this.service.count((Wrapper)wrapper) > 0) {
            return CommonResponse.error((String)"\u8be5\u6267\u884c\u8ba1\u5212\u5df2\u5b58\u5728\u4e00\u6761\u91c7\u8d2d\u9879\u76ee\uff01");
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "name", "orgName", "executePlanCode"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, PurchaseProjectVO.class);
        for (PurchaseProjectVO vo : voList) {
            Integer businessState;
            Integer processType;
            Integer permissionType = vo.getPermissionType();
            if (permissionType != null) {
                if (permissionType == 1) {
                    vo.setPermissionTypeName("\u4e00\u7ea7\u96c6\u91c7");
                } else if (permissionType == 2) {
                    vo.setPermissionTypeName("\u4e8c\u7ea7\u96c6\u91c7");
                } else if (permissionType == 3) {
                    vo.setPermissionTypeName("\u6240\u5c5e\u5355\u4f4d");
                } else if (permissionType == 4) {
                    vo.setPermissionTypeName("\u9879\u76ee\u7ecf\u7406\u90e8");
                }
            }
            if ((processType = vo.getProcessType()) == 1) {
                vo.setProcessTypeName("\u5e73\u53f0\u5168\u6d41\u7a0b");
            } else if (processType == 2) {
                vo.setProcessTypeName("\u5e73\u53f0\u534a\u6d41\u7a0b");
            } else if (processType == 3) {
                vo.setProcessTypeName("\u5168\u7ebf\u4e0b");
            }
            Integer nobidMethod = vo.getNobidMethod();
            if (nobidMethod != null) {
                vo.setNobidMethodName(NobidMethodEnum.getNameByCode((Integer)nobidMethod));
            }
            if ((businessState = vo.getBusinessState()) == null) continue;
            vo.setBusinessStateName(BusinessStateEnum.getNameByCode((Integer)businessState));
        }
        beans.put("records", voList);
        ExcelExport.getInstance().exportWithTrans("PurchaseProject-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPurchaseProjectData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchaseProjectVO>> refPurchaseProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("businessState", new Parameter("eq", (Object)BusinessStateEnum.ZHENG_CHANG.getCode()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"businessType")) {
                param.getParams().put("businessType", new Parameter("eq", _con.get((Object)"businessType")));
            }
            if (_con.containsKey((Object)"businessState")) {
                param.getParams().put("businessState", new Parameter("in", _con.get((Object)"businessState")));
            }
            if (_con.containsKey((Object)"expertFlag")) {
                param.getParams().put("expertFlag", new Parameter("eq", _con.get((Object)"expertFlag")));
            }
            if (_con.containsKey((Object)"directFlag")) {
                param.getParams().put("directFlag", new Parameter("eq", _con.get((Object)"directFlag")));
            }
            if (_con.containsKey((Object)"orgId")) {
                Long orgId = _con.getLong("orgId");
                param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
            if (_con.containsKey((Object)"performWay")) {
                param.getParams().put("performWay", new Parameter("eq", _con.get((Object)"performWay")));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refPurchaseProjectDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchaseProjectDetailVO>> refPurchaseProjectDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, @RequestParam(required=false) String relyCondition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u91c7\u8d2d\u9879\u76ee\uff01");
        }
        Long planId = Long.valueOf(relyCondition.split("=")[1]);
        param.getParams().put("pid", new Parameter("eq", (Object)planId));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            planId = JSONObject.parseObject((String)condition);
        }
        IPage page = this.detailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseProjectDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refPurchaseProjectSupplierData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchaseProjectSupplierVO>> refPurchaseProjectSupplierData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, @RequestParam(required=false) String relyCondition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u91c7\u8d2d\u9879\u76ee\uff01");
        }
        Long planId = Long.valueOf(relyCondition.split("=")[1]);
        param.getParams().put("pid", new Parameter("eq", (Object)planId));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            planId = JSONObject.parseObject((String)condition);
        }
        IPage page = this.supplierService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseProjectSupplierVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    static {
        codeRuleMap.put(BusinessTypeEnum.HUO_WU.getCode(), "PURCHASE_PROJECT_CODE");
        codeRuleMap.put(BusinessTypeEnum.GONG_CHENG.getCode(), "PURCHASE_PROJECT_GC_CODE");
        codeRuleMap.put(BusinessTypeEnum.FU_WU.getCode(), "PURCHASE_PROJECT_FW_CODE");
    }
}

