/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.perform.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.perform.bean.CandidateEntity;
import com.ejianc.business.procurement.perform.bean.PurchaseProjectEntity;
import com.ejianc.business.procurement.perform.bean.ResultEntity;
import com.ejianc.business.procurement.perform.consts.NobidMethodEnum;
import com.ejianc.business.procurement.perform.service.ICandidateService;
import com.ejianc.business.procurement.perform.service.IPurchaseProjectService;
import com.ejianc.business.procurement.perform.service.IResultService;
import com.ejianc.business.procurement.perform.vo.PurchaseProjectSupplierVO;
import com.ejianc.business.procurement.perform.vo.PurchaseProjectVO;
import com.ejianc.business.procurement.perform.vo.ResultDetailVO;
import com.ejianc.business.procurement.perform.vo.ResultSupplierVO;
import com.ejianc.business.procurement.perform.vo.ResultVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"result"})
public class ResultController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String HW_BILL_CODE = "HW-RESULT-CODE";
    private static final String GC_BILL_CODE = "GC-RESULT-CODE";
    private static final String FW_BILL_CODE = "FW-RESULT-CODE";
    @Autowired
    private IResultService service;
    @Autowired
    private IPurchaseProjectService purchaseProjectService;
    @Autowired
    private ICandidateService candidateService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ResultVO> saveOrUpdate(@RequestBody ResultVO saveOrUpdateVO) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ResultEntity::getPurchaseProjectId, (Object)saveOrUpdateVO.getPurchaseProjectId());
        wrapper.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        if (this.service.count((Wrapper)wrapper) > 0) {
            return CommonResponse.error((String)"\u8be5\u91c7\u8d2d\u9879\u76ee\u5df2\u5b58\u5728\u4e00\u6761\u91c7\u8d2d\u7ed3\u679c\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        saveOrUpdateVO.sumDetailList();
        saveOrUpdateVO.sumSupplierList();
        ResultEntity entity = (ResultEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ResultEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            String billcode = "";
            if ("1".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = GC_BILL_CODE;
            } else if ("2".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = HW_BILL_CODE;
            } else if ("3".equals(saveOrUpdateVO.getBusinessType())) {
                billcode = FW_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)billcode, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ResultVO vo = (ResultVO)BeanMapper.map((Object)((Object)entity), ResultVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ResultVO> queryDetail(Long id) {
        ResultEntity entity = (ResultEntity)((Object)this.service.selectById(id));
        ResultVO vo = (ResultVO)BeanMapper.map((Object)((Object)entity), ResultVO.class);
        vo.splitDetailList();
        vo.splitSupplierList();
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ResultVO> queryDetailByProjectId(Long purchaseProjectId, Long id) {
        LambdaQueryWrapper resultWrapper = Wrappers.lambdaQuery();
        resultWrapper.eq(ResultEntity::getPurchaseProjectId, (Object)purchaseProjectId);
        resultWrapper.ne(id != null, BaseEntity::getId, (Object)id);
        if (this.service.count((Wrapper)resultWrapper) > 0) {
            return CommonResponse.error((String)"\u8be5\u91c7\u8d2d\u9879\u76ee\u5df2\u5b58\u5728\u4e00\u6761\u91c7\u8d2d\u7ed3\u679c\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        ResultVO vo = new ResultVO();
        PurchaseProjectEntity purchaseProjectEntity = (PurchaseProjectEntity)((Object)this.purchaseProjectService.selectById(purchaseProjectId));
        PurchaseProjectVO projectVO = (PurchaseProjectVO)BeanMapper.map((Object)((Object)purchaseProjectEntity), PurchaseProjectVO.class);
        projectVO.getDetailList().forEach(e -> e.setSourceId(e.getId().toString()));
        vo.setResultDetailList(BeanMapper.mapList((Iterable)projectVO.getDetailList(), ResultDetailVO.class));
        vo.splitDetailList();
        if ("1".equals(purchaseProjectEntity.getPerformWay())) {
            if (1 != purchaseProjectEntity.getPermissionType()) {
                LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
                wrapper.eq(CandidateEntity::getPurchaseProjectId, (Object)purchaseProjectId);
                CandidateEntity candidateEntity = (CandidateEntity)((Object)this.candidateService.getOne((Wrapper)wrapper));
                candidateEntity.getCandidateSupplierList().forEach(e -> {
                    e.setSourceType("3");
                    e.setSourceId(e.getId().toString());
                });
                vo.setResultSupplierList(BeanMapper.mapList(candidateEntity.getCandidateSupplierList(), ResultSupplierVO.class));
                vo.splitSupplierList();
            }
        } else if (NobidMethodEnum.ZHI_JIE.getCode() == purchaseProjectEntity.getNobidMethod()) {
            vo.setResultSupplierList1(BeanMapper.mapList((Iterable)projectVO.getSupplierList(), ResultSupplierVO.class));
            ((ResultSupplierVO)vo.getResultSupplierList1().get(0)).setSourceId(((PurchaseProjectSupplierVO)projectVO.getSupplierList().get(0)).getId().toString());
            ((ResultSupplierVO)vo.getResultSupplierList1().get(0)).setSourceType("4");
        } else if (NobidMethodEnum.JIAN_YI.getCode() != purchaseProjectEntity.getNobidMethod() && 1 != purchaseProjectEntity.getPermissionType()) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(CandidateEntity::getPurchaseProjectId, (Object)purchaseProjectId);
            CandidateEntity candidateEntity = (CandidateEntity)((Object)this.candidateService.getOne((Wrapper)wrapper));
            candidateEntity.getCandidateSupplierList().forEach(e -> {
                e.setSourceType("3");
                e.setSourceId(e.getId().toString());
            });
            vo.setResultSupplierList(BeanMapper.mapList(candidateEntity.getCandidateSupplierList(), ResultSupplierVO.class));
            vo.splitSupplierList();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ResultVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ResultVO resultVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ResultVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ResultVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Result-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refResultData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ResultVO>> refResultData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ResultVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelDetailExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelDetailExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List list = new ArrayList();
        Integer lot = Integer.getInteger(((Parameter)param.getParams().get("lot")).getValue().toString());
        if (param.getParams().containsKey("id")) {
            Long id = Long.valueOf(((Parameter)param.getParams().get("id")).getValue().toString());
            ResultEntity resultEntity = (ResultEntity)((Object)this.service.selectById(id));
            list = BeanMapper.mapList((Iterable)resultEntity.getResultDetailList().stream().filter(entity -> entity.getLot() == lot).collect(Collectors.toList()), ResultDetailVO.class);
        } else {
            Long purchaseProjectId = Long.valueOf(((Parameter)param.getParams().get("purchaseProjectId")).getValue().toString());
            PurchaseProjectEntity purchaseProjectEntity = (PurchaseProjectEntity)((Object)this.purchaseProjectService.selectById(purchaseProjectId));
            list = BeanMapper.mapList((Iterable)purchaseProjectEntity.getDetailList().stream().filter(entity -> entity.getLot() == lot).collect(Collectors.toList()), ResultDetailVO.class);
            list.forEach(e -> e.setSourceId(e.getId().toString()));
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("ResultDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ResultDetailVO> successList = new ArrayList<ResultDetailVO>();
        ArrayList<ResultDetailVO> errorList = new ArrayList<ResultDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 2; i < result.size(); ++i) {
                ResultDetailVO detailVO;
                block11: {
                    String sourceId;
                    List datas;
                    block10: {
                        datas = (List)result.get(i);
                        detailVO = new ResultDetailVO();
                        detailVO.setId(Long.valueOf(IdWorker.getId()));
                        sourceId = (String)datas.get(0);
                        detailVO.setSourceId(sourceId);
                        if (ObjectUtils.isNotEmpty(datas.get(18))) {
                            try {
                                detailVO.setWinbidDetailTaxPrice(BigDecimal.valueOf(Double.parseDouble((String)datas.get(18))));
                                break block10;
                            }
                            catch (Exception e) {
                                detailVO.setErrorCode(sourceId);
                                detailVO.setErrorMsg("\u4e2d\u6807\u542b\u7a0e\u5355\u4ef7\u683c\u5f0f\u9519\u8bef\uff01");
                                errorList.add(detailVO);
                                continue;
                            }
                        }
                        detailVO.setErrorCode(sourceId);
                        detailVO.setErrorMsg("\u4e2d\u6807\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                    if (ObjectUtils.isNotEmpty(datas.get(19))) {
                        try {
                            detailVO.setWinbidDetailPrice(BigDecimal.valueOf(Double.parseDouble((String)datas.get(19))));
                            break block11;
                        }
                        catch (Exception e) {
                            detailVO.setErrorCode(sourceId);
                            detailVO.setErrorMsg("\u4e2d\u6807\u65e0\u7a0e\u5355\u4ef7\u683c\u5f0f\u9519\u8bef\uff01");
                            errorList.add(detailVO);
                            continue;
                        }
                    }
                    detailVO.setErrorCode(sourceId);
                    detailVO.setErrorMsg("\u4e2d\u6807\u65e0\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

