package com.ejianc.business.production.task.api;


import com.ejianc.business.production.task.hystrix.ProductionTaskHystrix;
import com.ejianc.business.production.task.vo.ProductionTaskApiVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.ejianc.framework.core.response.CommonResponse;

/**
 * 中建科技项目rpc服务
 * 关闭生产任务单自动生成销售单
 * @author cJ
 *
 */
@FeignClient(name= "ejc-production-web", url="${common.env.feign-client-url}", path="ejc-production-web", fallback = ProductionTaskHystrix.class)
public interface ProductionTaskApi {

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @PostMapping("/api/production/productiontaskApi/getproductiontask")
    CommonResponse<ProductionTaskApiVo> getproductiontask(@RequestBody ProductionTaskApiVo productionTaskApiVo);

//    /**
//     * @Description saveOrUpdate 新增或者修改
//     */
//    @PostMapping("/api/sale/productiontaskApi/saveWeighinginfo")
//    CommonResponse<WeighinginfoApiVO> saveWeighinginfo(@RequestBody WeighinginfoApiVO weighinginfoApiVO);
}