package com.ejianc.business.production.task.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 任务单运输信息
 * 
 * @author generator
 * 
 */
public class TasktransportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    

    private BigDecimal transportCount; // 运输重量
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date transportTime; // 运输时间
    private Long unitId; // 机组id
    private String unitName; // 机组名称


    @ReferSerialTransfer(referCode="UnitRef")
    public Long getUnitId() {
        return unitId;
    }
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public BigDecimal getTransportCount() {
        return transportCount;
    }

    public void setTransportCount(BigDecimal transportCount) {
        this.transportCount = transportCount;
    }

    public Date getTransportTime() {
        return transportTime;
    }

    public void setTransportTime(Date transportTime) {
        this.transportTime = transportTime;
    }
}
