package com.ejianc.business.production.task.api;


import com.ejianc.business.production.task.hystrix.ProductionTaskHystrix;
import com.ejianc.business.production.task.vo.DelivergoodsVO;
import com.ejianc.business.production.task.vo.ProductionTaskApiVo;
import com.ejianc.business.production.task.vo.TasktransportVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;


import com.ejianc.framework.core.response.CommonResponse;

/**
 * 中建科技项目rpc服务
 * 关闭生产任务单自动生成销售单
 * @author cJ
 *
 */
@FeignClient(name= "ejc-production-web", url="${common.env.feign-client-url}", path="ejc-production-web", fallback = ProductionTaskHystrix.class)
public interface ProductionTaskApi {

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @PostMapping("/api/production/productiontaskApi/getproductiontask")
    @ResponseBody
    CommonResponse<ProductionTaskApiVo> getproductiontask(@RequestParam(value = "taskId") String taskId,@RequestParam(value = "carCode") String carCode);

    /**
     * @Description saveOrUpdate 查找任务单信息
     */
    @GetMapping("/api/production/productiontaskApi/getdeliver")
    @ResponseBody
    CommonResponse<DelivergoodsVO> getDeliver(@RequestParam(value = "carCode") String carCode, @RequestParam(value = "orgId") String orgId, @RequestParam(value = "transportTime") String transportTime);

    /**
     * 更新任务单运输信息状态和车辆状态
     * @param transportId
     * @param status
     * @return
     */
    @GetMapping(value = "/api/production/productiontaskApi/updateTransportState")
    @ResponseBody
    CommonResponse updateTransportState(@RequestParam(value = "transportId") Long transportId, @RequestParam(value = "status") Integer status);
    @PostMapping(value = "/updateTransport")
    @ResponseBody
    CommonResponse updateTransport(@RequestBody TasktransportVO tasktransportVO);

}