package com.ejianc.business.production.task.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.production.task.hystrix.DistributeCarManageHystrix;
import com.ejianc.business.production.task.hystrix.ProductionTaskHystrix;
import com.ejianc.business.production.task.vo.UnitdistributionVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/6/24
 * @description:中东派车管理相关接口
 */
@FeignClient(name= "ejc-production-web", url="${common.env.feign-client-url}", path="ejc-production-web", fallback = DistributeCarManageHystrix.class)
public interface DistributeCarManageApi {
    /**
     * 查询所有分配机组数据
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<IPage<UnitdistributionVO>> queryList(@RequestBody QueryParam param);
}
