package com.ejianc.business.production.task.api;


import com.ejianc.business.production.task.hystrix.ProductionTaskHystrix;
import com.ejianc.business.production.task.vo.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;


import com.ejianc.framework.core.response.CommonResponse;

import java.util.List;
import java.util.Map;

/**
 * 中建科技项目rpc服务
 * 关闭生产任务单自动生成销售单
 * @author cJ
 *
 */
@FeignClient(name= "ejc-production-web", url="${common.env.feign-client-url}", path="ejc-production-web", fallback = ProductionTaskHystrix.class)
public interface ProductionTaskApi {

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @PostMapping("/api/production/productiontaskApi/getproductiontask")
    @ResponseBody
    CommonResponse<ProductionTaskApiVo> getproductiontask(@RequestParam(value = "taskId") String taskId,@RequestParam(value = "carCode") String carCode);

    /**
     * @Description saveOrUpdate 查找任务单信息
     */
    @GetMapping("/api/production/productiontaskApi/getdeliver")
    @ResponseBody
    CommonResponse<DelivergoodsVO> getDeliver(@RequestParam(value = "carCode") String carCode, @RequestParam(value = "orgId") String orgId, @RequestParam(value = "transportTime") String transportTime);

    /**
     * 更新任务单运输信息状态和车辆状态
     * @param transportId
     * @param status
     * @return
     */
    @GetMapping(value = "/api/production/productiontaskApi/updateTransportState")
    @ResponseBody
    CommonResponse updateTransportState(@RequestParam(value = "transportId") Long transportId, @RequestParam(value = "status") Integer status);

    /**
     *更新生产任务单分配车辆发货信息
     * @param tasktransportVO
     * @return
     */
    @PostMapping(value = "/api/production/productiontaskApi/updateTransport")
    @ResponseBody
    CommonResponse updateTransport(@RequestBody TasktransportVO tasktransportVO);

    /**
     * 查询生产任务单分配车辆信息
     * @param taskId
     * @return List<TaskDistributeCarVO>
     */
    @GetMapping(value = "/api/production/productiontaskApi/queryshipment")
    @ResponseBody
    CommonResponse<Map<String, Object>> queryShipment(@RequestParam(value = "taskId") Long taskId);

    /**
     * 查询任务单下所有生产任务单运输信息
     * @param orgId
     * @return
     */
    @PostMapping(value = "/api/production/productiontaskApi/queryunitdistribute")
    @ResponseBody
    CommonResponse<List<ProductionTaskVO>> queryUnitdistribute(@RequestBody Long orgId);
    /**
     * 查询生产任务单下分配机组发货车辆信息
     * @param
     * @return
     */
    @GetMapping(value = "/api/production/productiontaskApi/queryunitdistributedetail")
    @ResponseBody
    CommonResponse<List<TasktransportVO>> queryUnitdistributeDetail(@RequestParam(value = "unitdistributeId") Long unitdistributeId);
}
