package com.ejianc.business.production.task.api;

import com.ejianc.business.production.task.hystrix.ProductionTaskHystrix;
import com.ejianc.business.production.task.hystrix.SynchronizedDataHystrix;
import com.ejianc.business.production.task.vo.ProductionCarVO;
import com.ejianc.business.production.task.vo.ProductionUnitVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/8/22
 * @description:
 */
@FeignClient(name= "ejc-production-web", url="${common.env.feign-client-url}", path="ejc-production-web", fallback = SynchronizedDataHystrix.class)
public interface SynchronizedDataApi {
    /**
     * 查询分配机组相关数据
     * @param orgId
     * @return
     */
    @GetMapping(value = "/api/production/queryApi/queryunitdistribute")
    @ResponseBody
    CommonResponse<List<ProductionUnitVO>> queryUnitdistribute(Long orgId);

    /**
     * 查询分配车辆相关数据
     * @param orgId
     * @return
     */
    @GetMapping(value = "/api/production/queryApi/queryunitdistributecar")
    @ResponseBody
    CommonResponse<List<ProductionCarVO>> queryUnitdistributeCar(Long orgId);
}
