package com.ejianc.business.production.task.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 分配机组
 * 
 * @author generator
 * 
 */
public class ProductionOrderVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long unitId; // 机组id
    private String unitName; // 机组名称
    private BigDecimal distributeCount; // 分配数量
    private Long productId; // 产品id
    private String productName; // 产品名称
    private Long customerManageId; // 客户管理档案id
    private String customerManageName; // 客户管理档案名称
    private Long projectId; // 工程id
    private String projectName; // 工程名称
    private Long worksiteId; // 工地id
    private String worksiteName; // 工地名称
    private BigDecimal notDistributeCount; // 未分配数量
    private BigDecimal distributedCount; // 已分配数量
    private Integer isAddCar; // 是否增派车辆 ：1 否 2 是
    private BigDecimal distance; // 运距
    private BigDecimal notWeighNumber; // 未过磅数量
    private BigDecimal notProductCount; // 未生产数量
    private Long taskId; // 任务单id
    private BigDecimal weighNumber; // 过磅数
    private BigDecimal productedCount; // 已生产数量
    private List<ProductionOrderDetailVO> taskTransportList = new ArrayList<>(); // 运费维护子表




    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="UnitRef")
    public Long getUnitId() {
        return unitId;
    }
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getDistributeCount() {
        return distributeCount;
    }

    public void setDistributeCount(BigDecimal distributeCount) {
        this.distributeCount = distributeCount;
    }
    @ReferSerialTransfer(referCode="ProductorInfoRef")
    public Long getProductId() {
        return productId;
    }
    @ReferDeserialTransfer
    public void setProductId(Long productId) {
        this.productId = productId;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    @ReferSerialTransfer(referCode="CustomerinfoRef")
    public Long getCustomerManageId() {
        return customerManageId;
    }
    @ReferDeserialTransfer
    public void setCustomerManageId(Long customerManageId) {
        this.customerManageId = customerManageId;
    }
    public String getCustomerManageName() {
        return customerManageName;
    }

    public void setCustomerManageName(String customerManageName) {
        this.customerManageName = customerManageName;
    }
    @ReferSerialTransfer(referCode="ProjectInfoRef")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="ConstructionsiteRef")
    public Long getWorksiteId() {
        return worksiteId;
    }
    @ReferDeserialTransfer
    public void setWorksiteId(Long worksiteId) {
        this.worksiteId = worksiteId;
    }
    public String getWorksiteName() {
        return worksiteName;
    }

    public void setWorksiteName(String worksiteName) {
        this.worksiteName = worksiteName;
    }

    public BigDecimal getNotDistributeCount() {
        return notDistributeCount;
    }

    public void setNotDistributeCount(BigDecimal notDistributeCount) {
        this.notDistributeCount = notDistributeCount;
    }

    public BigDecimal getDistributedCount() {
        return distributedCount;
    }

    public void setDistributedCount(BigDecimal distributedCount) {
        this.distributedCount = distributedCount;
    }


    public List<ProductionOrderDetailVO> getTaskTransportList() {
        return taskTransportList;
    }

    public void setTaskTransportList(List<ProductionOrderDetailVO> taskTransportList) {
        this.taskTransportList = taskTransportList;
    }

    public Integer getIsAddCar() {
        return isAddCar;
    }

    public void setIsAddCar(Integer isAddCar) {
        this.isAddCar = isAddCar;
    }

    public BigDecimal getDistance() {
        return distance;
    }

    public void setDistance(BigDecimal distance) {
        this.distance = distance;
    }

    public BigDecimal getNotWeighNumber() {
        return notWeighNumber;
    }

    public void setNotWeighNumber(BigDecimal notWeighNumber) {
        this.notWeighNumber = notWeighNumber;
    }

    public BigDecimal getNotProductCount() {
        return notProductCount;
    }

    public void setNotProductCount(BigDecimal notProductCount) {
        this.notProductCount = notProductCount;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public BigDecimal getWeighNumber() {
        return weighNumber;
    }

    public void setWeighNumber(BigDecimal weighNumber) {
        this.weighNumber = weighNumber;
    }

    public BigDecimal getProductedCount() {
        return productedCount;
    }

    public void setProductedCount(BigDecimal productedCount) {
        this.productedCount = productedCount;
    }
}
