package com.ejianc.business.production.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.bean.ProductiontaskEntity;
import com.ejianc.business.production.service.IProductiontaskService;
import com.ejianc.business.production.vo.ProductiontaskVO;
import com.ejianc.business.production.vo.ProductiontasktransportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.logging.SimpleFormatter;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.production.bean.UnitdistributionEntity;
import com.ejianc.business.production.service.IUnitdistributionService;
import com.ejianc.business.production.vo.UnitdistributionVO;

/**
 * 分配机组
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("unitdistribution")
public class UnitdistributionController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProductiontaskService productiontaskService;

    private static final String BILL_CODE = "unit-distribution";//此处需要根据实际修改

    @Autowired
    private IUnitdistributionService service;

    @Autowired
    private SessionManager sessionManager;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UnitdistributionVO> saveOrUpdate(@RequestBody UnitdistributionVO saveOrUpdateVO) {
    	UnitdistributionEntity entity = BeanMapper.map(saveOrUpdateVO, UnitdistributionEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            entity.setProductState(1);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

        }
        ProductiontaskEntity productiontaskEntity = productiontaskService.selectById(entity.getTaskId());
        if (productiontaskEntity != null){
            productiontaskEntity.setTaskStatus(2);
            productiontaskService.saveOrUpdate(productiontaskEntity,false);
        }else{
            throw new BusinessException(entity.getTaskCode()+"生产任务单未找到");
        }
    	service.saveOrUpdate(entity, false);
    	UnitdistributionVO vo = BeanMapper.map(entity, UnitdistributionVO.class);

    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UnitdistributionVO> queryDetail(Long id) {
    	UnitdistributionEntity entity = service.selectById(id);
    	UnitdistributionVO vo = BeanMapper.map(entity, UnitdistributionVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UnitdistributionVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (UnitdistributionVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(UnitdistributionVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UnitdistributionVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<UnitdistributionEntity> page = service.queryPage(param,false);
        IPage<UnitdistributionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), UnitdistributionVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<UnitdistributionEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Unitdistribution-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refUnitdistributionData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UnitdistributionVO>> refUnitdistributionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<UnitdistributionEntity> page = service.queryPage(param,false);
        IPage<UnitdistributionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), UnitdistributionVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * 页面跳转查询生产任务单
     *
     * @param taskId
     * @return
     */
    @GetMapping(value = "queryDetailBytaskId")
    @ResponseBody
    public CommonResponse<UnitdistributionVO> queryDetailBytaskId(@RequestParam(value = "taskId") Long taskId) {
        ProductiontaskEntity entity = productiontaskService.selectById(taskId);
        UnitdistributionEntity unitdistributionEntity=new UnitdistributionEntity();
        unitdistributionEntity.setTaskId(entity.getId());
        unitdistributionEntity.setTaskCode(entity.getBillCode());
        unitdistributionEntity.setProductId(entity.getProductId());
        unitdistributionEntity.setProductName(entity.getProductName());
        unitdistributionEntity.setCustomerManageId(entity.getCustomerManageId());
        unitdistributionEntity.setCustomerManageName(entity.getCustomerManageName());
        unitdistributionEntity.setProjectId(entity.getProjectId());
        unitdistributionEntity.setProjectName(entity.getProjectName());
        unitdistributionEntity.setProductId(entity.getProductId());
        unitdistributionEntity.setProductName(entity.getProductName());
        unitdistributionEntity.setWorksiteId(entity.getWorksiteId());
        unitdistributionEntity.setWorksiteName(entity.getWorksiteName());
        unitdistributionEntity.setOrgId(entity.getOrgId());
        unitdistributionEntity.setOrgName(entity.getOrgName());
        unitdistributionEntity.setSatrtTime(entity.getTaskTime());
        unitdistributionEntity.setQuantity(entity.getThisQuantity());
        UnitdistributionVO unitdistributionVO=BeanMapper.map(unitdistributionEntity,UnitdistributionVO.class);
        return CommonResponse.success("查询详情成功！", unitdistributionVO);
    }
    /**
     * 页面跳转查询生产任务单
     *
     * @param addId
     * @return
     */
    @GetMapping(value = "queryDetailByAddId")
    @ResponseBody
    public CommonResponse<UnitdistributionVO> queryDetailByAddId(@RequestParam(value = "addId") Long addId) {
        UnitdistributionEntity unitdistributionEntity = service.selectById(addId);
        UnitdistributionVO unitdistributionVO=BeanMapper.map(unitdistributionEntity,UnitdistributionVO.class);
        return CommonResponse.success("查询详情成功！", unitdistributionVO);
    }

    /**
     * 分配机组保存
     * @param params
     * @return CommonResponse<List<UnitdistributionVO>>
     * @throws ParseException
     */
    @GetMapping(value = "distributeUnit")
    @ResponseBody
    public CommonResponse<List<UnitdistributionVO>> distributeUnit(@RequestBody String params) throws ParseException {
        JSONObject object = JSONObject.parseObject(params);
        Long taskId = object.getLong("taskId");
        JSONArray unitArray = object.getJSONArray("unit");
        ProductiontaskEntity productiontaskEntity = productiontaskService.selectById(taskId);
        List<UnitdistributionEntity> unitdistributionList=new ArrayList<>();
        List<Map> maps = unitArray.toJavaList(Map.class);
        for (Map map : maps) {
            UnitdistributionEntity unitdistributionEntity = new UnitdistributionEntity();
            if (!(map.get("startTime")==null&&map.get("distributeCount")==null&&map.get("endTime")==null)){
                unitdistributionEntity.setTaskId(productiontaskEntity.getId());
                unitdistributionEntity.setTaskCode(productiontaskEntity.getBillCode());
                unitdistributionEntity.setCustomerManageId(productiontaskEntity.getCustomerManageId());
                unitdistributionEntity.setCustomerManageName(productiontaskEntity.getCustomerManageName());
                unitdistributionEntity.setProjectId(productiontaskEntity.getProjectId());
                unitdistributionEntity.setProjectName(productiontaskEntity.getProjectName());
                unitdistributionEntity.setProductId(productiontaskEntity.getProductId());
                unitdistributionEntity.setProductName(productiontaskEntity.getProductName());
                unitdistributionEntity.setWorksiteId(productiontaskEntity.getWorksiteId());
                unitdistributionEntity.setWorksiteName(productiontaskEntity.getWorksiteName());
                unitdistributionEntity.setQuantity(productiontaskEntity.getThisQuantity());
                unitdistributionEntity.setTenantId(productiontaskEntity.getTenantId());
                unitdistributionEntity.setProductState(1);
                unitdistributionEntity.setUnitId((Long)map.get("id"));
                unitdistributionEntity.setUnitName(map.get("name").toString());
                unitdistributionEntity.setSatrtTime(new SimpleDateFormat("YYYY-mm-dd HH:mm:ss").parse(map.get("startTime").toString().replace("T"," ").replace(".000Z"," ")));
                unitdistributionEntity.setDistributeCount(new BigDecimal((String) map.get("distributeCount")));
                unitdistributionEntity.setEndTime(new SimpleDateFormat("YYYY-mm-dd HH:mm:ss").parse(map.get("endTime").toString().replace("T"," ").replace(".000Z"," ")));
                unitdistributionEntity.setAddCount(new BigDecimal(0));
                unitdistributionEntity.setAddedCount(new BigDecimal(0));
                unitdistributionEntity.setWeighNumber(new BigDecimal(0));
                unitdistributionEntity.setNotWeighNumber(new BigDecimal(0));
                unitdistributionEntity.setAddCount(new BigDecimal(0));
                unitdistributionEntity.setAddedCount(new BigDecimal(0));
                UnitdistributionVO unitdistributionVO = BeanMapper.map(unitdistributionEntity, UnitdistributionVO.class);
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),unitdistributionVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                    unitdistributionEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
               service.save(unitdistributionEntity);
               unitdistributionList.add(unitdistributionEntity);
            }
        }
        List<UnitdistributionVO> unitdistributionVOS=BeanMapper.mapList(unitdistributionList, UnitdistributionVO.class);
        return CommonResponse.success("分配机组成功",unitdistributionVOS);
    }
    /**
     * 分配机组展示
     * 根据生产任务单状态查找生产状态的生产任务单并获取生产任务单id
     * 根据获取的生产任务单id查找分配机组数据
     * @param taskId
     * @return CommonResponse<List<UnitdistributionVO>>
     *
     */
    @GetMapping(value = "showdistribute")
    @ResponseBody
    public CommonResponse<List<UnitdistributionVO>> showdistribute(@RequestParam(value = "taskId") Long taskId) {
        QueryWrapper query=new QueryWrapper();
        query.eq("task_id",taskId);
        query.eq("product_state",1);
        query.eq("dr",0);
        List<UnitdistributionEntity> list = service.list(query);
        List<UnitdistributionVO> unitdistributionVOS = BeanMapper.mapList(list, UnitdistributionVO.class);
        return CommonResponse.success("查询机组成功",unitdistributionVOS);
    }
    /**
     * 关闭任务单
     * 根据分配机组id获取任务单id
     * 查找任务单id中所有的分配机组记录
     * 判断查找的分配机组记录条数，
     *    大于1判断这些分配机组生产状态是否都生产完成，全部生产完成同时修改任务单生产状态
     *      如果修改任务单状态则获取任务单相关数据生成销售单
     *    否则只修改此id的分配机组生产状态
     *
     * @param id
     * @return CommonResponse<List<UnitdistributionVO>>
     *
     */
    @GetMapping(value = "closeProductionTask")
    @ResponseBody
    public CommonResponse<UnitdistributionVO> closeProductionTask(@RequestParam(value = "id") Long id) {
        boolean loop=true;
        UnitdistributionEntity unitdistributionEntity = service.selectById(id);
        Long taskId = unitdistributionEntity.getTaskId();
        QueryWrapper query=new QueryWrapper();
        query.eq("task_id",taskId);
        query.eq("dr",0);
        List<UnitdistributionEntity> list = service.list(query);
        if (list.size()>0&&list.size()>1){
            for (UnitdistributionEntity entity : list) {
                if (entity.getProductState()==1){
                    loop=false;
                }
            }
        }
        if (loop){
            ProductiontaskEntity entity = productiontaskService.selectById(taskId);
            entity.setTaskStatus(4);
            productiontaskService.saveOrUpdate(entity,false);
        }
        unitdistributionEntity.setProductState(2);
        service.saveOrUpdate(unitdistributionEntity,false);
        UnitdistributionVO unitdistributionVO = BeanMapper.map(unitdistributionEntity, UnitdistributionVO.class);
        return CommonResponse.success("关闭此单成功",unitdistributionVO);
    }
    /**
     * 分配机组展示
     * 根据生产任务单状态查找生产状态的生产任务单并获取生产任务单id
     * 根据获取的生产任务单id查找分配机组数据
     * @param unitId
     * @param orgId
     * @return CommonResponse<List<UnitdistributionVO>>
     *
     */
    @GetMapping(value = "queryListById")
    @ResponseBody
    public CommonResponse<List<UnitdistributionVO>> queryListById(@RequestParam(value = "unitId") Long unitId,@RequestParam(value = "orgId") Long orgId) {
        QueryWrapper query=new QueryWrapper();
        query.eq("unit_id",unitId);
        query.eq("org_id",orgId);
        query.eq("product_state",1);
        query.eq("dr",0);
        List<UnitdistributionEntity> list = service.list(query);
        List<UnitdistributionVO> unitdistributionVOS = BeanMapper.mapList(list, UnitdistributionVO.class);
        return CommonResponse.success("查询机组任务成功",unitdistributionVOS);
    }
}
