package com.ejianc.business.production.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 生产任务单变更
 * 
 * @author generator
 * 
 */
public class ProductiontaskchangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long taskId; // 生产任务单id
    private String taskCode; // 生产任务单单号
    private Long projectId; // 工程id
    private String projectName; // 工程名称
    private Long worksiteId; // 工地id
    private String worksiteName; // 工地名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long productId; // 产品id
    private String productName; // 产品名称
    private String asphaltAndAdditives; // 沥青及添加剂
    private BigDecimal quantity; // 数量
    private BigDecimal weighNumber; // 过磅数
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskTime; // 任务时间
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="ProductiontaskRef")
    public Long getTaskId() {
        return taskId;
    }
    @ReferDeserialTransfer
    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }
    public String getTaskCode() {
        return taskCode;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }
    @ReferSerialTransfer(referCode="ProjectInfoRef")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="ConstructionsiteRef")
    public Long getWorksiteId() {
        return worksiteId;
    }
    @ReferDeserialTransfer
    public void setWorksiteId(Long worksiteId) {
        this.worksiteId = worksiteId;
    }
    public String getWorksiteName() {
        return worksiteName;
    }

    public void setWorksiteName(String worksiteName) {
        this.worksiteName = worksiteName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="ProductorInfoRef")
    public Long getProductId() {
        return productId;
    }
    @ReferDeserialTransfer
    public void setProductId(Long productId) {
        this.productId = productId;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public String getAsphaltAndAdditives() {
        return asphaltAndAdditives;
    }

    public void setAsphaltAndAdditives(String asphaltAndAdditives) {
        this.asphaltAndAdditives = asphaltAndAdditives;
    }
    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }
    public BigDecimal getWeighNumber() {
        return weighNumber;
    }

    public void setWeighNumber(BigDecimal weighNumber) {
        this.weighNumber = weighNumber;
    }
    public Date getTaskTime() {
        return taskTime;
    }

    public void setTaskTime(Date taskTime) {
        this.taskTime = taskTime;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    
}
