package com.ejianc.business.production.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 工地生产订单
 * 
 * @author generator
 * 
 */
public class SiteorderVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private String code; // 订单号
    private Long taskId; // 生产任务单id
    private String taskCode; // 生产任务单单号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planTime; // 计划日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date schedulTime; // 排产时间
    private Long productId; // 产品id
    private String productName; // 产品名称
    private String mixModel; // 配比型号
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String siteRequirement; // 工地要求
    private BigDecimal siteTotal; // 工地总量
    private BigDecimal thisPlan; // 本次计划数量
    private BigDecimal schedulTotal; // 已排产数量
    private BigDecimal deliverTotal; // 已发货数量
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    @ReferSerialTransfer(referCode="ProductiontaskRef")
    public Long getTaskId() {
        return taskId;
    }
    @ReferDeserialTransfer
    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }
    public String getTaskCode() {
        return taskCode;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }
    public Date getPlanTime() {
        return planTime;
    }

    public void setPlanTime(Date planTime) {
        this.planTime = planTime;
    }
    public Date getSchedulTime() {
        return schedulTime;
    }

    public void setSchedulTime(Date schedulTime) {
        this.schedulTime = schedulTime;
    }
    @ReferSerialTransfer(referCode="ProjectInfoRef")
    public Long getProductId() {
        return productId;
    }
    @ReferDeserialTransfer
    public void setProductId(Long productId) {
        this.productId = productId;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public String getMixModel() {
        return mixModel;
    }

    public void setMixModel(String mixModel) {
        this.mixModel = mixModel;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getSiteRequirement() {
        return siteRequirement;
    }

    public void setSiteRequirement(String siteRequirement) {
        this.siteRequirement = siteRequirement;
    }
    public BigDecimal getSiteTotal() {
        return siteTotal;
    }

    public void setSiteTotal(BigDecimal siteTotal) {
        this.siteTotal = siteTotal;
    }
    public BigDecimal getThisPlan() {
        return thisPlan;
    }

    public void setThisPlan(BigDecimal thisPlan) {
        this.thisPlan = thisPlan;
    }
    public BigDecimal getSchedulTotal() {
        return schedulTotal;
    }

    public void setSchedulTotal(BigDecimal schedulTotal) {
        this.schedulTotal = schedulTotal;
    }
    public BigDecimal getDeliverTotal() {
        return deliverTotal;
    }

    public void setDeliverTotal(BigDecimal deliverTotal) {
        this.deliverTotal = deliverTotal;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    
}
