package com.ejianc.business.production.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 班组交接单
 * 
 * @author generator
 * 
 */
public class TeamhandoverVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long thisTeamId; // 本班组id
    private String thisTeamName; // 本班组名称
    private Long preTeamId; // 上班组id
    private String preTeamName; // 上班组名称
    private Long taskId; // 生产任务单id
    private String taskCode; // 生产任务单单号
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private BigDecimal productFinishQuality; // 生产完成数量
    private BigDecimal productUnfinishQuantity; // 未完成数量
    private String handoverTool; // 交接工具
    private String otherMatters; // 其他事项
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="TeamRef")
    public Long getThisTeamId() {
        return thisTeamId;
    }
    @ReferDeserialTransfer
    public void setThisTeamId(Long thisTeamId) {
        this.thisTeamId = thisTeamId;
    }
    public String getThisTeamName() {
        return thisTeamName;
    }

    public void setThisTeamName(String thisTeamName) {
        this.thisTeamName = thisTeamName;
    }
    @ReferSerialTransfer(referCode="TeamRef")
    public Long getPreTeamId() {
        return preTeamId;
    }
    @ReferDeserialTransfer
    public void setPreTeamId(Long preTeamId) {
        this.preTeamId = preTeamId;
    }
    public String getPreTeamName() {
        return preTeamName;
    }

    public void setPreTeamName(String preTeamName) {
        this.preTeamName = preTeamName;
    }
    @ReferSerialTransfer(referCode="ProductiontaskRef")
    public Long getTaskId() {
        return taskId;
    }
    @ReferDeserialTransfer
    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }
    public String getTaskCode() {
        return taskCode;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public BigDecimal getProductFinishQuality() {
        return productFinishQuality;
    }

    public void setProductFinishQuality(BigDecimal productFinishQuality) {
        this.productFinishQuality = productFinishQuality;
    }
    public BigDecimal getProductUnfinishQuantity() {
        return productUnfinishQuantity;
    }

    public void setProductUnfinishQuantity(BigDecimal productUnfinishQuantity) {
        this.productUnfinishQuantity = productUnfinishQuantity;
    }
    public String getHandoverTool() {
        return handoverTool;
    }

    public void setHandoverTool(String handoverTool) {
        this.handoverTool = handoverTool;
    }
    public String getOtherMatters() {
        return otherMatters;
    }

    public void setOtherMatters(String otherMatters) {
        this.otherMatters = otherMatters;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    
}
