package com.ejianc.business.production.vo;

import java.util.Date;
import java.math.*;
import java.util.List;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 生产任务单
 * 
 * @author generator
 * 
 */
public class ProductiontaskVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private String code; // 订单号
    private Long saleOrderId; // 销售订单id
    private Integer productTaskFrom; // 生产任务单来源
    private Long customerManageId; // 客户管理档案id
    private String customerManageName; // 客户管理档案名称
    private Long projectId; // 工程id
    private String projectName; // 工程名称
    private Long worksiteId; // 工地id
    private String worksiteName; // 工地名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String orderName; // 定料人
    private String orderMobile; // 联系电话
    private BigDecimal projectTotle; // 工程总数量
    private BigDecimal orderedQuantity; // 已下数量
    private BigDecimal orderedNot; // 待下数量
    private BigDecimal thisQuantity; // 本次数量
    private Integer countingMethod; // 计数方法
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskTime; // 任务单日期
    private BigDecimal distance; // 距离
    private String remark; // 备注
    private String transportMethod; // 运输方式
    private Long unitId; // 机组id
    private String unitName; // 机组名称
    private Long teamId; // 班组id
    private String teamName; // 班组名称
    private Long productId; // 产品id
    private String productName; // 产品名称
    private Long mixVersionId; // 配比版本主键
    private Long hotMaterialId; // 热料配比主键
    private Long operatorId; // 经办人id
    private String operatorName; // 经办人名称
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    private Long contractId;//销售合同id
    private Integer taskStatus; // 任务单状态：1 已创建 2 已分配 3 已关闭
    private String carCode; // 车号
    private Long regionId; // 区域id
    private String regionName; // 区域名称
    private String transportRoute; // 行车路线
    private String asphaltSpec; // 沥青规格名称
    private String addCount; // 外加剂名称
    private Integer pageIndex;
    private Integer pageSize;

    private List<ProductionTaskDetailVO> productionTaskDetailVOS;

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    @ReferSerialTransfer(referCode="SalesorderRef")
    public Long getSaleOrderId() {
        return saleOrderId;
    }
    @ReferDeserialTransfer
    public void setSaleOrderId(Long saleOrderId) {
        this.saleOrderId = saleOrderId;
    }
    public Integer getProductTaskFrom() {
        return productTaskFrom;
    }

    public void setProductTaskFrom(Integer productTaskFrom) {
        this.productTaskFrom = productTaskFrom;
    }
    @ReferSerialTransfer(referCode="CustomermanageRef")
    public Long getCustomerManageId() {
        return customerManageId;
    }
    @ReferDeserialTransfer
    public void setCustomerManageId(Long customerManageId) {
        this.customerManageId = customerManageId;
    }
    public String getCustomerManageName() {
        return customerManageName;
    }

    public void setCustomerManageName(String customerManageName) {
        this.customerManageName = customerManageName;
    }
    @ReferSerialTransfer(referCode="ProjectInfoRef")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="ConstructionsiteRef")
    public Long getWorksiteId() {
        return worksiteId;
    }
    @ReferDeserialTransfer
    public void setWorksiteId(Long worksiteId) {
        this.worksiteId = worksiteId;
    }
    public String getWorksiteName() {
        return worksiteName;
    }

    public void setWorksiteName(String worksiteName) {
        this.worksiteName = worksiteName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrderName() {
        return orderName;
    }

    public void setOrderName(String orderName) {
        this.orderName = orderName;
    }
    public String getOrderMobile() {
        return orderMobile;
    }

    public void setOrderMobile(String orderMobile) {
        this.orderMobile = orderMobile;
    }
    public BigDecimal getProjectTotle() {
        return projectTotle;
    }

    public void setProjectTotle(BigDecimal projectTotle) {
        this.projectTotle = projectTotle;
    }
    public BigDecimal getOrderedQuantity() {
        return orderedQuantity;
    }

    public void setOrderedQuantity(BigDecimal orderedQuantity) {
        this.orderedQuantity = orderedQuantity;
    }
    public BigDecimal getOrderedNot() {
        return orderedNot;
    }

    public void setOrderedNot(BigDecimal orderedNot) {
        this.orderedNot = orderedNot;
    }
    public BigDecimal getThisQuantity() {
        return thisQuantity;
    }

    public void setThisQuantity(BigDecimal thisQuantity) {
        this.thisQuantity = thisQuantity;
    }
    public Integer getCountingMethod() {
        return countingMethod;
    }

    public void setCountingMethod(Integer countingMethod) {
        this.countingMethod = countingMethod;
    }
    public Date getTaskTime() {
        return taskTime;
    }

    public void setTaskTime(Date taskTime) {
        this.taskTime = taskTime;
    }
    public BigDecimal getDistance() {
        return distance;
    }

    public void setDistance(BigDecimal distance) {
        this.distance = distance;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getTransportMethod() {
        return transportMethod;
    }

    public void setTransportMethod(String transportMethod) {
        this.transportMethod = transportMethod;
    }

    @ReferSerialTransfer(referCode="UnitRef")
    public Long getUnitId() {
        return unitId;
    }
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    @ReferSerialTransfer(referCode="TeamRef")
    public Long getTeamId() {
        return teamId;
    }
    @ReferDeserialTransfer
    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }
    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    @ReferSerialTransfer(referCode="ProductorInfoRef")
    public Long getProductId() {
        return productId;
    }
    @ReferDeserialTransfer
    public void setProductId(Long productId) {
        this.productId = productId;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    @ReferSerialTransfer(referCode="ProductMixRef")
    public Long getMixVersionId() {
        return mixVersionId;
    }
    @ReferDeserialTransfer
    public void setMixVersionId(Long mixVersionId) {
        this.mixVersionId = mixVersionId;
    }
    @ReferSerialTransfer(referCode="ProductMixRef")
    public Long getHotMaterialId() {
        return hotMaterialId;
    }
    @ReferDeserialTransfer
    public void setHotMaterialId(Long hotMaterialId) {
        this.hotMaterialId = hotMaterialId;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getOperatorId() {
        return operatorId;
    }
    @ReferDeserialTransfer
    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    @ReferSerialTransfer(referCode="ContractRef")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Integer getTaskStatus() {
        return taskStatus;
    }

    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getCarCode() {
        return carCode;
    }

    public void setCarCode(String carCode) {
        this.carCode = carCode;
    }
    @ReferSerialTransfer(referCode="RegionRef")
    public Long getRegionId() {
        return regionId;
    }
    @ReferDeserialTransfer
    public void setRegionId(Long regionId) {
        this.regionId = regionId;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getAsphaltSpec() {
        return asphaltSpec;
    }

    public void setAsphaltSpec(String asphaltSpec) {
        this.asphaltSpec = asphaltSpec;
    }

    public String getAddCount() {
        return addCount;
    }

    public void setAddCount(String addCount) {
        this.addCount = addCount;
    }

    public String getTransportRoute() {
        return transportRoute;
    }

    public void setTransportRoute(String transportRoute) {
        this.transportRoute = transportRoute;
    }

    public List<ProductionTaskDetailVO> getProductionTaskDetailVOS() {
        return productionTaskDetailVOS;
    }

    public void setProductionTaskDetailVOS(List<ProductionTaskDetailVO> productionTaskDetailVOS) {
        this.productionTaskDetailVOS = productionTaskDetailVOS;
    }

    public Integer getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
